/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.load.step.weighted;

import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.env.ExtensionBase;
import com.emc.mongoose.base.load.step.LoadStepFactory;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.emc.mongoose.load.step.weighted.WeightedLoadStepClient;
import com.emc.mongoose.load.step.weighted.WeightedLoadStepLocal;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.SchemaProvider;
import com.github.akurilov.confuse.io.yaml.YamlSchemaProviderBase;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class WeightedLoadStepExtension<T extends WeightedLoadStepLocal, U extends WeightedLoadStepClient>
extends ExtensionBase
implements LoadStepFactory<T, U> {
    public static final String TYPE = "WeightedLoad";
    private static final SchemaProvider SCHEMA_PROVIDER = new YamlSchemaProviderBase(){

        protected final InputStream schemaInputStream() {
            return ((Object)((Object)this)).getClass().getResourceAsStream("/config-schema-load-generator-weight.yaml");
        }

        public final String id() {
            return "mongoose";
        }
    };
    private static final String DEFAULTS_FILE_NAME = "defaults-load-generator-weight.yaml";
    private static final List<String> RES_INSTALL_FILES = Collections.unmodifiableList(Arrays.asList("config/defaults-load-generator-weight.yaml"));

    public final String id() {
        return TYPE;
    }

    public final T createLocal(Config baseConfig, List<Extension> extensions, List<Config> contextConfigs, MetricsManager metricsManager) {
        return (T)((Object)new WeightedLoadStepLocal(baseConfig, extensions, contextConfigs, metricsManager));
    }

    public final U createClient(Config baseConfig, List<Extension> extensions, MetricsManager metricsManager) {
        return (U)((Object)new WeightedLoadStepClient(baseConfig, extensions, null, metricsManager));
    }

    public final SchemaProvider schemaProvider() {
        return SCHEMA_PROVIDER;
    }

    protected final String defaultsFileName() {
        return DEFAULTS_FILE_NAME;
    }

    protected final List<String> resourceFilesToInstall() {
        return RES_INSTALL_FILES;
    }
}

