/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.load.step.weighted;

import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.env.Extension;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.ItemType;
import com.emc.mongoose.base.item.io.ItemInfoFileOutput;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.load.generator.LoadGenerator;
import com.emc.mongoose.base.load.generator.LoadGeneratorBuilderImpl;
import com.emc.mongoose.base.load.step.local.LoadStepLocalBase;
import com.emc.mongoose.base.load.step.local.context.LoadStepContextImpl;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.metrics.MetricsManager;
import com.emc.mongoose.base.metrics.context.MetricsContext;
import com.emc.mongoose.base.storage.driver.StorageDriver;
import com.github.akurilov.commons.collection.TreeUtil;
import com.github.akurilov.commons.concurrent.throttle.IndexThrottle;
import com.github.akurilov.commons.concurrent.throttle.RateThrottle;
import com.github.akurilov.commons.concurrent.throttle.SequentialWeightsThrottle;
import com.github.akurilov.commons.concurrent.throttle.Throttle;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.lang.Exceptions;
import com.github.akurilov.commons.reflection.TypeUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.exceptions.InvalidValuePathException;
import com.github.akurilov.confuse.exceptions.InvalidValueTypeException;
import com.github.akurilov.confuse.impl.BasicConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;

public class WeightedLoadStepLocal
extends LoadStepLocalBase {
    public WeightedLoadStepLocal(Config baseConfig, List<Extension> extensions, List<Config> contextConfigs, MetricsManager metricsManager) {
        super(baseConfig, extensions, contextConfigs, metricsManager);
    }

    public String getTypeName() {
        return "WeightedLoad";
    }

    protected void init() {
        Config subConfig;
        String autoStepId = "weighted_" + LogUtil.getDateTimeStamp();
        Config stepConfig = this.config.configVal("load-step");
        if (stepConfig.boolVal("idAutoGenerated")) {
            stepConfig.val("id", (Object)autoStepId);
        }
        int subStepCount = this.ctxConfigs.size();
        int[] weights = new int[subStepCount];
        ArrayList<Config> subConfigs = new ArrayList<Config>(subStepCount);
        for (int originIndex = 0; originIndex < subStepCount; ++originIndex) {
            int weight;
            Map mergedConfigTree = TreeUtil.reduceForest(Arrays.asList(Config.deepToMap((Config)this.config), Config.deepToMap((Config)((Config)this.ctxConfigs.get(originIndex)))));
            subConfig = null;
            try {
                subConfig = new BasicConfig(this.config.pathSep(), this.config.schema(), mergedConfigTree);
            }
            catch (InvalidValuePathException | InvalidValueTypeException e) {
                LogUtil.exception((Level)Level.FATAL, (Throwable)e, (String)"Scenario syntax error", (Object[])new Object[0]);
                Exceptions.throwUnchecked((Throwable)e);
            }
            subConfigs.add(subConfig);
            weights[originIndex] = weight = subConfig.intVal("load-op-weight");
        }
        SequentialWeightsThrottle weightThrottle = new SequentialWeightsThrottle(weights);
        for (int originIndex = 0; originIndex < subStepCount; ++originIndex) {
            subConfig = (Config)subConfigs.get(originIndex);
            Config loadConfig = subConfig.configVal("load");
            Config opConfig = loadConfig.configVal("op");
            OpType opType = OpType.valueOf((String)opConfig.stringVal("type").toUpperCase());
            Config storageConfig = subConfig.configVal("storage");
            int concurrencyLimit = storageConfig.intVal("driver-limit-concurrency");
            Config outputConfig = subConfig.configVal("output");
            Config metricsConfig = outputConfig.configVal("metrics");
            Object itemDataSizeRaw = subConfig.val("item-data-size");
            SizeInBytes itemDataSize = itemDataSizeRaw instanceof String ? new SizeInBytes((String)itemDataSizeRaw) : new SizeInBytes(((Long)TypeUtil.typeConvert((Object)itemDataSizeRaw, Long.TYPE)).longValue());
            boolean colorFlag = outputConfig.boolVal("color");
            this.initMetrics(originIndex, opType, concurrencyLimit, metricsConfig, itemDataSize, colorFlag);
            Config itemConfig = subConfig.configVal("item");
            Config dataConfig = itemConfig.configVal("data");
            Config dataInputConfig = dataConfig.configVal("input");
            Config limitConfig = stepConfig.configVal("limit");
            Config dataLayerConfig = dataInputConfig.configVal("layer");
            String testStepId = stepConfig.stringVal("id");
            try {
                Object dataLayerSizeRaw = dataLayerConfig.val("size");
                SizeInBytes dataLayerSize = dataLayerSizeRaw instanceof String ? new SizeInBytes((String)dataLayerSizeRaw) : new SizeInBytes((long)((Integer)TypeUtil.typeConvert((Object)dataLayerSizeRaw, Integer.TYPE)).intValue());
                DataInput dataInput = DataInput.instance((String)dataInputConfig.stringVal("file"), (String)dataInputConfig.stringVal("seed"), (SizeInBytes)dataLayerSize, (int)dataLayerConfig.intVal("cache"));
                int batchSize = loadConfig.intVal("batch-size");
                try {
                    StorageDriver driver = StorageDriver.instance((List)this.extensions, (Config)storageConfig, (DataInput)dataInput, (boolean)dataConfig.boolVal("verify"), (int)batchSize, (String)testStepId);
                    ItemType itemType = ItemType.valueOf((String)itemConfig.stringVal("type").toUpperCase());
                    ItemFactory itemFactory = ItemType.getItemFactory((ItemType)itemType);
                    double rateLimit = opConfig.doubleVal("limit-rate");
                    try {
                        LoadGeneratorBuilderImpl generatorBuilder = new LoadGeneratorBuilderImpl().itemConfig(itemConfig).loadConfig(loadConfig).itemType(itemType).itemFactory(itemFactory).loadOperationsOutput((Output)driver).authConfig(storageConfig.configVal("auth")).originIndex(originIndex).addThrottle((IndexThrottle)weightThrottle);
                        if (rateLimit > 0.0) {
                            generatorBuilder.addThrottle((Throttle)new RateThrottle(rateLimit));
                        }
                        LoadGenerator generator = generatorBuilder.build();
                        LoadStepContextImpl stepCtx = new LoadStepContextImpl(testStepId, generator, driver, (MetricsContext)this.metricsContexts.get(originIndex), loadConfig, outputConfig.boolVal("metrics-trace-persist"));
                        this.stepContexts.add(stepCtx);
                        String itemOutputFile = itemConfig.stringVal("output-file");
                        if (itemOutputFile == null || itemOutputFile.length() <= 0) continue;
                        Path itemOutputPath = Paths.get(itemOutputFile, new String[0]);
                        if (Files.exists(itemOutputPath, new LinkOption[0])) {
                            Loggers.ERR.warn("Items output file \"{}\" already exists", (Object)itemOutputPath);
                        }
                        try {
                            ItemInfoFileOutput itemOutput = new ItemInfoFileOutput(itemOutputPath);
                            stepCtx.operationsResultsOutput((Output)itemOutput);
                        }
                        catch (IOException e) {
                            LogUtil.exception((Level)Level.ERROR, (Throwable)e, (String)"Failed to initialize the item output, the processed items info won't be persisted", (Object[])new Object[0]);
                        }
                        continue;
                    }
                    catch (IllegalConfigurationException e) {
                        throw new IllegalStateException("Failed to initialize the load generator", e);
                    }
                }
                catch (IllegalConfigurationException e) {
                    throw new IllegalStateException("Failed to initialize the storage driver", e);
                }
                catch (InterruptedException e) {
                    Exceptions.throwUnchecked((Throwable)e);
                    continue;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to initialize the data input", e);
            }
        }
    }
}

