/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.run.scenario.step;

import com.emc.mongoose.api.model.NamingThreadFactory;
import com.emc.mongoose.run.scenario.step.StepBase;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.Level;

public final class CommandStep
extends StepBase {
    private static final ThreadFactory TF_STD_IN = new NamingThreadFactory("stdInReader", true);
    private static final ThreadFactory TF_STD_ERR = new NamingThreadFactory("stdErrReader", true);
    private static final String KEY_NODE_BLOCKING = "blocking";
    private final String cmdLine;
    private final boolean blockingFlag;
    private final boolean stdOutColorFlag;

    public CommandStep(Config appConfig, Map<String, Object> subTree) throws IllegalArgumentException {
        super(appConfig);
        this.cmdLine = (String)subTree.get("value");
        this.blockingFlag = subTree.containsKey(KEY_NODE_BLOCKING) ? (Boolean)subTree.get(KEY_NODE_BLOCKING) : true;
        this.stdOutColorFlag = appConfig.getOutputConfig().getColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void invoke() {
        block9: {
            try {
                Loggers.MSG.info("Invoking the shell command:\n{}{}{}", (Object)(this.stdOutColorFlag ? "\u001b[36m" : ""), (Object)this.cmdLine, (Object)(this.stdOutColorFlag ? "\u001b[0m" : ""));
                Process process = new ProcessBuilder("bash", "-c", this.cmdLine).start();
                Thread processStdInReader = TF_STD_IN.newThread(() -> {
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        String nextLine;
                        while (null != (nextLine = bufferedReader.readLine())) {
                            Loggers.MSG.info("{}{}{}", (Object)(this.stdOutColorFlag ? "\u001b[34m" : ""), (Object)nextLine, (Object)(this.stdOutColorFlag ? "\u001b[0m" : ""));
                        }
                    }
                    catch (IOException e) {
                        LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"Failed to read the process stdin", (Object[])new Object[0]);
                    }
                });
                Thread processStdErrReader = TF_STD_ERR.newThread(() -> {
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                        String nextLine;
                        while (null != (nextLine = bufferedReader.readLine())) {
                            Loggers.MSG.info("{}{}{}", (Object)(this.stdOutColorFlag ? "\u001b[31m" : ""), (Object)nextLine, (Object)(this.stdOutColorFlag ? "\u001b[0m" : ""));
                        }
                    }
                    catch (IOException e) {
                        LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"Failed to read the process error input", (Object[])new Object[0]);
                    }
                });
                processStdInReader.start();
                processStdErrReader.start();
                if (!this.blockingFlag) break block9;
                try {
                    int exitCode = process.waitFor();
                    if (exitCode == 0) {
                        Loggers.MSG.info("Shell command \"{}\" finished", (Object)this.cmdLine);
                    } else {
                        Loggers.ERR.warn("Shell command \"{}\" finished with exit code {}", (Object)this.cmdLine, (Object)exitCode);
                    }
                }
                catch (InterruptedException e) {
                    Loggers.MSG.info("Shell command \"{}\" interrupted", (Object)this.cmdLine);
                }
                finally {
                    processStdInReader.interrupt();
                    processStdErrReader.interrupt();
                    process.destroy();
                }
            }
            catch (Exception e) {
                LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Shell command \"{}\" failed", (Object[])new Object[]{this.cmdLine});
            }
        }
    }

    @Override
    public final void close() {
    }
}

