/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.run.scenario.step;

import com.emc.mongoose.api.common.SizeInBytes;
import com.emc.mongoose.api.common.exception.UserShootHisFootException;
import com.emc.mongoose.api.common.io.Output;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.api.model.item.ItemInfoFileOutput;
import com.emc.mongoose.api.model.item.ItemType;
import com.emc.mongoose.api.model.storage.StorageDriver;
import com.emc.mongoose.load.controller.BasicLoadController;
import com.emc.mongoose.load.generator.BasicLoadGenerator;
import com.emc.mongoose.load.generator.BasicLoadGeneratorBuilder;
import com.emc.mongoose.run.scenario.step.StepBase;
import com.emc.mongoose.run.scenario.util.StorageDriverUtil;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.config.item.ItemConfig;
import com.emc.mongoose.ui.config.item.data.DataConfig;
import com.emc.mongoose.ui.config.item.data.input.InputConfig;
import com.emc.mongoose.ui.config.item.data.input.layer.LayerConfig;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.output.OutputConfig;
import com.emc.mongoose.ui.config.output.metrics.MetricsConfig;
import com.emc.mongoose.ui.config.output.metrics.average.AverageConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.test.step.StepConfig;
import com.emc.mongoose.ui.config.test.step.limit.LimitConfig;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;

public final class LoadStep
extends StepBase {
    private final boolean preconditionFlag;

    public LoadStep(Config config) {
        this(config, Collections.EMPTY_MAP, false);
    }

    public LoadStep(Config appConfig, Map<String, Object> subTree, boolean preconditionFlag) {
        super(appConfig);
        Map nodeConfig = (Map)subTree.get("config");
        this.localConfig.apply(nodeConfig, "load-" + LogUtil.getDateTimeStamp() + "-" + this.hashCode());
        this.preconditionFlag = preconditionFlag;
    }

    @Override
    protected final void invoke() {
        BasicLoadGenerator loadGenerator;
        DataInput dataInput;
        StepConfig stepConfig = this.localConfig.getTestConfig().getStepConfig();
        String stepId = stepConfig.getId();
        Loggers.MSG.info("Run the load step \"{}\"", (Object)stepId);
        LoadConfig loadConfig = this.localConfig.getLoadConfig();
        LimitConfig limitConfig = stepConfig.getLimitConfig();
        OutputConfig outputConfig = this.localConfig.getOutputConfig();
        MetricsConfig metricsConfig = outputConfig.getMetricsConfig();
        AverageConfig avgMetricsConfig = metricsConfig.getAverageConfig();
        if (this.preconditionFlag) {
            avgMetricsConfig.setPersist(false);
            metricsConfig.getSummaryConfig().setPersist(false);
            metricsConfig.getSummaryConfig().setPerfDbResultsFile(false);
            metricsConfig.getTraceConfig().setPersist(false);
        }
        ItemConfig itemConfig = this.localConfig.getItemConfig();
        DataConfig dataConfig = itemConfig.getDataConfig();
        InputConfig dataInputConfig = dataConfig.getInputConfig();
        StorageConfig storageConfig = this.localConfig.getStorageConfig();
        LayerConfig dataLayerConfig = dataInputConfig.getLayerConfig();
        try {
            dataInput = DataInput.getInstance((String)dataInputConfig.getFile(), (String)dataInputConfig.getSeed(), (SizeInBytes)dataLayerConfig.getSize(), (int)dataLayerConfig.getCache());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<StorageDriver> drivers = new ArrayList<StorageDriver>();
        try {
            StorageDriverUtil.init(drivers, itemConfig, loadConfig, avgMetricsConfig, storageConfig, stepConfig, dataInput);
        }
        catch (InterruptedException e) {
            return;
        }
        ItemType itemType = ItemType.valueOf((String)itemConfig.getType().toUpperCase());
        ItemFactory itemFactory = ItemType.getItemFactory((ItemType)itemType);
        Loggers.MSG.info("Work on the " + itemType.toString().toLowerCase() + " items");
        try {
            loadGenerator = new BasicLoadGeneratorBuilder().setItemConfig(itemConfig).setLoadConfig(loadConfig).setLimitConfig(limitConfig).setItemType(itemType).setItemFactory(itemFactory).setStorageDrivers(drivers).setAuthConfig(storageConfig.getAuthConfig()).build();
        }
        catch (UserShootHisFootException e) {
            throw new RuntimeException(e);
        }
        Loggers.MSG.info("Load generators initialized");
        long t = limitConfig.getTime();
        long timeLimitSec = t > 0L ? t : Long.MAX_VALUE;
        HashMap<BasicLoadGenerator, ArrayList<StorageDriver>> driversMap = new HashMap<BasicLoadGenerator, ArrayList<StorageDriver>>();
        driversMap.put(loadGenerator, drivers);
        HashMap<BasicLoadGenerator, LoadConfig> loadConfigMap = new HashMap<BasicLoadGenerator, LoadConfig>();
        loadConfigMap.put(loadGenerator, loadConfig);
        HashMap<BasicLoadGenerator, OutputConfig> outputConfigMap = new HashMap<BasicLoadGenerator, OutputConfig>();
        outputConfigMap.put(loadGenerator, outputConfig);
        try (BasicLoadController controller = new BasicLoadController(stepId, driversMap, null, loadConfigMap, stepConfig, outputConfigMap);){
            String itemOutputFile = itemConfig.getOutputConfig().getFile();
            if (itemOutputFile != null && itemOutputFile.length() > 0) {
                Path itemOutputPath = Paths.get(itemOutputFile, new String[0]);
                if (Files.exists(itemOutputPath, new LinkOption[0])) {
                    Loggers.ERR.warn("Items output file \"{}\" already exists", (Object)itemOutputPath);
                }
                ItemInfoFileOutput itemOutput = new ItemInfoFileOutput(itemOutputPath);
                controller.setIoResultsOutput((Output)itemOutput);
            }
            controller.start();
            Loggers.MSG.info("Load step \"{}\" started", (Object)stepId);
            if (controller.await(timeLimitSec, TimeUnit.SECONDS)) {
                Loggers.MSG.info("Load step \"{}\" done", (Object)stepId);
            } else {
                Loggers.MSG.info("Load step \"{}\" timeout", (Object)stepId);
            }
        }
        catch (RemoteException e) {
            LogUtil.exception((Level)Level.ERROR, (Throwable)e, (String)"Unexpected failure", (Object[])new Object[0]);
        }
        catch (IOException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to open the item output file", (Object[])new Object[0]);
        }
        catch (InterruptedException e) {
            Loggers.MSG.debug("Load step \"{}\" interrupted", (Object)stepId);
        }
    }

    public final String toString() {
        return "singleLoadStepContainer#" + this.hashCode();
    }

    @Override
    public final void close() throws IOException {
    }
}

