/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.run.scenario.util;

import com.emc.mongoose.api.common.exception.UserShootHisFootException;
import com.emc.mongoose.api.common.net.ServiceUtil;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.storage.StorageDriver;
import com.emc.mongoose.api.model.storage.StorageDriverSvc;
import com.emc.mongoose.storage.driver.builder.BasicStorageDriverBuilder;
import com.emc.mongoose.storage.driver.builder.StorageDriverBuilderSvc;
import com.emc.mongoose.ui.config.item.ItemConfig;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.output.metrics.average.AverageConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.storage.driver.DriverConfig;
import com.emc.mongoose.ui.config.test.step.StepConfig;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import java.io.IOException;
import java.net.URISyntaxException;
import java.rmi.NotBoundException;
import java.util.List;
import org.apache.logging.log4j.Level;

public interface StorageDriverUtil {
    public static void init(List<StorageDriver> drivers, ItemConfig itemConfig, LoadConfig loadConfig, AverageConfig avgMetricsConfig, StorageConfig storageConfig, StepConfig stepConfig, DataInput contentSrc) throws InterruptedException {
        DriverConfig driverConfig = storageConfig.getDriverConfig();
        String testStepName = stepConfig.getId();
        int driverPort = driverConfig.getPort();
        boolean remoteDriversFlag = driverConfig.getRemote();
        if (remoteDriversFlag) {
            List driverSvcAddrs = driverConfig.getAddrs();
            for (String driverSvcAddr : driverSvcAddrs) {
                StorageDriverSvc driverSvc;
                String driverSvcName;
                StorageDriverBuilderSvc driverBuilderSvc;
                if (driverSvcAddr.contains(":")) {
                    try {
                        driverBuilderSvc = (StorageDriverBuilderSvc)ServiceUtil.resolve((String)driverSvcAddr, (String)"storage/driver/builder");
                    }
                    catch (IOException | URISyntaxException | NotBoundException e) {
                        LogUtil.exception((Level)Level.FATAL, (Throwable)e, (String)"Failed to resolve the storage driver builder service @{}", (Object[])new Object[]{driverSvcAddr});
                        return;
                    }
                }
                try {
                    driverBuilderSvc = (StorageDriverBuilderSvc)ServiceUtil.resolve((String)driverSvcAddr, (int)driverPort, (String)"storage/driver/builder");
                }
                catch (IOException | URISyntaxException | NotBoundException e) {
                    LogUtil.exception((Level)Level.FATAL, (Throwable)e, (String)"Failed to resolve the storage driver builder service @{}:{}", (Object[])new Object[]{driverSvcAddr, driverPort});
                    return;
                }
                Loggers.MSG.info("Connected the service \"{}\" @ {}", (Object)"storage/driver/builder", (Object)driverSvcAddr);
                if (driverBuilderSvc == null) {
                    Loggers.ERR.warn("Failed to resolve the storage driver builder service @ {}", (Object)driverSvcAddr);
                    continue;
                }
                try {
                    driverSvcName = driverBuilderSvc.setTestStepName(testStepName).setContentSource(contentSrc).setItemConfig(itemConfig).setLoadConfig(loadConfig).setAverageConfig(avgMetricsConfig).setStorageConfig(storageConfig).buildRemotely();
                }
                catch (UserShootHisFootException | IOException e) {
                    throw new RuntimeException(e);
                }
                if (driverSvcAddr.contains(":")) {
                    try {
                        driverSvc = (StorageDriverSvc)ServiceUtil.resolve((String)driverSvcAddr, (String)driverSvcName);
                    }
                    catch (IOException | URISyntaxException | NotBoundException e) {
                        LogUtil.exception((Level)Level.FATAL, (Throwable)e, (String)"Failed to resolve the storage driver service @{}", (Object[])new Object[]{driverSvcAddr});
                        return;
                    }
                }
                try {
                    driverSvc = (StorageDriverSvc)ServiceUtil.resolve((String)driverSvcAddr, (int)driverPort, (String)driverSvcName);
                }
                catch (IOException | URISyntaxException | NotBoundException e) {
                    LogUtil.exception((Level)Level.FATAL, (Throwable)e, (String)"Failed to resolve the storage driver service @{}:{}", (Object[])new Object[]{driverSvcAddr, driverPort});
                    return;
                }
                Loggers.MSG.info("Connected the service \"{}\" @ {}", (Object)driverSvcName, (Object)driverSvcAddr);
                if (driverSvc != null) {
                    drivers.add((StorageDriver)driverSvc);
                    continue;
                }
                Loggers.ERR.warn("Failed to resolve the storage driver service @ {}", (Object)driverSvcAddr);
            }
        } else {
            try {
                drivers.add(new BasicStorageDriverBuilder().setTestStepName(testStepName).setItemConfig(itemConfig).setContentSource(contentSrc).setLoadConfig(loadConfig).setAverageConfig(avgMetricsConfig).setStorageConfig(storageConfig).build());
            }
            catch (UserShootHisFootException e) {
                throw new RuntimeException(e);
            }
        }
        Loggers.MSG.info("Storage drivers initialized");
    }
}

