/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.run;

import com.emc.mongoose.api.common.env.PathUtil;
import com.emc.mongoose.run.scenario.JsonScenario;
import com.emc.mongoose.run.scenario.ScenarioParseException;
import com.emc.mongoose.ui.cli.CliArgParser;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.config.IllegalArgumentNameException;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;

public class Main {
    public static void main(String ... args) throws Exception {
        LogUtil.init();
        Config config = Config.loadDefaults();
        if (config == null) {
            throw new AssertionError();
        }
        try {
            config.apply(CliArgParser.parseArgs((List)config.getAliasingConfig(), (String[])args), "none-" + LogUtil.getDateTimeStamp());
        }
        catch (IllegalArgumentNameException e) {
            Loggers.ERR.fatal("Invalid argument: \"{}\"\nThe list of all possible args:\n{}", (Object)e.getMessage(), (Object)CliArgParser.formatCliArgsList((Map)CliArgParser.getAllCliArgs()));
            return;
        }
        String scenarioValue = config.getTestConfig().getScenarioConfig().getFile();
        Path scenarioPath = scenarioValue != null && !scenarioValue.isEmpty() ? Paths.get(scenarioValue, new String[0]) : Paths.get(PathUtil.getBaseDir(), "scenario", "default.json");
        try (JsonScenario scenario = new JsonScenario(config, scenarioPath.toFile());){
            scenario.run();
        }
        catch (ScenarioParseException e) {
            Loggers.ERR.fatal("Failed to parse the scenario \"{}\": {}", (Object)scenarioPath, (Object)e.getMessage());
        }
        catch (FileNotFoundException e) {
            Loggers.ERR.fatal("Scenario file \"{}\" not found", (Object)scenarioPath);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }
}

