/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.run.scenario;

import com.emc.mongoose.run.scenario.Scenario;
import com.emc.mongoose.run.scenario.ScenarioParseException;
import com.emc.mongoose.run.scenario.step.SequentialStep;
import com.emc.mongoose.run.scenario.step.Step;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;

public class JsonScenario
extends SequentialStep
implements Scenario {
    private static final Pattern PATTERN_ENV_VAR = Pattern.compile("\\$\\{([\\w\\-_.!@#%\\^&*=+()\\[\\]~:;'\\\\|/<>,?]+)\\}");

    public JsonScenario(Config config, File scenarioSrcFile) throws IOException, ScenarioParseException {
        this(config, (Map)new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true).readValue(scenarioSrcFile, (TypeReference)new TypeReference<Map<String, Object>>(){}));
    }

    public JsonScenario(Config config, InputStream scenarioInputStream) throws IOException, ScenarioParseException {
        this(config, (Map)new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true).readValue(scenarioInputStream, (TypeReference)new TypeReference<Map<String, Object>>(){}));
    }

    public JsonScenario(Config config, String scenarioString) throws IOException, ScenarioParseException {
        this(config, (Map)new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true).readValue(scenarioString, (TypeReference)new TypeReference<Map<String, Object>>(){}));
    }

    public JsonScenario(Config config, Map<String, Object> tree) throws IOException, ScenarioParseException {
        super(config, JsonScenario.overrideByEnv(JsonScenario.validateAgainstSchema(tree)));
    }

    private static final Map<String, Object> validateAgainstSchema(Map<String, Object> tree) {
        return tree;
    }

    private static Map<String, Object> overrideByEnv(Map<String, Object> tree) {
        for (String key : tree.keySet()) {
            Object value = tree.get(key);
            if (value instanceof Map) {
                JsonScenario.overrideByEnv((Map)value);
                continue;
            }
            if (value instanceof List) {
                JsonScenario.overrideByEnv((List)value);
                continue;
            }
            if (!(value instanceof String)) continue;
            String valueStr = (String)value;
            Matcher m = PATTERN_ENV_VAR.matcher(valueStr);
            boolean alteredFlag = false;
            while (m.find()) {
                String newValue;
                String propertyName = m.group(1);
                if (propertyName == null || propertyName.isEmpty() || (newValue = System.getenv(propertyName)) == null) continue;
                valueStr = valueStr.replace("${" + propertyName + "}", newValue);
                alteredFlag = true;
                Loggers.MSG.info("Key \"{}\": replaced \"{}\" with new value \"{}\"", (Object)key, (Object)propertyName, (Object)newValue);
            }
            if (!alteredFlag) continue;
            tree.put(key, valueStr);
        }
        return tree;
    }

    private static List<Object> overrideByEnv(List<Object> values) {
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value instanceof Map) {
                JsonScenario.overrideByEnv((Map)value);
                continue;
            }
            if (value instanceof List) {
                JsonScenario.overrideByEnv((List)value);
                continue;
            }
            if (!(value instanceof String)) continue;
            String valueStr = (String)value;
            Matcher m = PATTERN_ENV_VAR.matcher(valueStr);
            boolean alteredFlag = false;
            while (m.find()) {
                String newValue;
                String propertyName = m.group(1);
                if (propertyName == null || propertyName.isEmpty() || (newValue = System.getenv(propertyName)) == null) continue;
                valueStr = valueStr.replace("${" + propertyName + "}", newValue);
                alteredFlag = true;
                Loggers.MSG.info("Value #{}: replaced \"{}\" with new value \"{}\"", (Object)i, (Object)propertyName, (Object)newValue);
            }
            if (!alteredFlag) continue;
            values.set(i, valueStr);
        }
        return values;
    }

    @Override
    protected final void loadSubTree(Map<String, Object> subTree) throws ScenarioParseException {
        this.appendNewJob(subTree, this.localConfig);
    }

    @Override
    protected final synchronized boolean append(Step step) {
        if (this.childSteps.size() == 0) {
            return super.append(step);
        }
        return false;
    }

    @Override
    protected final void invoke() {
        Loggers.MSG.info("Scenario start");
        try {
            super.invoke();
        }
        catch (CancellationException e) {
            Loggers.MSG.info("Scenario interrupted");
        }
        catch (Throwable cause) {
            LogUtil.exception((Level)Level.ERROR, (Throwable)cause, (String)"Scenario failure", (Object[])new Object[0]);
        }
        Loggers.MSG.info("Scenario end");
    }

    @Override
    public final String toString() {
        return "jsonScenario#" + this.hashCode();
    }
}

