/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.run.scenario.step;

import com.emc.mongoose.api.common.exception.UserShootHisFootException;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.item.BasicChainTransferBuffer;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.api.model.item.ItemInfoFileOutput;
import com.emc.mongoose.api.model.item.ItemType;
import com.emc.mongoose.api.model.load.LoadController;
import com.emc.mongoose.api.model.storage.StorageDriver;
import com.emc.mongoose.load.controller.BasicLoadController;
import com.emc.mongoose.load.generator.BasicLoadGenerator;
import com.emc.mongoose.load.generator.BasicLoadGeneratorBuilder;
import com.emc.mongoose.run.scenario.ScenarioParseException;
import com.emc.mongoose.run.scenario.step.StepBase;
import com.emc.mongoose.run.scenario.util.StorageDriverUtil;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.config.item.ItemConfig;
import com.emc.mongoose.ui.config.item.data.DataConfig;
import com.emc.mongoose.ui.config.item.data.input.InputConfig;
import com.emc.mongoose.ui.config.item.data.input.layer.LayerConfig;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.output.OutputConfig;
import com.emc.mongoose.ui.config.output.metrics.MetricsConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.storage.driver.queue.QueueConfig;
import com.emc.mongoose.ui.config.test.step.StepConfig;
import com.emc.mongoose.ui.config.test.step.limit.LimitConfig;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;

public class ChainLoadStep
extends StepBase {
    private final List<Map<String, Object>> nodeConfigList;
    private final List<LoadController> loadChain;

    public ChainLoadStep(Config appConfig, Map<String, Object> subTree) throws ScenarioParseException {
        super(appConfig);
        this.nodeConfigList = (List)subTree.get("config");
        if (this.nodeConfigList == null || this.nodeConfigList.size() == 0) {
            throw new ScenarioParseException("Configuration list is empty");
        }
        this.localConfig.apply(this.nodeConfigList.get(0), "chain-" + LogUtil.getDateTimeStamp() + "-" + this.hashCode());
        this.loadChain = new ArrayList<LoadController>(this.nodeConfigList.size());
    }

    @Override
    protected final void invoke() throws CancellationException {
        StepConfig stepConfig = this.localConfig.getTestConfig().getStepConfig();
        String testStepName = stepConfig.getId();
        Loggers.MSG.info("Run the chain load step \"{}\"", (Object)testStepName);
        LimitConfig commonLimitConfig = stepConfig.getLimitConfig();
        long t = commonLimitConfig.getTime();
        long timeLimitSec = t > 0L ? t : Long.MAX_VALUE;
        try {
            BasicChainTransferBuffer nextItemBuff = null;
            for (int i = 0; i < this.nodeConfigList.size(); ++i) {
                Config config = new Config(this.localConfig);
                config.apply(this.nodeConfigList.get(i), "chain-load-" + LogUtil.getDateTimeStamp() + "-" + config.hashCode());
                stepConfig = config.getTestConfig().getStepConfig();
                ItemConfig itemConfig = config.getItemConfig();
                DataConfig dataConfig = itemConfig.getDataConfig();
                InputConfig dataInputConfig = dataConfig.getInputConfig();
                com.emc.mongoose.ui.config.item.output.OutputConfig itemOutputConfig = itemConfig.getOutputConfig();
                ItemType itemType = ItemType.valueOf((String)itemConfig.getType().toUpperCase());
                LayerConfig dataLayerConfig = dataInputConfig.getLayerConfig();
                DataInput dataInput = DataInput.getInstance((String)dataInputConfig.getFile(), (String)dataInputConfig.getSeed(), (SizeInBytes)dataLayerConfig.getSize(), (int)dataLayerConfig.getCache());
                ItemFactory itemFactory = ItemType.getItemFactory((ItemType)itemType);
                Loggers.MSG.info("Work on the " + itemType.toString().toLowerCase() + " items");
                LoadConfig loadConfig = config.getLoadConfig();
                OutputConfig outputConfig = config.getOutputConfig();
                StorageConfig storageConfig = config.getStorageConfig();
                QueueConfig queueConfig = storageConfig.getDriverConfig().getQueueConfig();
                MetricsConfig metricsConfig = config.getOutputConfig().getMetricsConfig();
                ArrayList<StorageDriver> drivers = new ArrayList<StorageDriver>();
                StorageDriverUtil.init(drivers, itemConfig, loadConfig, metricsConfig.getAverageConfig(), storageConfig, stepConfig, dataInput);
                BasicLoadGenerator loadGenerator = nextItemBuff == null ? new BasicLoadGeneratorBuilder().setItemConfig(itemConfig).setItemFactory(itemFactory).setItemType(itemType).setLoadConfig(loadConfig).setLimitConfig(commonLimitConfig).setStorageDrivers(drivers).setAuthConfig(storageConfig.getAuthConfig()).build() : new BasicLoadGeneratorBuilder().setItemConfig(itemConfig).setItemFactory(itemFactory).setItemType(itemType).setLoadConfig(loadConfig).setLimitConfig(commonLimitConfig).setStorageDrivers(drivers).setAuthConfig(storageConfig.getAuthConfig()).setItemInput(nextItemBuff).build();
                HashMap<BasicLoadGenerator, ArrayList<StorageDriver>> driversMap = new HashMap<BasicLoadGenerator, ArrayList<StorageDriver>>();
                driversMap.put(loadGenerator, drivers);
                HashMap<BasicLoadGenerator, SizeInBytes> itemDataSizes = new HashMap<BasicLoadGenerator, SizeInBytes>();
                itemDataSizes.put(loadGenerator, dataConfig.getSize());
                HashMap<BasicLoadGenerator, LoadConfig> loadConfigMap = new HashMap<BasicLoadGenerator, LoadConfig>();
                loadConfigMap.put(loadGenerator, loadConfig);
                HashMap<BasicLoadGenerator, OutputConfig> outputConfigMap = new HashMap<BasicLoadGenerator, OutputConfig>();
                outputConfigMap.put(loadGenerator, outputConfig);
                BasicLoadController loadController = new BasicLoadController(stepConfig.getId(), driversMap, null, itemDataSizes, loadConfigMap, stepConfig, outputConfigMap);
                this.loadChain.add((LoadController)loadController);
                if (i < this.nodeConfigList.size() - 1) {
                    nextItemBuff = new BasicChainTransferBuffer(queueConfig.getOutput(), TimeUnit.SECONDS, itemOutputConfig.getDelay());
                    loadController.setIoResultsOutput((Output)nextItemBuff);
                    continue;
                }
                String itemOutputFile = this.localConfig.getItemConfig().getOutputConfig().getFile();
                if (itemOutputFile == null || itemOutputFile.length() <= 0) continue;
                Path itemOutputPath = Paths.get(itemOutputFile, new String[0]);
                if (Files.exists(itemOutputPath, new LinkOption[0])) {
                    Loggers.ERR.warn("Items output file \"{}\" already exists", (Object)itemOutputPath);
                }
                ItemInfoFileOutput itemOutput = new ItemInfoFileOutput(itemOutputPath);
                loadController.setIoResultsOutput((Output)itemOutput);
            }
        }
        catch (IOException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to init the content source", (Object[])new Object[0]);
        }
        catch (UserShootHisFootException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to init the load generator", (Object[])new Object[0]);
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
        try {
            for (LoadController nextController : this.loadChain) {
                nextController.start();
                Loggers.MSG.info("Load step \"{}\" started", (Object)nextController.getName());
            }
        }
        catch (RemoteException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Unexpected failure", (Object[])new Object[0]);
        }
        long timeRemainSec = timeLimitSec;
        int controllersCount = this.loadChain.size();
        for (int i = 0; i < controllersCount; ++i) {
            LoadController controller = this.loadChain.get(i);
            if (timeRemainSec <= 0L) break;
            long tsStart = System.currentTimeMillis();
            try {
                try {
                    if (controller.await(timeRemainSec, TimeUnit.SECONDS)) {
                        Loggers.MSG.info("Load step \"{}\" done", (Object)controller.getName());
                    } else {
                        Loggers.MSG.info("Load step \"{}\" timeout", (Object)controller.getName());
                    }
                }
                catch (InterruptedException e) {
                    Loggers.MSG.debug("Load step interrupted");
                    for (LoadController nextController : this.loadChain) {
                        try {
                            nextController.close();
                        }
                        catch (IOException ee) {
                            LogUtil.exception((Level)Level.WARN, (Throwable)ee, (String)"Failed to close the step \"{}\"", (Object[])new Object[]{nextController.getName()});
                        }
                    }
                    throw new CancellationException();
                }
                finally {
                    controller.interrupt();
                }
            }
            catch (RemoteException e) {
                throw new AssertionError((Object)e);
            }
            timeRemainSec -= (System.currentTimeMillis() - tsStart) / 1000L;
        }
        for (LoadController nextController : this.loadChain) {
            try {
                nextController.close();
            }
            catch (IOException e) {
                LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to close the step \"{}\"", (Object[])new Object[]{nextController.getName()});
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.nodeConfigList.clear();
    }
}

