/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.run.scenario.step;

import com.emc.mongoose.run.scenario.ScenarioParseException;
import com.emc.mongoose.run.scenario.step.ChainLoadStep;
import com.emc.mongoose.run.scenario.step.CommandStep;
import com.emc.mongoose.run.scenario.step.CompositeStep;
import com.emc.mongoose.run.scenario.step.ForStep;
import com.emc.mongoose.run.scenario.step.LoadStep;
import com.emc.mongoose.run.scenario.step.MixedLoadStep;
import com.emc.mongoose.run.scenario.step.ParallelStep;
import com.emc.mongoose.run.scenario.step.SequentialStep;
import com.emc.mongoose.run.scenario.step.Step;
import com.emc.mongoose.run.scenario.step.StepBase;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.CloseableThreadContext;

public abstract class CompositeStepBase
extends StepBase
implements CompositeStep {
    protected final List<Step> childSteps = new LinkedList<Step>();

    protected CompositeStepBase(Config appConfig, Map<String, Object> subTree) throws ScenarioParseException {
        super(appConfig);
        this.loadSubTree(subTree);
    }

    protected void loadSubTree(Map<String, Object> subTree) throws ScenarioParseException {
        Object nodeConfig = subTree.get("config");
        this.localConfig.apply((Map)nodeConfig, "composite-" + LogUtil.getDateTimeStamp() + "-" + this.hashCode());
        Object jobList = subTree.getOrDefault("steps", subTree.get("jobs"));
        if (jobList != null) {
            if (jobList instanceof List) {
                for (Object job : (List)jobList) {
                    if (job != null) {
                        if (job instanceof Map) {
                            this.appendNewJob((Map)job, this.localConfig);
                            continue;
                        }
                        throw new ScenarioParseException("Invalid job node type: \"" + job.getClass() + "\"");
                    }
                    throw new ScenarioParseException("job node is null");
                }
            } else {
                throw new ScenarioParseException("Invalid jobs node type: \"" + jobList.getClass() + "\"");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void appendNewJob(Map<String, Object> subTree, Config config) throws ScenarioParseException {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"stepId", (String)config.getTestConfig().getStepConfig().getId());){
            Loggers.MSG.debug("Load the subtree to the step \"{}\"", (Object)this.toString());
            String jobType = (String)subTree.get("type");
            if (jobType == null) {
                throw new ScenarioParseException("No \"type\" element for the job");
            }
            switch (jobType) {
                case "chain": {
                    this.append(new ChainLoadStep(config, subTree));
                    return;
                }
                case "command": {
                    this.append(new CommandStep(config, subTree));
                    return;
                }
                case "for": {
                    this.append(new ForStep(config, subTree));
                    return;
                }
                case "load": {
                    this.append(new LoadStep(config, subTree, false));
                    return;
                }
                case "parallel": {
                    this.append(new ParallelStep(config, subTree));
                    return;
                }
                case "precondition": {
                    this.append(new LoadStep(config, subTree, true));
                    return;
                }
                case "sequential": {
                    this.append(new SequentialStep(config, subTree));
                    return;
                }
                case "mixed": {
                    this.append(new MixedLoadStep(config, subTree));
                    return;
                }
                default: {
                    throw new ScenarioParseException("\"" + this.toString() + "\": unexpected job type value: " + jobType);
                }
            }
        }
    }

    protected synchronized boolean append(Step subStep) {
        return this.childSteps.add(subStep);
    }

    @Override
    public final List<Step> getChildSteps() {
        return this.childSteps;
    }

    @Override
    public void close() throws IOException {
        try {
            for (Step subStep : this.childSteps) {
                subStep.close();
            }
        }
        finally {
            this.childSteps.clear();
        }
    }
}

