/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.run.scenario.step;

import com.emc.mongoose.api.common.exception.UserShootHisFootException;
import com.emc.mongoose.api.common.supply.PatternDefinedSupplier;
import com.emc.mongoose.run.scenario.ScenarioParseException;
import com.emc.mongoose.run.scenario.step.BasicTaskStep;
import com.emc.mongoose.run.scenario.step.SequentialStep;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.log.Loggers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ForStep
extends SequentialStep {
    public static final String KEY_NODE_IN = "in";
    public static final char REPLACE_MARKER_CHAR = '$';
    public static final Pattern SEQ_SPEC_PATTERN = Pattern.compile("(-?[\\d.]+)(-(-?[\\d.]+)(,([\\d.]+))?)?");
    private final String replaceMarkerName;
    private final List valueSeq;
    private final boolean infinite;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ForStep(Config appConfig, Map<String, Object> subTree) throws ScenarioParseException {
        super(appConfig, subTree);
        Object value = subTree.get("value");
        if (value != null) {
            this.infinite = false;
            if (value instanceof Short || value instanceof Integer) {
                int n = (Integer)value;
                this.replaceMarkerName = null;
                this.valueSeq = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    this.valueSeq.add(i);
                }
            } else {
                if (!(value instanceof String)) throw new ScenarioParseException("Unexpected value: \"" + value + "\"");
                Object seqSpec = subTree.get(KEY_NODE_IN);
                if (seqSpec == null) {
                    try {
                        int n = Integer.parseInt((String)value);
                        this.replaceMarkerName = null;
                        this.valueSeq = new ArrayList(n);
                        for (int i = 0; i < n; ++i) {
                            this.valueSeq.add(i);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new ScenarioParseException("Expected an integer value for the \"value\", but got: \"" + value + "\"");
                    }
                } else {
                    this.replaceMarkerName = (String)value;
                    if (seqSpec instanceof List) {
                        this.valueSeq = (List)seqSpec;
                    } else {
                        if (!(seqSpec instanceof String)) throw new ScenarioParseException("Unexpected \"in\" value: \"" + seqSpec + "\"");
                        Matcher m = SEQ_SPEC_PATTERN.matcher((String)seqSpec);
                        if (!m.matches()) {
                            throw new ScenarioParseException("String \"in\" value \"" + seqSpec + "\" should match the pattern: \"" + SEQ_SPEC_PATTERN.pattern() + "\"");
                        }
                        m.reset();
                        if (!m.find()) throw new ScenarioParseException("String \"in\" value \"" + seqSpec + "\" should match the pattern: \"" + SEQ_SPEC_PATTERN.pattern() + "\"");
                        this.valueSeq = new ArrayList();
                        double end = Double.NaN;
                        double step = Double.NaN;
                        String t = m.group(1);
                        if (t == null) {
                            throw new ScenarioParseException("No start value in the \"in\"");
                        }
                        double start = Double.parseDouble(t);
                        t = m.group(3);
                        if (t != null) {
                            end = Double.parseDouble(t);
                        }
                        if ((t = m.group(5)) != null) {
                            step = Double.parseDouble(t);
                        }
                        if (Double.isNaN(step)) {
                            step = 1.0;
                        }
                        if (Double.isNaN(end)) {
                            end = start;
                            start = 0.0;
                        }
                        if (start == end) {
                            if (start == (double)((long)start)) {
                                this.valueSeq.add((long)start);
                            } else {
                                this.valueSeq.add(start);
                            }
                        } else {
                            if (step <= 0.0) {
                                throw new ScenarioParseException("Step value should be > 0");
                            }
                            if (start < end) {
                                Loggers.MSG.info("Parsed loop range: {} = {}, {} <= {}, {} += {}", (Object)this.replaceMarkerName, (Object)start, (Object)this.replaceMarkerName, (Object)end, (Object)this.replaceMarkerName, (Object)step);
                                for (double i = start; i <= end; i += step) {
                                    if (i == (double)((long)i)) {
                                        this.valueSeq.add((long)i);
                                        continue;
                                    }
                                    this.valueSeq.add(i);
                                }
                            } else {
                                Loggers.MSG.info("Parsed loop range: {} = {}, {} => {}, {} -= {}", (Object)this.replaceMarkerName, (Object)start, (Object)this.replaceMarkerName, (Object)end, (Object)this.replaceMarkerName, (Object)step);
                                for (double i = start; i >= end; i -= step) {
                                    if (i == (double)((long)i)) {
                                        this.valueSeq.add((long)i);
                                        continue;
                                    }
                                    this.valueSeq.add(i);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            this.infinite = true;
            this.valueSeq = null;
            this.replaceMarkerName = null;
        }
        this.loadSubTree(subTree);
    }

    @Override
    protected void loadSubTree(Map<String, Object> subTree) throws ScenarioParseException {
        block12: {
            if (this.infinite) {
                super.loadSubTree(subTree);
                return;
            }
            if (this.valueSeq == null) {
                return;
            }
            if (this.replaceMarkerName == null) {
                for (Object o : this.valueSeq) {
                    super.loadSubTree(subTree);
                }
                return;
            }
            Object nodeConfig = subTree.get("config");
            Object stepsTreeList = subTree.getOrDefault("steps", subTree.get("jobs"));
            String replacePattern = Character.toString('$') + PatternDefinedSupplier.FORMAT_BRACKETS[0] + this.replaceMarkerName + PatternDefinedSupplier.FORMAT_BRACKETS[1];
            try {
                if (stepsTreeList == null) break block12;
                if (stepsTreeList instanceof List) {
                    for (Object nextValue : this.valueSeq) {
                        Config childJobConfig = this.localConfig.replace(replacePattern, nextValue);
                        if (nodeConfig != null) {
                            Map nextNodeConfig = Config.replace((Map)((Map)nodeConfig), (String)replacePattern, nextValue);
                            childJobConfig.apply(nextNodeConfig, null);
                        }
                        this.append(new BasicTaskStep(() -> Loggers.MSG.info("Use next value for \"{}\": {}", (Object)this.replaceMarkerName, nextValue)));
                        for (Object job : (List)stepsTreeList) {
                            if (job != null) {
                                if (job instanceof Map) {
                                    Map<String, Object> newJobTree = ForStep.findAndSubstitute((Map)job, replacePattern, nextValue);
                                    this.appendNewJob(newJobTree, childJobConfig);
                                    continue;
                                }
                                throw new ScenarioParseException("Invalid job node type: \"" + job.getClass() + "\"");
                            }
                            throw new ScenarioParseException("job node is null");
                        }
                    }
                    break block12;
                }
                throw new ScenarioParseException("Invalid jobs node type: \"" + stepsTreeList.getClass() + "\"");
            }
            catch (UserShootHisFootException | IOException e) {
                throw new ScenarioParseException("Failed to replace the configuration values", e);
            }
        }
    }

    private static Map<String, Object> findAndSubstitute(Map<String, Object> srcTree, String replacePattern, Object newValue) {
        if (newValue == null) {
            return ForStep.findAndSubstituteWithNull(srcTree, replacePattern);
        }
        if (newValue instanceof List) {
            return ForStep.findAndSubstituteWithList(srcTree, replacePattern, (List)newValue);
        }
        return ForStep.findAndSubstituteWith(srcTree, replacePattern, newValue);
    }

    private static Map<String, Object> findAndSubstituteWithNull(Map<String, Object> srcTree, String replacePattern) {
        LinkedHashMap<String, Object> dstTree = new LinkedHashMap<String, Object>();
        for (String key : srcTree.keySet()) {
            Object treeNode = srcTree.get(key);
            if (treeNode instanceof Map) {
                dstTree.put(key, ForStep.findAndSubstituteWithNull((Map)treeNode, replacePattern));
                continue;
            }
            if (treeNode instanceof String) {
                if (treeNode.equals(replacePattern)) {
                    dstTree.put(key, null);
                    continue;
                }
                dstTree.put(key, treeNode);
                continue;
            }
            if (treeNode instanceof List) {
                List srcListNode = (List)treeNode;
                ArrayList<Map<String, Object>> dstListNode = new ArrayList<Map<String, Object>>(srcListNode.size());
                for (Object element : srcListNode) {
                    if (element instanceof Map) {
                        dstListNode.add(ForStep.findAndSubstituteWithNull((Map)element, replacePattern));
                        continue;
                    }
                    if (element instanceof String) {
                        if (element.equals(replacePattern)) {
                            dstListNode.add(null);
                            continue;
                        }
                        dstListNode.add((Map<String, Object>)element);
                        continue;
                    }
                    dstListNode.add((Map<String, Object>)element);
                }
                dstTree.put(key, dstListNode);
                continue;
            }
            dstTree.put(key, treeNode);
        }
        return dstTree;
    }

    private static Map<String, Object> findAndSubstituteWithList(Map<String, Object> srcTree, String replacePattern, List newValue) {
        LinkedHashMap<String, Object> dstTree = new LinkedHashMap<String, Object>();
        for (String key : srcTree.keySet()) {
            Object treeNode = srcTree.get(key);
            if (treeNode instanceof Map) {
                dstTree.put(key, ForStep.findAndSubstituteWithList((Map)treeNode, replacePattern, newValue));
                continue;
            }
            if (treeNode instanceof String) {
                if (treeNode.equals(replacePattern)) {
                    dstTree.put(key, newValue);
                    continue;
                }
                dstTree.put(key, treeNode);
                continue;
            }
            if (treeNode instanceof List) {
                List srcListNode = (List)treeNode;
                ArrayList<Object> dstListNode = new ArrayList<Object>(srcListNode.size());
                for (Object element : srcListNode) {
                    if (element instanceof Map) {
                        dstListNode.add(ForStep.findAndSubstituteWithList((Map)element, replacePattern, newValue));
                        continue;
                    }
                    if (element instanceof String) {
                        if (element.equals(replacePattern)) {
                            dstListNode.add(newValue);
                            continue;
                        }
                        dstListNode.add(element);
                        continue;
                    }
                    dstListNode.add(element);
                }
                dstTree.put(key, dstListNode);
                continue;
            }
            dstTree.put(key, treeNode);
        }
        return dstTree;
    }

    private static <T> Map<String, Object> findAndSubstituteWith(Map<String, Object> srcTree, String replacePattern, T newValue) {
        LinkedHashMap<String, Object> dstTree = new LinkedHashMap<String, Object>();
        for (String key : srcTree.keySet()) {
            String t;
            String newKey = key.contains(replacePattern) ? key.replace(replacePattern, newValue.toString()) : key;
            Object treeNode = srcTree.get(key);
            if (treeNode instanceof Map) {
                dstTree.put(newKey, ForStep.findAndSubstituteWith((Map)treeNode, replacePattern, newValue));
                continue;
            }
            if (treeNode instanceof String) {
                if (treeNode.equals(replacePattern)) {
                    dstTree.put(newKey, newValue);
                    continue;
                }
                t = (String)treeNode;
                if (t.contains(replacePattern)) {
                    dstTree.put(newKey, t.replace(replacePattern, newValue.toString()));
                    continue;
                }
                dstTree.put(newKey, treeNode);
                continue;
            }
            if (treeNode instanceof List) {
                List srcListNode = (List)treeNode;
                ArrayList<Object> dstListNode = new ArrayList<Object>(srcListNode.size());
                for (Object element : srcListNode) {
                    if (element instanceof Map) {
                        dstListNode.add(ForStep.findAndSubstituteWith((Map)element, replacePattern, newValue));
                        continue;
                    }
                    if (element instanceof String) {
                        if (element.equals(replacePattern)) {
                            dstListNode.add(newValue);
                            continue;
                        }
                        t = (String)element;
                        if (t.contains(replacePattern)) {
                            dstListNode.add(t.replace(replacePattern, newValue.toString()));
                            continue;
                        }
                        dstListNode.add(element);
                        continue;
                    }
                    dstListNode.add(element);
                }
                dstTree.put(newKey, dstListNode);
                continue;
            }
            dstTree.put(newKey, treeNode);
        }
        return dstTree;
    }

    @Override
    protected final void invoke() throws CancellationException {
        if (this.replaceMarkerName == null && this.valueSeq == null) {
            while (true) {
                super.invoke();
            }
        }
        super.invoke();
    }

    @Override
    public final String toString() {
        return "forStep" + (this.replaceMarkerName == null ? "Infinite" : Integer.valueOf(this.valueSeq.size())) + "#" + this.hashCode();
    }

    @Override
    public final void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.valueSeq != null) {
                this.valueSeq.clear();
            }
        }
    }
}

