/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.run.scenario.step;

import com.emc.mongoose.api.common.exception.UserShootHisFootException;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.api.model.item.ItemInfoFileOutput;
import com.emc.mongoose.api.model.item.ItemType;
import com.emc.mongoose.api.model.storage.StorageDriver;
import com.emc.mongoose.load.controller.BasicLoadController;
import com.emc.mongoose.load.generator.BasicLoadGenerator;
import com.emc.mongoose.load.generator.BasicLoadGeneratorBuilder;
import com.emc.mongoose.run.scenario.ScenarioParseException;
import com.emc.mongoose.run.scenario.step.StepBase;
import com.emc.mongoose.run.scenario.util.StorageDriverUtil;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.config.item.ItemConfig;
import com.emc.mongoose.ui.config.item.data.DataConfig;
import com.emc.mongoose.ui.config.item.data.input.InputConfig;
import com.emc.mongoose.ui.config.item.data.input.layer.LayerConfig;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.output.OutputConfig;
import com.emc.mongoose.ui.config.output.metrics.MetricsConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.test.step.StepConfig;
import com.emc.mongoose.ui.config.test.step.limit.LimitConfig;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.system.SizeInBytes;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;

public class MixedLoadStep
extends StepBase {
    private final List<Map<String, Object>> nodeConfigList;
    private final List<Integer> weights;

    public MixedLoadStep(Config appConfig, Map<String, Object> subTree) throws ScenarioParseException {
        super(appConfig);
        this.nodeConfigList = (List)subTree.get("config");
        if (this.nodeConfigList == null || this.nodeConfigList.size() == 0) {
            throw new ScenarioParseException("Configuration list is empty");
        }
        this.localConfig.apply(this.nodeConfigList.get(0), "mixed-" + LogUtil.getDateTimeStamp() + "-" + this.hashCode());
        this.weights = (List)subTree.get("weights");
        if (this.weights != null && this.weights.size() != this.nodeConfigList.size()) {
            throw new ScenarioParseException("Weights count is not equal to sub-jobs count");
        }
    }

    @Override
    protected final void invoke() throws CancellationException {
        StepConfig stepConfig = this.localConfig.getTestConfig().getStepConfig();
        String stepId = stepConfig.getId();
        Loggers.MSG.info("Run the mixed load step \"{}\"", (Object)stepId);
        LimitConfig localLimitConfig = stepConfig.getLimitConfig();
        long t = localLimitConfig.getTime();
        long timeLimitSec = t > 0L ? t : Long.MAX_VALUE;
        int loadGeneratorCount = this.nodeConfigList.size();
        HashMap<BasicLoadGenerator, ArrayList<StorageDriver>> driverMap = new HashMap<BasicLoadGenerator, ArrayList<StorageDriver>>(loadGeneratorCount);
        Int2IntOpenHashMap weightMap = this.weights == null ? null : new Int2IntOpenHashMap(loadGeneratorCount);
        HashMap<BasicLoadGenerator, SizeInBytes> itemDataSizes = new HashMap<BasicLoadGenerator, SizeInBytes>(loadGeneratorCount);
        HashMap<BasicLoadGenerator, LoadConfig> loadConfigMap = new HashMap<BasicLoadGenerator, LoadConfig>(loadGeneratorCount);
        HashMap<BasicLoadGenerator, OutputConfig> outputConfigMap = new HashMap<BasicLoadGenerator, OutputConfig>(loadGeneratorCount);
        HashMap<BasicLoadGenerator, StepConfig> stepConfigMap = new HashMap<BasicLoadGenerator, StepConfig>(loadGeneratorCount);
        try {
            for (int i = 0; i < loadGeneratorCount; ++i) {
                Config config = new Config(this.localConfig);
                config.apply(this.nodeConfigList.get(i), null);
                ItemConfig itemConfig = config.getItemConfig();
                DataConfig dataConfig = itemConfig.getDataConfig();
                InputConfig dataInputConfig = dataConfig.getInputConfig();
                ItemType itemType = ItemType.valueOf((String)itemConfig.getType().toUpperCase());
                LayerConfig dataLayerConfig = dataInputConfig.getLayerConfig();
                DataInput dataInput = DataInput.getInstance((String)dataInputConfig.getFile(), (String)dataInputConfig.getSeed(), (SizeInBytes)dataLayerConfig.getSize(), (int)dataLayerConfig.getCache());
                ItemFactory itemFactory = ItemType.getItemFactory((ItemType)itemType);
                Loggers.MSG.info("Work on the " + itemType.toString().toLowerCase() + " items");
                LoadConfig loadConfig = config.getLoadConfig();
                OutputConfig outputConfig = config.getOutputConfig();
                MetricsConfig metricsConfig = outputConfig.getMetricsConfig();
                StorageConfig storageConfig = config.getStorageConfig();
                LimitConfig limitConfig = stepConfig.getLimitConfig();
                ArrayList<StorageDriver> drivers = new ArrayList<StorageDriver>();
                StorageDriverUtil.init(drivers, itemConfig, loadConfig, metricsConfig.getAverageConfig(), storageConfig, stepConfig, dataInput);
                BasicLoadGenerator loadGenerator = new BasicLoadGeneratorBuilder().setItemConfig(itemConfig).setItemFactory(itemFactory).setItemType(itemType).setLoadConfig(loadConfig).setLimitConfig(limitConfig).setStorageDrivers(drivers).setAuthConfig(storageConfig.getAuthConfig()).build();
                driverMap.put(loadGenerator, drivers);
                if (weightMap != null) {
                    weightMap.put(loadGenerator.hashCode(), this.weights.get(i).intValue());
                }
                itemDataSizes.put(loadGenerator, dataConfig.getSize());
                loadConfigMap.put(loadGenerator, loadConfig);
                outputConfigMap.put(loadGenerator, outputConfig);
                stepConfigMap.put(loadGenerator, stepConfig);
            }
        }
        catch (IOException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to init the content source", (Object[])new Object[0]);
        }
        catch (UserShootHisFootException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to init the load generator", (Object[])new Object[0]);
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
        try (BasicLoadController controller = new BasicLoadController(stepId, driverMap, (Int2IntMap)weightMap, itemDataSizes, loadConfigMap, stepConfig, outputConfigMap);){
            String itemOutputFile = this.localConfig.getItemConfig().getOutputConfig().getFile();
            if (itemOutputFile != null && itemOutputFile.length() > 0) {
                Path itemOutputPath = Paths.get(itemOutputFile, new String[0]);
                if (Files.exists(itemOutputPath, new LinkOption[0])) {
                    Loggers.ERR.warn("Items output file \"{}\" already exists", (Object)itemOutputPath);
                }
                ItemInfoFileOutput itemOutput = new ItemInfoFileOutput(itemOutputPath);
                controller.setIoResultsOutput((Output)itemOutput);
            }
            controller.start();
            Loggers.MSG.info("Mixed load step \"{}\" started", (Object)controller.getName());
            if (controller.await(timeLimitSec, TimeUnit.SECONDS)) {
                Loggers.MSG.info("Mixed load step \"{}\" done", (Object)controller.getName());
            } else {
                Loggers.MSG.info("Mixed load step \"{}\" timeout", (Object)controller.getName());
            }
        }
        catch (RemoteException e) {
            LogUtil.exception((Level)Level.ERROR, (Throwable)e, (String)"Unexpected failure", (Object[])new Object[0]);
        }
        catch (IOException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to open the item output file", (Object[])new Object[0]);
        }
        catch (InterruptedException e) {
            Loggers.MSG.debug("Load step interrupted");
            throw new CancellationException();
        }
    }

    @Override
    public void close() throws IOException {
        this.nodeConfigList.clear();
        if (this.weights != null) {
            this.weights.clear();
        }
    }
}

