/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.run.scenario.step;

import com.emc.mongoose.api.model.concurrent.LogContextThreadFactory;
import com.emc.mongoose.run.scenario.ScenarioParseException;
import com.emc.mongoose.run.scenario.step.CompositeStepBase;
import com.emc.mongoose.run.scenario.step.Step;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.log.Loggers;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ParallelStep
extends CompositeStepBase {
    protected ParallelStep(Config appConfig, Map<String, Object> subTree) throws ScenarioParseException {
        super(appConfig, subTree);
    }

    @Override
    protected final synchronized void invoke() throws CancellationException {
        ExecutorService parallelJobsExecutor = Executors.newFixedThreadPool(this.childSteps.size(), (ThreadFactory)new LogContextThreadFactory("stepWorker" + this.hashCode(), true));
        for (Step subStep : this.childSteps) {
            parallelJobsExecutor.submit(subStep);
        }
        Loggers.MSG.info("{}: execute {} child steps in parallel", (Object)this.toString(), (Object)this.childSteps.size());
        parallelJobsExecutor.shutdown();
        long limitTime = this.localConfig.getTestConfig().getStepConfig().getLimitConfig().getTime();
        try {
            if (limitTime > 0L) {
                parallelJobsExecutor.awaitTermination(limitTime, TimeUnit.SECONDS);
            } else {
                parallelJobsExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            Loggers.MSG.debug("{}: interrupted the child steps execution", (Object)this.toString());
            throw new CancellationException();
        }
        finally {
            parallelJobsExecutor.shutdownNow();
        }
        Loggers.MSG.info("{}: finished parallel execution of {} child steps", (Object)this.toString(), (Object)this.childSteps.size());
    }

    public String toString() {
        return "parallelStep#" + this.hashCode();
    }
}

