/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.coop.netty.http.atmos;

import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.storage.driver.coop.netty.http.HttpResponseHandlerBase;
import com.emc.mongoose.storage.driver.coop.netty.http.HttpStorageDriverBase;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;

public final class AtmosResponseHandler<I extends Item, O extends Operation<I>>
extends HttpResponseHandlerBase<I, O> {
    private final boolean fsAccess;

    public AtmosResponseHandler(HttpStorageDriverBase<I, O> driver, boolean verifyFlag, boolean fsAccess) {
        super(driver, verifyFlag);
        this.fsAccess = fsAccess;
    }

    protected final void handleResponseHeaders(Channel channel, O op, HttpHeaders respHeaders) {
        String location;
        if (!this.fsAccess && (location = respHeaders.get((CharSequence)HttpHeaderNames.LOCATION)) != null && !location.isEmpty()) {
            if (location.startsWith("/rest/namespace")) {
                op.item().name(location.substring("/rest/namespace".length()));
            } else if (location.startsWith("/rest/objects")) {
                op.item().name(location.substring("/rest/objects".length()));
            } else {
                op.item().name(location);
                Loggers.ERR.warn("Unexpected location value: \"{}\"", (Object)location);
            }
            op.srcPath(null);
            op.dstPath(null);
        }
    }
}

