/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.coop.netty.http.atmos;

import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.storage.Credential;
import com.emc.mongoose.storage.driver.coop.netty.http.HttpStorageDriverBase;
import com.emc.mongoose.storage.driver.coop.netty.http.atmos.AtmosApi;
import com.emc.mongoose.storage.driver.coop.netty.http.atmos.AtmosResponseHandler;
import com.github.akurilov.commons.lang.Exceptions;
import com.github.akurilov.confuse.Config;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.Level;

public class AtmosStorageDriver<I extends Item, O extends Operation<I>>
extends HttpStorageDriverBase<I, O> {
    private static final ThreadLocal<StringBuilder> BUFF_CANONICAL = ThreadLocal.withInitial(StringBuilder::new);
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final ThreadLocal<Map<String, Mac>> MAC_BY_SECRET = ThreadLocal.withInitial(HashMap::new);
    private static final Function<String, Mac> GET_MAC_BY_SECRET = secret -> {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(BASE64_DECODER.decode(secret.getBytes(StandardCharsets.UTF_8)), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKey);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            LogUtil.exception((Level)Level.ERROR, (Throwable)e, (String)"Failed to init MAC for the given secret key", (Object[])new Object[0]);
        }
        catch (IllegalArgumentException e) {
            LogUtil.exception((Level)Level.ERROR, (Throwable)e, (String)"Failed to perform the secret key Base-64 decoding", (Object[])new Object[0]);
        }
        return null;
    };
    protected final boolean fsAccess;

    public AtmosStorageDriver(String stepId, DataInput dataInput, Config storageConfig, boolean verifyFlag, int batchSize) throws IllegalConfigurationException, InterruptedException {
        super(stepId, dataInput, storageConfig, verifyFlag, batchSize);
        Config httpConfig = storageConfig.configVal("net-http");
        this.fsAccess = httpConfig.boolVal("fsAccess");
        if (this.namespace != null && !this.namespace.isEmpty()) {
            this.sharedHeaders.set("x-emc-namespace", (Object)this.namespace);
        }
        this.requestNewPathFunc = null;
    }

    protected final String requestNewPath(String path) {
        throw new AssertionError((Object)"Should not be invoked");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String requestNewAuthToken(Credential credential) {
        String nodeAddr = this.storageNodeAddrs[0];
        String uriQuery = this.uriQuery();
        String uri = uriQuery == null || uriQuery.isEmpty() ? "/rest/subtenant" : "/rest/subtenant" + uriQuery;
        DefaultHttpHeaders reqHeaders = new DefaultHttpHeaders();
        reqHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)nodeAddr);
        reqHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        if (this.fsAccess) {
            reqHeaders.set("x-emc-filesystem-access-enabled", (Object)Boolean.toString(this.fsAccess));
        }
        this.applyDynamicHeaders((HttpHeaders)reqHeaders);
        this.applySharedHeaders((HttpHeaders)reqHeaders);
        this.applyAuthHeaders((HttpHeaders)reqHeaders, HttpMethod.PUT, uri, credential);
        DefaultFullHttpRequest getSubtenantReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, uri, Unpooled.EMPTY_BUFFER, (HttpHeaders)reqHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        String subtenantId = null;
        try {
            FullHttpResponse getSubtenantResp = this.executeHttpRequest((FullHttpRequest)getSubtenantReq);
            try {
                if (HttpStatusClass.SUCCESS.equals((Object)getSubtenantResp.status().codeClass())) {
                    subtenantId = getSubtenantResp.headers().get("subtenantID");
                } else {
                    Loggers.ERR.warn("Creating the subtenant: got response {}", (Object)getSubtenantResp.status().toString());
                }
            }
            finally {
                getSubtenantResp.release();
            }
        }
        catch (InterruptedException e) {
            Exceptions.throwUnchecked((Throwable)e);
        }
        catch (ConnectException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to connect to the storage node", (Object[])new Object[0]);
        }
        return subtenantId;
    }

    public final List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count) throws IOException {
        return null;
    }

    protected final void appendHandlers(Channel channel) {
        super.appendHandlers(channel);
        channel.pipeline().addLast(new ChannelHandler[]{new AtmosResponseHandler(this, this.verifyFlag, this.fsAccess)});
    }

    protected final HttpMethod dataHttpMethod(OpType opType) {
        switch (opType) {
            case NOOP: {
                return HttpMethod.HEAD;
            }
            case CREATE: {
                return HttpMethod.POST;
            }
            case READ: {
                return HttpMethod.GET;
            }
            case UPDATE: {
                return HttpMethod.PUT;
            }
            case DELETE: {
                return HttpMethod.DELETE;
            }
        }
        throw new AssertionError((Object)("Unsupported I/O type: " + opType));
    }

    protected final HttpMethod tokenHttpMethod(OpType opType) {
        switch (opType) {
            case NOOP: {
                return HttpMethod.HEAD;
            }
            case CREATE: {
                return HttpMethod.PUT;
            }
            case READ: {
                return HttpMethod.GET;
            }
            case DELETE: {
                return HttpMethod.DELETE;
            }
        }
        throw new AssertionError((Object)"Not implemented yet");
    }

    protected final HttpMethod pathHttpMethod(OpType opType) {
        throw new AssertionError((Object)"Not implemented yet");
    }

    protected final String dataUriPath(I item, String srcPath, String dstPath, OpType opType) {
        if (this.fsAccess) {
            return "/rest/namespace" + super.dataUriPath(item, srcPath, dstPath, opType);
        }
        if (OpType.CREATE.equals((Object)opType)) {
            return "/rest/objects";
        }
        return "/rest/objects" + super.dataUriPath(item, srcPath, dstPath, opType);
    }

    protected final String tokenUriPath(I item, String srcPath, String dstPath, OpType opType) {
        if (OpType.CREATE.equals((Object)opType)) {
            return "/rest/subtenant";
        }
        return "/rest/subtenant/" + item.name();
    }

    protected final String pathUriPath(I item, String srcPath, String dstPath, OpType opType) {
        throw new AssertionError((Object)"Not implemented yet");
    }

    protected final void applyMetaDataHeaders(HttpHeaders httpHeaders) {
    }

    protected final void applyAuthHeaders(HttpHeaders httpHeaders, HttpMethod httpMethod, String dstUriPath, Credential credential) {
        String secret;
        String uid;
        String authToken;
        if (credential != null) {
            authToken = (String)this.authTokens.get(credential);
            uid = credential.getUid();
            secret = credential.getSecret();
        } else if (this.credential != null) {
            authToken = (String)this.authTokens.get(this.credential);
            uid = this.credential.getUid();
            secret = this.credential.getSecret();
        } else {
            authToken = null;
            uid = null;
            secret = null;
        }
        if (uid != null && !uid.isEmpty()) {
            if (authToken != null && !authToken.isEmpty() && !dstUriPath.equals("/rest/subtenant")) {
                httpHeaders.set("x-emc-uid", (Object)(authToken + "/" + uid));
            } else {
                httpHeaders.set("x-emc-uid", (Object)uid);
            }
        }
        if (secret != null && !secret.isEmpty()) {
            Mac mac = MAC_BY_SECRET.get().computeIfAbsent(secret, GET_MAC_BY_SECRET);
            String canonicalForm = this.getCanonical(httpHeaders, httpMethod, dstUriPath);
            byte[] sigData = mac.doFinal(canonicalForm.getBytes());
            httpHeaders.set("x-emc-signature", (Object)BASE64_ENCODER.encodeToString(sigData));
        }
    }

    protected String getCanonical(HttpHeaders httpHeaders, HttpMethod httpMethod, String dstUriPath) {
        String headerName;
        StringBuilder buffCanonical = BUFF_CANONICAL.get();
        buffCanonical.setLength(0);
        buffCanonical.append(httpMethod.name());
        for (AsciiString headerName2 : AtmosApi.HEADERS_CANONICAL) {
            if (httpHeaders.contains((CharSequence)headerName2)) {
                for (String headerValue : httpHeaders.getAll((CharSequence)headerName2)) {
                    buffCanonical.append('\n').append(headerValue);
                }
                continue;
            }
            if (this.sharedHeaders != null && this.sharedHeaders.contains((CharSequence)headerName2)) {
                buffCanonical.append('\n').append(this.sharedHeaders.get((CharSequence)headerName2));
                continue;
            }
            buffCanonical.append('\n');
        }
        buffCanonical.append('\n').append(dstUriPath);
        TreeMap<String, String> sortedHeaders = new TreeMap<String, String>();
        if (this.sharedHeaders != null) {
            for (Map.Entry header : this.sharedHeaders) {
                headerName = ((String)header.getKey()).toLowerCase();
                if (!headerName.startsWith("x-emc-") || headerName.equals("x-emc-signature")) continue;
                sortedHeaders.put(headerName, (String)header.getValue());
            }
        }
        for (Map.Entry header : httpHeaders) {
            headerName = ((String)header.getKey()).toLowerCase();
            if (!headerName.startsWith("x-emc-") || headerName.equals("x-emc-signature")) continue;
            sortedHeaders.put(headerName, (String)header.getValue());
        }
        for (Map.Entry sortedHeader : sortedHeaders.entrySet()) {
            buffCanonical.append('\n').append((String)sortedHeader.getKey()).append(':').append((String)sortedHeader.getValue());
        }
        if (Loggers.MSG.isTraceEnabled()) {
            Loggers.MSG.trace("Canonical representation:\n{}", (Object)buffCanonical);
        }
        return buffCanonical.toString();
    }

    protected final void applyCopyHeaders(HttpHeaders httpHeaders, String srcPath) throws URISyntaxException {
    }

    public final String toString() {
        return String.format(super.toString(), "atmos");
    }
}

