/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.coop.netty.http.atmos;

import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.env.ExtensionBase;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.storage.driver.StorageDriverFactory;
import com.emc.mongoose.storage.driver.coop.netty.http.atmos.AtmosStorageDriver;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.SchemaProvider;
import com.github.akurilov.confuse.io.yaml.YamlSchemaProviderBase;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AtmosStorageDriverExtension<I extends Item, O extends Operation<I>, T extends AtmosStorageDriver<I, O>>
extends ExtensionBase
implements StorageDriverFactory<I, O, T> {
    private static final String NAME = "atmos";
    private static final String DEFAULTS_FILE_NAME = "defaults-storage-atmos.yaml";
    private static final List<String> RES_INSTALL_FILES = Collections.unmodifiableList(Arrays.asList("config/defaults-storage-atmos.yaml"));

    public String id() {
        return NAME;
    }

    public T create(String stepId, DataInput dataInput, Config storageConfig, boolean verifyFlag, int batchSize) throws IllegalConfigurationException, InterruptedException {
        return (T)((Object)new AtmosStorageDriver(stepId, dataInput, storageConfig, verifyFlag, batchSize));
    }

    public final SchemaProvider schemaProvider() {
        return new YamlSchemaProviderBase(){

            protected final InputStream schemaInputStream() {
                return ((Object)((Object)this)).getClass().getResourceAsStream("/config-schema-storage-atmos.yaml");
            }

            public final String id() {
                return "mongoose";
            }
        };
    }

    protected final String defaultsFileName() {
        return DEFAULTS_FILE_NAME;
    }

    protected final List<String> resourceFilesToInstall() {
        return RES_INSTALL_FILES;
    }
}

