/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.builder;

import com.emc.mongoose.api.common.env.Extensions;
import com.emc.mongoose.api.common.exception.OmgShootMyFootException;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.api.model.storage.StorageDriver;
import com.emc.mongoose.storage.driver.base.StorageDriverFactory;
import com.emc.mongoose.storage.driver.builder.StorageDriverBuilder;
import com.emc.mongoose.ui.config.item.ItemConfig;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.output.metrics.average.AverageConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.storage.driver.DriverConfig;
import com.emc.mongoose.ui.log.Loggers;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.logging.log4j.CloseableThreadContext;

public class BasicStorageDriverBuilder<I extends Item, O extends IoTask<I>, T extends StorageDriver<I, O>>
implements StorageDriverBuilder<I, O, T> {
    private String stepName;
    private DataInput contentSrc;
    private ItemConfig itemConfig;
    private LoadConfig loadConfig;
    private AverageConfig avgMetricsConfig;
    private StorageConfig storageConfig;

    protected final String getStepId() {
        return this.stepName;
    }

    @Override
    public ItemConfig getItemConfig() {
        return this.itemConfig;
    }

    @Override
    public LoadConfig getLoadConfig() {
        return this.loadConfig;
    }

    @Override
    public AverageConfig getAverageConfig() {
        return this.avgMetricsConfig;
    }

    @Override
    public StorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    @Override
    public BasicStorageDriverBuilder<I, O, T> setTestStepName(String jobName) {
        this.stepName = jobName;
        return this;
    }

    @Override
    public BasicStorageDriverBuilder<I, O, T> setContentSource(DataInput contentSrc) {
        this.contentSrc = contentSrc;
        return this;
    }

    @Override
    public BasicStorageDriverBuilder<I, O, T> setItemConfig(ItemConfig itemConfig) {
        this.itemConfig = itemConfig;
        return this;
    }

    @Override
    public BasicStorageDriverBuilder<I, O, T> setLoadConfig(LoadConfig loadConfig) {
        this.loadConfig = loadConfig;
        return this;
    }

    @Override
    public BasicStorageDriverBuilder<I, O, T> setAverageConfig(AverageConfig avgMetricsConfig) {
        this.avgMetricsConfig = avgMetricsConfig;
        return this;
    }

    @Override
    public BasicStorageDriverBuilder<I, O, T> setStorageConfig(StorageConfig storageConfig) {
        this.storageConfig = storageConfig;
        return this;
    }

    @Override
    public T build() throws OmgShootMyFootException, InterruptedException {
        try (CloseableThreadContext.Instance ctx = CloseableThreadContext.put((String)"stepId", (String)this.stepName).put("className", BasicStorageDriverBuilder.class.getSimpleName());){
            DriverConfig driverConfig = this.storageConfig.getDriverConfig();
            String driverType = driverConfig.getType();
            boolean verifyFlag = this.itemConfig.getDataConfig().getVerify();
            ServiceLoader<StorageDriverFactory> loader = ServiceLoader.load(StorageDriverFactory.class, Extensions.CLS_LOADER);
            for (StorageDriverFactory storageDriverFactory : loader) {
                if (!driverType.equals(storageDriverFactory.getName())) continue;
                StorageDriver storageDriver = storageDriverFactory.create(this.stepName, this.contentSrc, this.loadConfig, this.storageConfig, verifyFlag);
                return (T)storageDriver;
            }
            Loggers.ERR.fatal("Failed to create the storage driver for the type \"{}\"", (Object)driverType);
            Iterator<StorageDriverFactory> iterator = null;
            return (T)iterator;
        }
    }
}

