/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.fs;

import com.emc.mongoose.api.model.data.DataCorruptionException;
import com.emc.mongoose.api.model.data.DataSizeException;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.data.DataIoTask;
import com.emc.mongoose.api.model.item.DataItem;
import com.emc.mongoose.ui.log.Loggers;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.system.DirectMemUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.BitSet;
import java.util.List;

public interface FileIoHelper {
    public static <I extends DataItem, O extends DataIoTask<I>> boolean invokeCreate(I fileItem, O ioTask, FileChannel dstChannel) throws IOException {
        long contentSize;
        long countBytesDone = ioTask.getCountBytesDone();
        if (countBytesDone < (contentSize = fileItem.size()) && IoTask.Status.ACTIVE.equals((Object)ioTask.getStatus())) {
            countBytesDone += fileItem.writeToFileChannel(dstChannel, contentSize - countBytesDone);
            ioTask.setCountBytesDone(countBytesDone);
        }
        return countBytesDone >= contentSize;
    }

    public static <I extends DataItem, O extends DataIoTask<I>> boolean invokeCopy(I fileItem, O ioTask, FileChannel srcChannel, FileChannel dstChannel) throws IOException {
        long contentSize;
        long countBytesDone = ioTask.getCountBytesDone();
        if (countBytesDone < (contentSize = fileItem.size()) && IoTask.Status.ACTIVE.equals((Object)ioTask.getStatus())) {
            countBytesDone += srcChannel.transferTo(countBytesDone, contentSize - countBytesDone, dstChannel);
            ioTask.setCountBytesDone(countBytesDone);
        }
        return countBytesDone >= contentSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <I extends DataItem, O extends DataIoTask<I>> boolean invokeReadAndVerify(I fileItem, O ioTask, ReadableByteChannel srcChannel) throws DataSizeException, DataCorruptionException, IOException {
        long contentSize;
        long countBytesDone = ioTask.getCountBytesDone();
        if (countBytesDone < (contentSize = fileItem.size())) {
            if (fileItem.isUpdated()) {
                DataItem currRange = ioTask.getCurrRange();
                int nextRangeIdx = ioTask.getCurrRangeIdx() + 1;
                long nextRangeOffset = DataItem.getRangeOffset((int)nextRangeIdx);
                if (currRange == null) throw new AssertionError((Object)"Null data range");
                MappedByteBuffer inBuff = DirectMemUtil.getThreadLocalReusableBuff((long)(nextRangeOffset - countBytesDone));
                int n = srcChannel.read(inBuff);
                if (n < 0) {
                    throw new DataSizeException(contentSize, countBytesDone);
                }
                ((ByteBuffer)inBuff).flip();
                currRange.verify((ByteBuffer)inBuff);
                currRange.position(currRange.position() + (long)n);
                if ((countBytesDone += (long)n) == nextRangeOffset) {
                    ioTask.setCurrRangeIdx(nextRangeIdx);
                }
            } else {
                MappedByteBuffer inBuff = DirectMemUtil.getThreadLocalReusableBuff((long)(contentSize - countBytesDone));
                int n = srcChannel.read(inBuff);
                if (n < 0) {
                    throw new DataSizeException(contentSize, countBytesDone);
                }
                ((ByteBuffer)inBuff).flip();
                fileItem.verify((ByteBuffer)inBuff);
                fileItem.position(fileItem.position() + (long)n);
                countBytesDone += (long)n;
            }
            ioTask.setCountBytesDone(countBytesDone);
        }
        if (countBytesDone < contentSize) return false;
        return true;
    }

    public static <I extends DataItem, O extends DataIoTask<I>> boolean invokeReadAndVerifyRandomRanges(I fileItem, O ioTask, SeekableByteChannel srcChannel, BitSet[] maskRangesPair) throws DataSizeException, DataCorruptionException, IOException {
        long countBytesDone = ioTask.getCountBytesDone();
        long rangesSizeSum = ioTask.getMarkedRangesSize();
        if (rangesSizeSum > 0L && rangesSizeSum > countBytesDone) {
            DataItem range2read;
            int currRangeIdx;
            block10: {
                while ((currRangeIdx = ioTask.getCurrRangeIdx()) < DataItem.getRangeCount((long)fileItem.size())) {
                    if (maskRangesPair[0].get(currRangeIdx) || maskRangesPair[1].get(currRangeIdx)) {
                        range2read = ioTask.getCurrRange();
                        if (Loggers.MSG.isTraceEnabled()) {
                            Loggers.MSG.trace("I/O task: {}, Range index: {}, size: {}, internal position: {}, Done byte count: {}", (Object)ioTask.toString(), (Object)currRangeIdx, (Object)range2read.size(), (Object)range2read.position(), (Object)countBytesDone);
                        }
                        break block10;
                    }
                    ioTask.setCurrRangeIdx(++currRangeIdx);
                }
                ioTask.setCountBytesDone(rangesSizeSum);
                return true;
            }
            long currRangeSize = range2read.size();
            long currPos = DataItem.getRangeOffset((int)currRangeIdx) + countBytesDone;
            srcChannel.position(currPos);
            MappedByteBuffer inBuff = DirectMemUtil.getThreadLocalReusableBuff((long)(currRangeSize - countBytesDone));
            int n = srcChannel.read(inBuff);
            if (n < 0) {
                throw new DataSizeException(rangesSizeSum, countBytesDone);
            }
            ((ByteBuffer)inBuff).flip();
            try {
                range2read.verify((ByteBuffer)inBuff);
                range2read.position(range2read.position() + (long)n);
                countBytesDone += (long)n;
            }
            catch (DataCorruptionException e) {
                throw new DataCorruptionException(currPos + e.getOffset() - countBytesDone, e.expected, e.actual);
            }
            if (Loggers.MSG.isTraceEnabled()) {
                Loggers.MSG.trace("I/O task: {}, Done bytes count: {}, Curr range size: {}", (Object)ioTask.toString(), (Object)countBytesDone, (Object)range2read.size());
            }
            if (countBytesDone == currRangeSize) {
                ioTask.setCurrRangeIdx(currRangeIdx + 1);
                ioTask.setCountBytesDone(0L);
            } else {
                ioTask.setCountBytesDone(countBytesDone);
            }
        }
        return rangesSizeSum <= 0L || rangesSizeSum <= countBytesDone;
    }

    public static <I extends DataItem, O extends DataIoTask<I>> boolean invokeReadAndVerifyFixedRanges(I fileItem, O ioTask, SeekableByteChannel srcChannel, List<Range> fixedRanges) throws DataSizeException, DataCorruptionException, IOException {
        long countBytesDone;
        long baseItemSize = fileItem.size();
        long fixedRangesSizeSum = ioTask.getMarkedRangesSize();
        long rangeBytesDone = countBytesDone = ioTask.getCountBytesDone();
        if (fixedRangesSizeSum > 0L && fixedRangesSizeSum > countBytesDone) {
            int currFixedRangeIdx = ioTask.getCurrRangeIdx();
            if (currFixedRangeIdx < fixedRanges.size()) {
                long fixedRangeSize;
                Range fixedRange = fixedRanges.get(currFixedRangeIdx);
                long currOffset = fixedRange.getBeg();
                long fixedRangeEnd = fixedRange.getEnd();
                if (currOffset == -1L) {
                    currOffset = baseItemSize - fixedRangeEnd;
                    fixedRangeSize = fixedRangeEnd;
                } else {
                    fixedRangeSize = fixedRangeEnd == -1L ? baseItemSize - currOffset : fixedRangeEnd - currOffset + 1L;
                }
                int n = DataItem.getRangeCount((long)((currOffset += rangeBytesDone) + 1L)) - 1;
                long cellOffset = DataItem.getRangeOffset((int)n);
                long cellEnd = Math.min(baseItemSize, DataItem.getRangeOffset((int)(n + 1)));
                DataItem currRange = fileItem.slice(cellOffset, cellEnd - cellOffset);
                if (fileItem.isRangeUpdated(n)) {
                    currRange.layer(fileItem.layer() + 1);
                }
                currRange.position(currOffset - cellOffset);
                srcChannel.position(currOffset);
                MappedByteBuffer inBuff = DirectMemUtil.getThreadLocalReusableBuff((long)Math.min(fixedRangeSize - countBytesDone, currRange.size() - currRange.position()));
                int m = srcChannel.read(inBuff);
                if (m >= 0) {
                    ((ByteBuffer)inBuff).flip();
                    try {
                        currRange.verify((ByteBuffer)inBuff);
                        currRange.position(currRange.position() + (long)m);
                        rangeBytesDone += (long)m;
                    }
                    catch (DataCorruptionException e) {
                        throw new DataCorruptionException(currOffset + e.getOffset() - countBytesDone, e.expected, e.actual);
                    }
                }
                if (rangeBytesDone == fixedRangeSize) {
                    if (currFixedRangeIdx == fixedRanges.size() - 1) {
                        ioTask.setCountBytesDone(fixedRangesSizeSum);
                        return true;
                    }
                    ioTask.setCurrRangeIdx(currFixedRangeIdx + 1);
                    rangeBytesDone = 0L;
                }
                ioTask.setCountBytesDone(rangeBytesDone);
            } else {
                ioTask.setCountBytesDone(fixedRangesSizeSum);
            }
        }
        return fixedRangesSizeSum <= 0L || fixedRangesSizeSum <= countBytesDone;
    }

    public static <I extends DataItem, O extends DataIoTask<I>> boolean invokeRead(I fileItem, O ioTask, ReadableByteChannel srcChannel) throws IOException {
        long contentSize;
        long countBytesDone = ioTask.getCountBytesDone();
        if (countBytesDone < (contentSize = fileItem.size())) {
            int n = srcChannel.read(DirectMemUtil.getThreadLocalReusableBuff((long)(contentSize - countBytesDone)));
            if (n < 0) {
                ioTask.setCountBytesDone(countBytesDone);
                fileItem.size(countBytesDone);
                return true;
            }
            ioTask.setCountBytesDone(countBytesDone += (long)n);
        }
        return countBytesDone == contentSize;
    }

    public static <I extends DataItem, O extends DataIoTask<I>> boolean invokeReadRandomRanges(I fileItem, O ioTask, FileChannel srcChannel, BitSet[] maskRangesPair) throws IOException {
        long countBytesDone = ioTask.getCountBytesDone();
        long rangesSizeSum = ioTask.getMarkedRangesSize();
        if (rangesSizeSum > 0L && rangesSizeSum > countBytesDone) {
            int currRangeIdx;
            block6: {
                while ((currRangeIdx = ioTask.getCurrRangeIdx()) < DataItem.getRangeCount((long)fileItem.size())) {
                    if (!maskRangesPair[0].get(currRangeIdx) && !maskRangesPair[1].get(currRangeIdx)) {
                        ioTask.setCurrRangeIdx(++currRangeIdx);
                        continue;
                    }
                    break block6;
                }
                ioTask.setCountBytesDone(rangesSizeSum);
                return true;
            }
            DataItem range2read = ioTask.getCurrRange();
            long currRangeSize = range2read.size();
            int n = srcChannel.read(DirectMemUtil.getThreadLocalReusableBuff((long)(currRangeSize - countBytesDone)), DataItem.getRangeOffset((int)currRangeIdx) + countBytesDone);
            if (n < 0) {
                ioTask.setCountBytesDone(countBytesDone);
                return true;
            }
            if ((countBytesDone += (long)n) == currRangeSize) {
                ioTask.setCurrRangeIdx(currRangeIdx + 1);
                ioTask.setCountBytesDone(0L);
            } else {
                ioTask.setCountBytesDone(countBytesDone);
            }
        }
        return rangesSizeSum <= 0L || rangesSizeSum <= countBytesDone;
    }

    public static <I extends DataItem, O extends DataIoTask<I>> boolean invokeReadFixedRanges(I fileItem, O ioTask, FileChannel srcChannel, List<Range> byteRanges) throws IOException {
        long countBytesDone = ioTask.getCountBytesDone();
        long baseItemSize = fileItem.size();
        long rangesSizeSum = ioTask.getMarkedRangesSize();
        if (rangesSizeSum > 0L && rangesSizeSum > countBytesDone) {
            int currRangeIdx = ioTask.getCurrRangeIdx();
            if (currRangeIdx < byteRanges.size()) {
                long rangeSize;
                Range byteRange = byteRanges.get(currRangeIdx);
                long rangeBeg = byteRange.getBeg();
                long rangeEnd = byteRange.getEnd();
                if (rangeBeg == -1L) {
                    rangeBeg = baseItemSize - rangeEnd;
                    rangeSize = rangeEnd;
                } else {
                    rangeSize = rangeEnd == -1L ? baseItemSize - rangeBeg : rangeEnd - rangeBeg + 1L;
                }
                int n = srcChannel.read(DirectMemUtil.getThreadLocalReusableBuff((long)(rangeSize - countBytesDone)), rangeBeg + countBytesDone);
                if (n < 0) {
                    ioTask.setCountBytesDone(countBytesDone);
                    return true;
                }
                if ((countBytesDone += (long)n) == rangeSize) {
                    ioTask.setCurrRangeIdx(currRangeIdx + 1);
                    ioTask.setCountBytesDone(0L);
                } else {
                    ioTask.setCountBytesDone(countBytesDone);
                }
            } else {
                ioTask.setCountBytesDone(rangesSizeSum);
            }
        }
        return rangesSizeSum <= 0L || rangesSizeSum <= countBytesDone;
    }

    public static <I extends DataItem, O extends DataIoTask<I>> boolean invokeRandomRangesUpdate(I fileItem, O ioTask, FileChannel dstChannel) throws IOException {
        long countBytesDone = ioTask.getCountBytesDone();
        long updatingRangesSize = ioTask.getMarkedRangesSize();
        if (updatingRangesSize > 0L && updatingRangesSize > countBytesDone) {
            DataItem updatingRange;
            int currRangeIdx;
            block8: {
                while ((currRangeIdx = ioTask.getCurrRangeIdx()) < DataItem.getRangeCount((long)fileItem.size())) {
                    updatingRange = ioTask.getCurrRangeUpdate();
                    if (updatingRange == null) {
                        ioTask.setCurrRangeIdx(++currRangeIdx);
                        continue;
                    }
                    break block8;
                }
                ioTask.setCountBytesDone(updatingRangesSize);
                return true;
            }
            long updatingRangeSize = updatingRange.size();
            if (Loggers.MSG.isTraceEnabled()) {
                Loggers.MSG.trace("{}: set the file position = {} + {}", (Object)fileItem.getName(), (Object)DataItem.getRangeOffset((int)currRangeIdx), (Object)countBytesDone);
            }
            dstChannel.position(DataItem.getRangeOffset((int)currRangeIdx) + countBytesDone);
            countBytesDone += updatingRange.writeToFileChannel(dstChannel, updatingRangeSize - countBytesDone);
            if (Loggers.MSG.isTraceEnabled()) {
                Loggers.MSG.trace("{}: {} bytes written totally", (Object)fileItem.getName(), (Object)countBytesDone);
            }
            if (countBytesDone == updatingRangeSize) {
                ioTask.setCurrRangeIdx(currRangeIdx + 1);
                ioTask.setCountBytesDone(0L);
            } else {
                ioTask.setCountBytesDone(countBytesDone);
            }
        } else {
            fileItem.commitUpdatedRanges(ioTask.getMarkedRangesMaskPair());
            ioTask.setCountBytesDone(updatingRangesSize);
        }
        return updatingRangesSize <= 0L || updatingRangesSize <= countBytesDone;
    }

    public static <I extends DataItem, O extends DataIoTask<I>> boolean invokeFixedRangesUpdate(I fileItem, O ioTask, FileChannel dstChannel, List<Range> byteRanges) throws IOException {
        long countBytesDone = ioTask.getCountBytesDone();
        long baseItemSize = fileItem.size();
        long updatingRangesSize = ioTask.getMarkedRangesSize();
        if (updatingRangesSize > 0L && updatingRangesSize > countBytesDone) {
            int currRangeIdx = ioTask.getCurrRangeIdx();
            if (currRangeIdx < byteRanges.size()) {
                Range byteRange = byteRanges.get(currRangeIdx);
                long rangeBeg = byteRange.getBeg();
                long rangeEnd = byteRange.getEnd();
                long rangeSize = byteRange.getSize();
                if (rangeSize == -1L) {
                    if (rangeBeg == -1L) {
                        rangeBeg = baseItemSize - rangeEnd;
                        rangeSize = rangeEnd;
                    } else {
                        rangeSize = rangeEnd == -1L ? baseItemSize - rangeBeg : rangeEnd - rangeBeg + 1L;
                    }
                } else {
                    rangeBeg = baseItemSize;
                    fileItem.size(baseItemSize + updatingRangesSize);
                }
                DataItem updatingRange = fileItem.slice(rangeBeg, rangeSize);
                updatingRange.position(countBytesDone);
                dstChannel.position(rangeBeg + countBytesDone);
                countBytesDone += updatingRange.writeToFileChannel(dstChannel, rangeSize - countBytesDone);
                if (countBytesDone == rangeSize) {
                    ioTask.setCurrRangeIdx(currRangeIdx + 1);
                    ioTask.setCountBytesDone(0L);
                } else {
                    ioTask.setCountBytesDone(countBytesDone);
                }
            } else {
                ioTask.setCountBytesDone(updatingRangesSize);
            }
        }
        return updatingRangesSize <= 0L || updatingRangesSize <= countBytesDone;
    }

    public static <I extends DataItem, O extends DataIoTask<I>> boolean invokeOverwrite(I fileItem, O ioTask, FileChannel dstChannel) throws IOException {
        long fileSize;
        long countBytesDone = ioTask.getCountBytesDone();
        if (countBytesDone == 0L) {
            dstChannel.position(countBytesDone);
        }
        if (countBytesDone < (fileSize = fileItem.size()) && IoTask.Status.ACTIVE.equals((Object)ioTask.getStatus())) {
            countBytesDone += fileItem.writeToFileChannel(dstChannel, fileSize - countBytesDone);
            ioTask.setCountBytesDone(countBytesDone);
        }
        return countBytesDone >= fileSize;
    }
}

