/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.fs;

import com.emc.mongoose.api.common.exception.OmgShootMyFootException;
import com.emc.mongoose.api.model.data.DataCorruptionException;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.data.DataSizeException;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.data.DataIoTask;
import com.emc.mongoose.api.model.io.task.path.PathIoTask;
import com.emc.mongoose.api.model.item.DataItem;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.api.model.storage.Credential;
import com.emc.mongoose.storage.driver.fs.FileIoHelper;
import com.emc.mongoose.storage.driver.fs.FsConstants;
import com.emc.mongoose.storage.driver.fs.ListingHelper;
import com.emc.mongoose.storage.driver.nio.base.NioStorageDriver;
import com.emc.mongoose.storage.driver.nio.base.NioStorageDriverBase;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Level;

public final class FileStorageDriver<I extends Item, O extends IoTask<I>>
extends NioStorageDriverBase<I, O>
implements NioStorageDriver<I, O> {
    private final Map<DataIoTask, FileChannel> srcOpenFiles = new ConcurrentHashMap<DataIoTask, FileChannel>();
    private final Map<String, File> dstParentDirs = new ConcurrentHashMap<String, File>();
    private final Map<DataIoTask, FileChannel> dstOpenFiles = new ConcurrentHashMap<DataIoTask, FileChannel>();

    public FileStorageDriver(String jobName, DataInput contentSrc, LoadConfig loadConfig, StorageConfig storageConfig, boolean verifyFlag) throws OmgShootMyFootException {
        super(jobName, contentSrc, loadConfig, storageConfig, verifyFlag);
        this.requestAuthTokenFunc = null;
    }

    private <F extends DataItem, D extends DataIoTask<F>> FileChannel openDstFile(D ioTask) {
        String fileItemName = ioTask.getItem().getName();
        IoType ioType = ioTask.getIoType();
        String dstPath = ioTask.getDstPath();
        if (dstPath != null && dstPath.startsWith("/")) {
            dstPath = dstPath.substring(1);
        }
        try {
            Path itemPath;
            if (dstPath == null || dstPath.isEmpty() || fileItemName.startsWith(dstPath)) {
                itemPath = FsConstants.FS.getPath(fileItemName, new String[0]);
            } else {
                this.dstParentDirs.computeIfAbsent(dstPath, FsConstants::createParentDir);
                itemPath = FsConstants.FS.getPath(dstPath, fileItemName);
            }
            if (IoType.CREATE.equals((Object)ioType)) {
                return FsConstants.FS_PROVIDER.newFileChannel(itemPath, FsConstants.CREATE_OPEN_OPT, new FileAttribute[0]);
            }
            return FsConstants.FS_PROVIDER.newFileChannel(itemPath, FsConstants.WRITE_OPEN_OPT, new FileAttribute[0]);
        }
        catch (AccessDeniedException e) {
            ioTask.setStatus(IoTask.Status.RESP_FAIL_AUTH);
            LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"Access denied to open the output channel for the path \"{}\"", (Object[])new Object[]{dstPath});
        }
        catch (NoSuchFileException e) {
            ioTask.setStatus(IoTask.Status.FAIL_IO);
            LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"Failed to open the output channel for the path \"{}\"", (Object[])new Object[]{dstPath});
        }
        catch (FileSystemException e) {
            long freeSpace = new File(e.getFile()).getFreeSpace();
            if (freeSpace > 0L) {
                ioTask.setStatus(IoTask.Status.FAIL_IO);
                LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"Failed to open the output channel for the path \"{}\"", (Object[])new Object[]{dstPath});
            } else {
                ioTask.setStatus(IoTask.Status.RESP_FAIL_SPACE);
                LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"No free space for the path \"{}\"", (Object[])new Object[]{dstPath});
            }
        }
        catch (IOException e) {
            ioTask.setStatus(IoTask.Status.FAIL_IO);
            LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"Failed to open the output channel for the path \"{}\"", (Object[])new Object[]{dstPath});
        }
        catch (Throwable cause) {
            ioTask.setStatus(IoTask.Status.FAIL_UNKNOWN);
            LogUtil.exception((Level)Level.WARN, (Throwable)cause, (String)"Failed to open the output channel for the path \"{}\"", (Object[])new Object[]{dstPath});
        }
        return null;
    }

    protected final String requestNewPath(String path) {
        File pathFile = FsConstants.FS.getPath(!path.startsWith("/") ? path : path.substring(1), new String[0]).toFile();
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        return path;
    }

    protected final String requestNewAuthToken(Credential credential) {
        throw new AssertionError((Object)"Should not be invoked");
    }

    public List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count) throws IOException {
        return ListingHelper.list(itemFactory, path, prefix, idRadix, lastPrevItem, count);
    }

    public final void adjustIoBuffers(long avgTransferSize, IoType ioType) {
    }

    protected final void invokeNio(O ioTask) {
        if (!(ioTask instanceof DataIoTask)) {
            if (ioTask instanceof PathIoTask) {
                throw new AssertionError((Object)"Not implemented");
            }
            throw new AssertionError((Object)"Not implemented");
        }
        this.invokeFileNio((DataIoTask)ioTask);
    }

    protected final <F extends DataItem, D extends DataIoTask<F>> void invokeFileNio(D ioTask) {
        FileChannel srcChannel = null;
        FileChannel dstChannel = null;
        try {
            IoType ioType = ioTask.getIoType();
            DataItem item = ioTask.getItem();
            switch (ioType) {
                case NOOP: {
                    this.finishIoTask((IoTask)ioTask);
                    break;
                }
                case CREATE: {
                    dstChannel = this.dstOpenFiles.computeIfAbsent(ioTask, this::openDstFile);
                    srcChannel = this.srcOpenFiles.computeIfAbsent(ioTask, FsConstants::openSrcFile);
                    if (dstChannel == null) break;
                    if (srcChannel == null) {
                        if (ioTask.getStatus().equals((Object)IoTask.Status.FAIL_IO)) break;
                        if (FileIoHelper.invokeCreate(item, ioTask, dstChannel)) {
                            this.finishIoTask((IoTask)ioTask);
                        }
                    } else if (FileIoHelper.invokeCopy(item, ioTask, srcChannel, dstChannel)) {
                        this.finishIoTask((IoTask)ioTask);
                    }
                    break;
                }
                case READ: {
                    srcChannel = this.srcOpenFiles.computeIfAbsent(ioTask, FsConstants::openSrcFile);
                    if (srcChannel == null) break;
                    List fixedRangesToRead = ioTask.getFixedRanges();
                    if (this.verifyFlag) {
                        try {
                            if (fixedRangesToRead == null || fixedRangesToRead.isEmpty()) {
                                if (ioTask.hasMarkedRanges()) {
                                    if (FileIoHelper.invokeReadAndVerifyRandomRanges(item, ioTask, srcChannel, ioTask.getMarkedRangesMaskPair())) {
                                        ioTask.setCountBytesDone(ioTask.getMarkedRangesSize());
                                        this.finishIoTask((IoTask)ioTask);
                                    }
                                } else if (FileIoHelper.invokeReadAndVerify(item, ioTask, srcChannel)) {
                                    this.finishIoTask((IoTask)ioTask);
                                }
                            } else if (FileIoHelper.invokeReadAndVerifyFixedRanges(item, ioTask, srcChannel, fixedRangesToRead)) {
                                this.finishIoTask((IoTask)ioTask);
                            }
                        }
                        catch (DataSizeException e) {
                            ioTask.setStatus(IoTask.Status.RESP_FAIL_CORRUPT);
                            long countBytesDone = ioTask.getCountBytesDone() + e.getOffset();
                            ioTask.setCountBytesDone(countBytesDone);
                            Loggers.MSG.debug("{}: content size mismatch, expected: {}, actual: {}", (Object)item.getName(), (Object)item.size(), (Object)countBytesDone);
                        }
                        catch (DataCorruptionException e) {
                            ioTask.setStatus(IoTask.Status.RESP_FAIL_CORRUPT);
                            long countBytesDone = ioTask.getCountBytesDone() + e.getOffset();
                            ioTask.setCountBytesDone(countBytesDone);
                            Loggers.MSG.debug("{}: content mismatch @ offset {}, expected: {}, actual: {} ", (Object)item.getName(), (Object)countBytesDone, (Object)String.format("\"0x%X\"", e.expected & 0xFF), (Object)String.format("\"0x%X\"", e.actual & 0xFF));
                        }
                        break;
                    }
                    if (fixedRangesToRead == null || fixedRangesToRead.isEmpty()) {
                        if (ioTask.hasMarkedRanges()) {
                            if (FileIoHelper.invokeReadRandomRanges(item, ioTask, srcChannel, ioTask.getMarkedRangesMaskPair())) {
                                this.finishIoTask((IoTask)ioTask);
                            }
                        } else if (FileIoHelper.invokeRead(item, ioTask, srcChannel)) {
                            this.finishIoTask((IoTask)ioTask);
                        }
                    } else if (FileIoHelper.invokeReadFixedRanges(item, ioTask, srcChannel, fixedRangesToRead)) {
                        this.finishIoTask((IoTask)ioTask);
                    }
                    break;
                }
                case UPDATE: {
                    dstChannel = this.dstOpenFiles.computeIfAbsent(ioTask, this::openDstFile);
                    if (dstChannel == null) break;
                    List fixedRangesToUpdate = ioTask.getFixedRanges();
                    if (fixedRangesToUpdate == null || fixedRangesToUpdate.isEmpty()) {
                        if (ioTask.hasMarkedRanges()) {
                            if (FileIoHelper.invokeRandomRangesUpdate(item, ioTask, dstChannel)) {
                                item.commitUpdatedRanges(ioTask.getMarkedRangesMaskPair());
                                ioTask.setCountBytesDone(ioTask.getMarkedRangesSize());
                                this.finishIoTask((IoTask)ioTask);
                            }
                        } else if (FileIoHelper.invokeOverwrite(item, ioTask, dstChannel)) {
                            this.finishIoTask((IoTask)ioTask);
                        }
                    } else if (FileIoHelper.invokeFixedRangesUpdate(item, ioTask, dstChannel, fixedRangesToUpdate)) {
                        ioTask.setCountBytesDone(ioTask.getMarkedRangesSize());
                        this.finishIoTask((IoTask)ioTask);
                    }
                    break;
                }
                case DELETE: {
                    if (this.invokeDelete(ioTask)) {
                        this.finishIoTask((IoTask)ioTask);
                    }
                    break;
                }
                default: {
                    ioTask.setStatus(IoTask.Status.FAIL_UNKNOWN);
                    Loggers.ERR.fatal("Unknown load type \"{}\"", (Object)ioType);
                }
            }
        }
        catch (FileNotFoundException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)ioTask.toString(), (Object[])new Object[0]);
            ioTask.setStatus(IoTask.Status.RESP_FAIL_NOT_FOUND);
        }
        catch (AccessDeniedException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)ioTask.toString(), (Object[])new Object[0]);
            ioTask.setStatus(IoTask.Status.RESP_FAIL_AUTH);
        }
        catch (ClosedChannelException e) {
            ioTask.setStatus(IoTask.Status.INTERRUPTED);
        }
        catch (IOException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)ioTask.toString(), (Object[])new Object[0]);
            ioTask.setStatus(IoTask.Status.FAIL_IO);
        }
        catch (NullPointerException e) {
            if (!this.isClosed()) {
                e.printStackTrace(System.out);
                ioTask.setStatus(IoTask.Status.FAIL_UNKNOWN);
            } else {
                Loggers.ERR.debug("I/O task caused NPE while being interrupted: {}", ioTask);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            ioTask.setStatus(IoTask.Status.FAIL_UNKNOWN);
        }
        if (!IoTask.Status.ACTIVE.equals((Object)ioTask.getStatus())) {
            if (srcChannel != null) {
                this.srcOpenFiles.remove(ioTask);
                if (srcChannel.isOpen()) {
                    try {
                        srcChannel.close();
                    }
                    catch (IOException e) {
                        Loggers.ERR.warn("Failed to close the source I/O channel");
                    }
                }
            }
            if (dstChannel != null) {
                this.dstOpenFiles.remove(ioTask);
                if (dstChannel.isOpen()) {
                    try {
                        dstChannel.close();
                    }
                    catch (IOException e) {
                        Loggers.ERR.warn("Failed to close the destination I/O channel");
                    }
                }
            }
        }
    }

    private boolean invokeDelete(O ioTask) throws IOException {
        String dstPath = ioTask.getDstPath();
        Item fileItem = ioTask.getItem();
        FsConstants.FS_PROVIDER.delete(dstPath == null ? Paths.get(fileItem.getName(), new String[0]) : Paths.get(dstPath, fileItem.getName()));
        return true;
    }

    protected final void doClose() throws IOException {
        super.doClose();
        for (FileChannel srcChannel : this.srcOpenFiles.values()) {
            if (!srcChannel.isOpen()) continue;
            srcChannel.close();
        }
        this.srcOpenFiles.clear();
        for (FileChannel dstChannel : this.dstOpenFiles.values()) {
            if (!dstChannel.isOpen()) continue;
            dstChannel.close();
        }
        this.dstOpenFiles.clear();
    }

    public final String toString() {
        return String.format(super.toString(), "fs");
    }
}

