/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.fs;

import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.data.DataIoTask;
import com.emc.mongoose.api.model.item.DataItem;
import com.emc.mongoose.ui.log.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Level;

public interface FsConstants {
    public static final FileSystem FS = FileSystems.getDefault();
    public static final FileSystemProvider FS_PROVIDER = FS.provider();
    public static final Set<OpenOption> CREATE_OPEN_OPT = new HashSet<OpenOption>(){
        {
            this.add(StandardOpenOption.CREATE);
            this.add(StandardOpenOption.TRUNCATE_EXISTING);
            this.add(StandardOpenOption.WRITE);
        }
    };
    public static final Set<OpenOption> READ_OPEN_OPT = new HashSet<OpenOption>(){
        {
            this.add(StandardOpenOption.READ);
        }
    };
    public static final Set<OpenOption> WRITE_OPEN_OPT = new HashSet<OpenOption>(){
        {
            this.add(StandardOpenOption.WRITE);
        }
    };

    public static <I extends DataItem, O extends DataIoTask<I>> FileChannel openSrcFile(O ioTask) {
        String srcPath = ioTask.getSrcPath();
        if (srcPath == null || srcPath.isEmpty()) {
            return null;
        }
        if (srcPath.startsWith("/")) {
            srcPath = srcPath.substring(1);
        }
        String fileItemName = ioTask.getItem().getName();
        Path srcFilePath = srcPath.isEmpty() || fileItemName.startsWith(srcPath) ? FS.getPath(fileItemName, new String[0]) : FS.getPath(srcPath, fileItemName);
        try {
            return FS_PROVIDER.newFileChannel(srcFilePath, READ_OPEN_OPT, new FileAttribute[0]);
        }
        catch (IOException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to open the source channel for the path @ \"{}\"", (Object[])new Object[]{srcFilePath});
            ioTask.setStatus(IoTask.Status.FAIL_IO);
            return null;
        }
    }

    public static File createParentDir(String parentPath) {
        try {
            File parentDir = FS.getPath(parentPath, new String[0]).toFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            return parentDir;
        }
        catch (Exception e) {
            return null;
        }
    }
}

