/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.fs;

import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.storage.driver.fs.FsConstants;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public interface ListingHelper {
    public static final DirectoryStream.Filter<Path> ACCEPT_ALL_PATHS_FILTER = entry -> true;

    public static <I extends Item> List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count) throws IOException {
        PrefixDirectoryStreamFilter filter = prefix == null || prefix.isEmpty() ? ACCEPT_ALL_PATHS_FILTER : new PrefixDirectoryStreamFilter(prefix);
        ArrayList<Item> buff = new ArrayList<Item>(count);
        try (DirectoryStream<Path> dirStream = FsConstants.FS_PROVIDER.newDirectoryStream(Paths.get(path, new String[0]), filter);){
            boolean lastPrevItemNameFound;
            String lastPrevItemName;
            int prefixLength;
            int n = prefixLength = prefix == null || prefix.isEmpty() ? 0 : prefix.length();
            if (lastPrevItem == null) {
                lastPrevItemName = null;
                lastPrevItemNameFound = true;
            } else {
                lastPrevItemName = lastPrevItem.getName();
                lastPrevItemNameFound = false;
            }
            for (Path nextPath : dirStream) {
                File nextFile = new File(nextPath.toString());
                String nextFileName = nextFile.getName();
                if (lastPrevItemNameFound) {
                    Item nextItem;
                    try {
                        long offset = prefixLength > 0 ? Long.parseLong(nextFileName.substring(prefixLength), idRadix) : Long.parseLong(nextFileName, idRadix);
                        nextItem = itemFactory.getItem(nextFile.getAbsolutePath(), offset, nextFile.length());
                    }
                    catch (NumberFormatException e) {
                        nextItem = itemFactory.getItem(nextFile.getAbsolutePath(), 0L, nextFile.length());
                    }
                    buff.add(nextItem);
                    if (count != buff.size()) continue;
                    break;
                }
                lastPrevItemNameFound = nextFileName.equals(lastPrevItemName);
            }
        }
        catch (DirectoryIteratorException e) {
            throw e.getCause();
        }
        return buff;
    }

    public static final class PrefixDirectoryStreamFilter
    implements DirectoryStream.Filter<Path> {
        private final PathMatcher pathPrefixMatcher;

        public PrefixDirectoryStreamFilter(String prefix) {
            this.pathPrefixMatcher = FsConstants.FS.getPathMatcher("glob:" + prefix + "*");
        }

        @Override
        public final boolean accept(Path entry) throws IOException {
            return this.pathPrefixMatcher.matches(entry.getFileName());
        }
    }
}

