/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.hdfs;

import com.emc.mongoose.data.DataInput;
import com.emc.mongoose.env.ExtensionBase;
import com.emc.mongoose.exception.OmgShootMyFootException;
import com.emc.mongoose.item.Item;
import com.emc.mongoose.item.op.Operation;
import com.emc.mongoose.storage.driver.StorageDriverFactory;
import com.emc.mongoose.storage.driver.hdfs.HdfsStorageDriver;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.SchemaProvider;
import com.github.akurilov.confuse.io.json.JsonSchemaProviderBase;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class HdfsStorageDriverExtension<I extends Item, O extends Operation<I>, T extends HdfsStorageDriver<I, O>>
extends ExtensionBase
implements StorageDriverFactory<I, O, T> {
    private static final String NAME = "hdfs";
    private static final SchemaProvider SCHEMA_PROVIDER = new JsonSchemaProviderBase(){

        protected final InputStream schemaInputStream() {
            return ((Object)((Object)this)).getClass().getResourceAsStream("/config-schema-storage-net.json");
        }

        public final String id() {
            return "mongoose";
        }
    };
    private static final String DEFAULTS_FILE_NAME = "defaults-storage-net.json";
    private static final List<String> RES_INSTALL_FILES = Collections.unmodifiableList(Arrays.asList("config/defaults-storage-net.json"));

    public final String id() {
        return NAME;
    }

    protected final String defaultsFileName() {
        return DEFAULTS_FILE_NAME;
    }

    public final SchemaProvider schemaProvider() {
        return SCHEMA_PROVIDER;
    }

    protected final List<String> resourceFilesToInstall() {
        return RES_INSTALL_FILES;
    }

    public T create(String stepId, DataInput dataInput, Config storageConfig, boolean verifyFlag, int batchSize) throws OmgShootMyFootException, InterruptedException {
        return (T)((Object)new HdfsStorageDriver(NAME, stepId, dataInput, storageConfig, verifyFlag, batchSize));
    }
}

