/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdfs.DFSUtilClient;

public class SnapshotDiffReport {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private final String snapshotRoot;
    private final String fromSnapshot;
    private final String toSnapshot;
    private final List<DiffReportEntry> diffList;

    public SnapshotDiffReport(String snapshotRoot, String fromSnapshot, String toSnapshot, List<DiffReportEntry> entryList) {
        this.snapshotRoot = snapshotRoot;
        this.fromSnapshot = fromSnapshot;
        this.toSnapshot = toSnapshot;
        this.diffList = entryList != null ? entryList : Collections.emptyList();
    }

    public String getSnapshotRoot() {
        return this.snapshotRoot;
    }

    public String getFromSnapshot() {
        return this.fromSnapshot;
    }

    public String getLaterSnapshotName() {
        return this.toSnapshot;
    }

    public List<DiffReportEntry> getDiffList() {
        return this.diffList;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        String from = this.fromSnapshot == null || this.fromSnapshot.isEmpty() ? "current directory" : "snapshot " + this.fromSnapshot;
        String to = this.toSnapshot == null || this.toSnapshot.isEmpty() ? "current directory" : "snapshot " + this.toSnapshot;
        str.append("Difference between ").append(from).append(" and ").append(to).append(" under directory ").append(this.snapshotRoot).append(":").append(LINE_SEPARATOR);
        for (DiffReportEntry entry : this.diffList) {
            str.append(entry.toString()).append(LINE_SEPARATOR);
        }
        return str.toString();
    }

    public static class DiffReportEntry {
        private final DiffType type;
        private final byte[] sourcePath;
        private final byte[] targetPath;

        public DiffReportEntry(DiffType type, byte[] sourcePath) {
            this(type, sourcePath, null);
        }

        public DiffReportEntry(DiffType type, byte[][] sourcePathComponents) {
            this(type, sourcePathComponents, (byte[][])null);
        }

        public DiffReportEntry(DiffType type, byte[] sourcePath, byte[] targetPath) {
            this.type = type;
            this.sourcePath = sourcePath;
            this.targetPath = targetPath;
        }

        public DiffReportEntry(DiffType type, byte[][] sourcePathComponents, byte[][] targetPathComponents) {
            this.type = type;
            this.sourcePath = DFSUtilClient.byteArray2bytes(sourcePathComponents);
            this.targetPath = targetPathComponents == null ? null : DFSUtilClient.byteArray2bytes(targetPathComponents);
        }

        public String toString() {
            String str = this.type.getLabel() + "\t" + DiffReportEntry.getPathString(this.sourcePath);
            if (this.type == DiffType.RENAME) {
                str = str + " -> " + DiffReportEntry.getPathString(this.targetPath);
            }
            return str;
        }

        public DiffType getType() {
            return this.type;
        }

        static String getPathString(byte[] path) {
            String pathStr = DFSUtilClient.bytes2String(path);
            if (pathStr.isEmpty()) {
                return ".";
            }
            return "./" + pathStr;
        }

        public byte[] getSourcePath() {
            return this.sourcePath;
        }

        public byte[] getTargetPath() {
            return this.targetPath;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other != null && other instanceof DiffReportEntry) {
                DiffReportEntry entry = (DiffReportEntry)other;
                return this.type.equals((Object)entry.getType()) && Arrays.equals(this.sourcePath, entry.getSourcePath()) && Arrays.equals(this.targetPath, entry.getTargetPath());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.getSourcePath(), this.getTargetPath());
        }
    }

    public static enum DiffType {
        CREATE("+"),
        MODIFY("M"),
        DELETE("-"),
        RENAME("R");

        private final String label;

        private DiffType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static DiffType getTypeFromLabel(String label) {
            if (label.equals(CREATE.getLabel())) {
                return CREATE;
            }
            if (label.equals(MODIFY.getLabel())) {
                return MODIFY;
            }
            if (label.equals(DELETE.getLabel())) {
                return DELETE;
            }
            if (label.equals(RENAME.getLabel())) {
                return RENAME;
            }
            return null;
        }
    }
}

