/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.hdfs;

import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataCorruptionException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.data.DataSizeException;
import com.emc.mongoose.base.item.DataItem;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.PathItem;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.data.DataOperation;
import com.emc.mongoose.base.item.op.path.PathOperation;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.storage.Credential;
import com.emc.mongoose.storage.driver.coop.nio.NioStorageDriverBase;
import com.emc.mongoose.storage.driver.hdfs.ListHelper;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.io.util.BufferedWritableByteChannel;
import com.github.akurilov.commons.io.util.OutputStreamWrapperChannel;
import com.github.akurilov.commons.system.DirectMemUtil;
import com.github.akurilov.commons.system.SizeInBytes;
import com.github.akurilov.confuse.Config;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.logging.log4j.Level;

public class HdfsStorageDriver<I extends Item, O extends Operation<I>>
extends NioStorageDriverBase<I, O> {
    protected final String uriSchema;
    protected final Configuration hadoopConfig;
    protected final FsPermission defaultFsPerm;
    protected final String[] endpointAddrs;
    protected final int nodePort;
    private final AtomicInteger rrc = new AtomicInteger(0);
    private final ConcurrentMap<DataOperation<? extends DataItem>, FSDataInputStream> fileInputStreams = new ConcurrentHashMap<DataOperation<? extends DataItem>, FSDataInputStream>();
    private final ConcurrentMap<DataOperation<? extends DataItem>, FSDataOutputStream> fileOutputStreams = new ConcurrentHashMap<DataOperation<? extends DataItem>, FSDataOutputStream>();
    private final UserGroupInformation ugi;
    protected int inBuffSize = 4096;
    protected int outBuffSize = 0x1000000;

    public HdfsStorageDriver(String uriSchema, String testStepId, DataInput dataInput, Config storageConfig, boolean verifyFlag, int batchSize) throws IllegalConfigurationException {
        super(testStepId, dataInput, storageConfig, verifyFlag, batchSize);
        String uid;
        this.uriSchema = uriSchema;
        this.hadoopConfig = new Configuration();
        this.hadoopConfig.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.defaultFsPerm = FsPermission.getDefault().applyUMask(FsPermission.getUMask(this.hadoopConfig));
        String string = uid = this.credential == null ? null : this.credential.getUid();
        if (uid != null && !uid.isEmpty()) {
            this.ugi = UserGroupInformation.createRemoteUser(uid);
            UserGroupInformation.setLoginUser(this.ugi);
        } else {
            this.ugi = null;
        }
        Config nodeConfig = storageConfig.configVal("net-node");
        this.nodePort = storageConfig.intVal("net-node-port");
        List endpointAddrList = nodeConfig.listVal("addrs");
        this.endpointAddrs = endpointAddrList.toArray(new String[endpointAddrList.size()]);
        this.requestAuthTokenFunc = null;
        this.requestNewPathFunc = null;
    }

    protected final String getNextEndpointAddr() {
        return this.endpointAddrs[this.rrc.getAndIncrement() % this.endpointAddrs.length];
    }

    protected FileSystem getEndpoint(String nodeAddr) {
        try {
            int port;
            String addr;
            int portSepPos = nodeAddr.lastIndexOf(58);
            if (portSepPos > 0) {
                addr = nodeAddr.substring(0, portSepPos);
                port = Integer.parseInt(nodeAddr.substring(portSepPos + 1));
            } else {
                addr = nodeAddr;
                port = this.nodePort;
            }
            String uid = this.credential == null ? null : this.credential.getUid();
            URI endpointUri = new URI(this.uriSchema, uid, addr, port, "/", null, null);
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            FileSystem fileSystem = FileSystem.get(endpointUri, this.hadoopConfig);
            return fileSystem;
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
    }

    protected boolean prepare(O operation) {
        super.prepare(operation);
        String endpointAddr = operation.nodeAddr();
        if (endpointAddr == null) {
            endpointAddr = this.getNextEndpointAddr();
            operation.nodeAddr(endpointAddr);
        }
        return true;
    }

    protected static Path getFilePath(String basePath, String fileName) {
        if (basePath == null || basePath.isEmpty() || fileName.startsWith(basePath)) {
            return new Path(fileName);
        }
        return new Path(basePath, fileName);
    }

    protected FSDataOutputStream getCreateFileStream(DataOperation<? extends DataItem> createFileTask) {
        String dstPath = createFileTask.dstPath();
        DataItem fileItem = createFileTask.item();
        String fileName = fileItem.name();
        Path filePath = HdfsStorageDriver.getFilePath(dstPath, fileName);
        FileSystem endpoint = this.getEndpoint(createFileTask.nodeAddr());
        try {
            return endpoint.create(filePath, this.defaultFsPerm, false, this.outBuffSize, endpoint.getDefaultReplication(filePath), fileItem.size(), null);
        }
        catch (IOException e) {
            createFileTask.status(Operation.Status.FAIL_IO);
            throw new RuntimeException(e);
        }
    }

    protected FSDataInputStream getReadFileStream(DataOperation<? extends DataItem> readFileTask) {
        String srcPath = readFileTask.srcPath();
        if (srcPath == null || srcPath.isEmpty()) {
            return null;
        }
        DataItem fileItem = readFileTask.item();
        String fileName = fileItem.name();
        Path filePath = HdfsStorageDriver.getFilePath(srcPath, fileName);
        FileSystem endpoint = this.getEndpoint(readFileTask.nodeAddr());
        try {
            return endpoint.open(filePath, this.inBuffSize);
        }
        catch (IOException e) {
            readFileTask.status(Operation.Status.FAIL_IO);
            throw new RuntimeException(e);
        }
    }

    protected FSDataOutputStream getUpdateFileStream(DataOperation<? extends DataItem> updateFileTask) {
        String dstPath = updateFileTask.dstPath();
        DataItem fileItem = updateFileTask.item();
        String fileName = fileItem.name();
        Path filePath = HdfsStorageDriver.getFilePath(dstPath, fileName);
        FileSystem endpoint = this.getEndpoint(updateFileTask.nodeAddr());
        try {
            return endpoint.create(filePath, this.defaultFsPerm, true, this.outBuffSize, endpoint.getDefaultReplication(filePath), fileItem.size(), null);
        }
        catch (IOException e) {
            updateFileTask.status(Operation.Status.FAIL_IO);
            throw new RuntimeException(e);
        }
    }

    protected FSDataOutputStream getAppendFileStream(DataOperation<? extends DataItem> appendFileTask) {
        String dstPath = appendFileTask.dstPath();
        DataItem fileItem = appendFileTask.item();
        String fileName = fileItem.name();
        Path filePath = HdfsStorageDriver.getFilePath(dstPath, fileName);
        FileSystem endpoint = this.getEndpoint(appendFileTask.nodeAddr());
        try {
            return endpoint.append(filePath, this.outBuffSize);
        }
        catch (IOException e) {
            appendFileTask.status(Operation.Status.FAIL_IO);
            throw new RuntimeException(e);
        }
    }

    protected final void invokeNio(O operation) {
        if (operation instanceof DataOperation) {
            this.invokeFileNio((DataOperation<DataItem>)((DataOperation)operation));
        } else if (operation instanceof PathOperation) {
            this.invokeDirectoryNio((PathOperation<PathItem>)((PathOperation)operation));
        } else {
            throw new AssertionError((Object)"Not implemented");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeFileNio(DataOperation<? extends DataItem> fileOperation) {
        OpType opType = fileOperation.type();
        DataItem fileItem = fileOperation.item();
        FSDataInputStream input = null;
        FSDataOutputStream output = null;
        try {
            switch (opType) {
                case NOOP: {
                    this.finishOperation((Operation)fileOperation);
                    return;
                }
                case CREATE: {
                    List srcItems = fileOperation.srcItemsToConcat();
                    if (srcItems != null) {
                        throw new AssertionError((Object)"Files concatenation support is not implemented");
                    }
                    input = this.fileInputStreams.computeIfAbsent(fileOperation, this::getReadFileStream);
                    output = this.fileOutputStreams.computeIfAbsent(fileOperation, this::getCreateFileStream);
                    if (input != null) {
                        if (!this.invokeFileCopy(fileOperation, fileItem, input, output)) return;
                        this.finishOperation((Operation)fileOperation);
                        return;
                    } else {
                        if (!this.invokeFileCreate(fileOperation, fileItem, output)) return;
                        this.finishOperation((Operation)fileOperation);
                        return;
                    }
                }
                case READ: {
                    input = this.fileInputStreams.computeIfAbsent(fileOperation, this::getReadFileStream);
                    List fixedRangesToRead = fileOperation.fixedRanges();
                    if (this.verifyFlag) {
                        try {
                            if (fixedRangesToRead == null || fixedRangesToRead.isEmpty()) {
                                if (fileOperation.hasMarkedRanges()) {
                                    if (!this.invokeFileReadAndVerifyRandomRanges(fileOperation, fileItem, input, fileOperation.markedRangesMaskPair())) return;
                                    this.finishOperation((Operation)fileOperation);
                                    return;
                                } else {
                                    if (!this.invokeFileReadAndVerify(fileOperation, fileItem, input)) return;
                                    this.finishOperation((Operation)fileOperation);
                                    return;
                                }
                            } else {
                                if (!this.invokeFileReadAndVerifyFixedRanges(fileOperation, fileItem, input, fixedRangesToRead)) return;
                                this.finishOperation((Operation)fileOperation);
                                return;
                            }
                        }
                        catch (DataSizeException e) {
                            fileOperation.status(Operation.Status.RESP_FAIL_CORRUPT);
                            long countBytesDone = fileOperation.countBytesDone() + e.getOffset();
                            fileOperation.countBytesDone(countBytesDone);
                            try {
                                Loggers.MSG.debug("{}: content size mismatch, expected: {}, actual: {}", (Object)fileItem.name(), (Object)fileItem.size(), (Object)countBytesDone);
                                return;
                            }
                            catch (IOException iOException) {
                                return;
                            }
                        }
                        catch (DataCorruptionException e) {
                            fileOperation.status(Operation.Status.RESP_FAIL_CORRUPT);
                            long countBytesDone = fileOperation.countBytesDone() + e.getOffset();
                            fileOperation.countBytesDone(countBytesDone);
                            Loggers.MSG.debug("{}: content mismatch @ offset {}, expected: {}, actual: {} ", (Object)fileItem.name(), (Object)countBytesDone, (Object)String.format("\"0x%X\"", e.expected & 0xFF), (Object)String.format("\"0x%X\"", e.actual & 0xFF));
                            return;
                        }
                    }
                    if (fixedRangesToRead == null || fixedRangesToRead.isEmpty()) {
                        if (fileOperation.hasMarkedRanges()) {
                            if (!this.invokeFileReadRandomRanges(fileOperation, fileItem, input, fileOperation.markedRangesMaskPair())) return;
                            fileOperation.countBytesDone(fileOperation.markedRangesSize());
                            this.finishOperation((Operation)fileOperation);
                            return;
                        } else {
                            if (!this.invokeFileRead(fileOperation, fileItem, input)) return;
                            this.finishOperation((Operation)fileOperation);
                            return;
                        }
                    } else {
                        if (!this.invokeFileReadFixedRanges(fileOperation, fileItem, input, fixedRangesToRead)) return;
                        this.finishOperation((Operation)fileOperation);
                        return;
                    }
                }
                case UPDATE: {
                    List fixedRangesToUpdate = fileOperation.fixedRanges();
                    if (fixedRangesToUpdate == null || fixedRangesToUpdate.isEmpty()) {
                        if (fileOperation.hasMarkedRanges()) {
                            throw new AssertionError((Object)"Random byte ranges update isn't implemented");
                        }
                        output = this.fileOutputStreams.computeIfAbsent(fileOperation, this::getUpdateFileStream);
                        if (!this.invokeFileCreate(fileOperation, fileItem, output)) return;
                        this.finishOperation((Operation)fileOperation);
                        return;
                    } else {
                        if (fixedRangesToUpdate.size() != 1) throw new AssertionError((Object)"Multiple fixed byte ranges update isn't implemented");
                        Range range = (Range)fixedRangesToUpdate.get(0);
                        if (range.getBeg() == 0L && range.getEnd() == fileItem.size() - 1L) {
                            output = this.fileOutputStreams.computeIfAbsent(fileOperation, this::getUpdateFileStream);
                            if (!this.invokeFileCreate(fileOperation, fileItem, output)) return;
                            this.finishOperation((Operation)fileOperation);
                            return;
                        } else {
                            if (range.getSize() <= 0L) throw new AssertionError((Object)"Custom fixed byte ranges update isn't implemented");
                            output = this.fileOutputStreams.computeIfAbsent(fileOperation, this::getAppendFileStream);
                            if (!this.invokeFileAppend(fileOperation, fileItem, output, range)) return;
                            this.finishOperation((Operation)fileOperation);
                            return;
                        }
                    }
                }
                case DELETE: {
                    if (!this.invokeFileDelete(fileOperation)) return;
                    this.finishOperation((Operation)fileOperation);
                    return;
                }
                default: {
                    throw new AssertionError((Object)("\"" + opType + "\" operation isn't implemented"));
                }
            }
        }
        catch (IOException e) {
            LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"I/O failure, operation: {}, file: {}", (Object[])new Object[]{opType, fileItem.name()});
            this.finishOperation((Operation)fileOperation);
            fileOperation.status(Operation.Status.FAIL_IO);
            return;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            long countBytesDone = fileOperation.countBytesDone();
            if (cause instanceof AccessControlException) {
                LogUtil.exception((Level)Level.DEBUG, (Throwable)cause, (String)"Access to the file is forbidden: {}", (Object[])new Object[]{fileItem.name()});
                fileItem.size(countBytesDone);
                this.finishOperation((Operation)fileOperation);
                fileOperation.status(Operation.Status.RESP_FAIL_AUTH);
                return;
            } else if (cause instanceof IOException) {
                LogUtil.exception((Level)Level.DEBUG, (Throwable)cause, (String)"Failed open the file: {}", (Object[])new Object[]{fileItem.name()});
                fileItem.size(countBytesDone);
                this.finishOperation((Operation)fileOperation);
                fileOperation.status(Operation.Status.FAIL_IO);
                return;
            } else if (cause instanceof URISyntaxException) {
                LogUtil.exception((Level)Level.DEBUG, (Throwable)cause, (String)"Failed to calculate the HDFS service URI", (Object[])new Object[0]);
                fileItem.size(countBytesDone);
                this.finishOperation((Operation)fileOperation);
                fileOperation.status(Operation.Status.RESP_FAIL_CLIENT);
                return;
            } else if (cause != null) {
                LogUtil.exception((Level)Level.DEBUG, (Throwable)cause, (String)"Unexpected failure", (Object[])new Object[0]);
                fileItem.size(countBytesDone);
                this.finishOperation((Operation)fileOperation);
                fileOperation.status(Operation.Status.FAIL_UNKNOWN);
                return;
            } else {
                LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"Unexpected failure", (Object[])new Object[0]);
                fileItem.size(countBytesDone);
                this.finishOperation((Operation)fileOperation);
                fileOperation.status(Operation.Status.FAIL_UNKNOWN);
            }
            return;
        }
        finally {
            if (!Operation.Status.ACTIVE.equals((Object)fileOperation.status())) {
                if (input != null) {
                    this.fileInputStreams.remove(fileOperation);
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        Loggers.ERR.warn("Failed to close the source I/O channel");
                    }
                }
                if (output != null) {
                    this.fileOutputStreams.remove(fileOperation);
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        Loggers.ERR.warn("Failed to close the destination I/O channel");
                    }
                }
            }
        }
    }

    private void invokeDirectoryNio(PathOperation<? extends PathItem> diroperation) {
        throw new AssertionError((Object)"Not implemented yet");
    }

    protected String requestNewPath(String path) {
        throw new AssertionError((Object)"Should not be invoked");
    }

    protected String requestNewAuthToken(Credential credential) {
        throw new AssertionError((Object)"Should not be invoked");
    }

    protected boolean invokeFileCreate(DataOperation<? extends DataItem> fileOperation, DataItem fileItem, FSDataOutputStream outputStream) throws IOException {
        long fileSize;
        try {
            fileSize = fileItem.size();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        long countBytesDone = fileOperation.countBytesDone();
        long remainingBytes = fileSize - countBytesDone;
        if (remainingBytes > 0L) {
            BufferedWritableByteChannel outputChan = OutputStreamWrapperChannel.getThreadLocalInstance((OutputStream)outputStream, (long)remainingBytes);
            outputStream.hflush();
            fileOperation.countBytesDone(countBytesDone += fileItem.writeToSocketChannel((WritableByteChannel)outputChan, remainingBytes));
        }
        return remainingBytes <= 0L;
    }

    protected boolean invokeFileCopy(DataOperation<? extends DataItem> fileOperation, DataItem fileItem, FSDataInputStream inputStream, FSDataOutputStream outputStream) throws IOException {
        long fileSize;
        long countBytesDone = fileOperation.countBytesDone();
        try {
            fileSize = fileItem.size();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        long remainingSize = fileSize - countBytesDone;
        if (remainingSize > 0L && Operation.Status.ACTIVE.equals((Object)fileOperation.status())) {
            byte[] buff = new byte[remainingSize > 0x1000000L ? 0x1000000 : (int)remainingSize];
            int n = inputStream.read(buff, 0, buff.length);
            outputStream.write(buff, 0, n);
            outputStream.hflush();
            fileOperation.countBytesDone(countBytesDone += (long)n);
        }
        return countBytesDone >= fileSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean invokeFileReadAndVerify(DataOperation<? extends DataItem> operation, DataItem fileItem, FSDataInputStream inputStream) throws DataSizeException, DataCorruptionException, IOException {
        long contentSize;
        long countBytesDone = operation.countBytesDone();
        if (countBytesDone < (contentSize = fileItem.size())) {
            if (fileItem.isUpdated()) {
                DataItem currRange = operation.currRange();
                int nextRangeIdx = operation.currRangeIdx() + 1;
                long nextRangeOffset = DataItem.rangeOffset((int)nextRangeIdx);
                if (currRange == null) throw new AssertionError((Object)"Null data range");
                MappedByteBuffer inBuff = DirectMemUtil.getThreadLocalReusableBuff((long)(nextRangeOffset - countBytesDone));
                int n = inputStream.read(inBuff);
                if (n < 0) {
                    throw new DataSizeException(contentSize, countBytesDone);
                }
                ((ByteBuffer)inBuff).flip();
                currRange.verify((ByteBuffer)inBuff);
                currRange.position(currRange.position() + (long)n);
                if ((countBytesDone += (long)n) == nextRangeOffset) {
                    operation.currRangeIdx(nextRangeIdx);
                }
            } else {
                MappedByteBuffer inBuff = DirectMemUtil.getThreadLocalReusableBuff((long)(contentSize - countBytesDone));
                int n = inputStream.read(inBuff);
                if (n < 0) {
                    throw new DataSizeException(contentSize, countBytesDone);
                }
                ((ByteBuffer)inBuff).flip();
                fileItem.verify((ByteBuffer)inBuff);
                fileItem.position(fileItem.position() + (long)n);
                countBytesDone += (long)n;
            }
            operation.countBytesDone(countBytesDone);
        }
        if (countBytesDone < contentSize) return false;
        return true;
    }

    protected boolean invokeFileReadAndVerifyRandomRanges(DataOperation<? extends DataItem> operation, DataItem fileItem, FSDataInputStream inputStream, BitSet[] maskRangesPair) throws DataSizeException, DataCorruptionException, IOException {
        long countBytesDone = operation.countBytesDone();
        long rangesSizeSum = operation.markedRangesSize();
        if (rangesSizeSum > 0L && rangesSizeSum > countBytesDone) {
            DataItem range2read;
            int currRangeIdx;
            block10: {
                while ((currRangeIdx = operation.currRangeIdx()) < DataItem.rangeCount((long)fileItem.size())) {
                    if (maskRangesPair[0].get(currRangeIdx) || maskRangesPair[1].get(currRangeIdx)) {
                        range2read = operation.currRange();
                        if (Loggers.MSG.isTraceEnabled()) {
                            Loggers.MSG.trace("I/O task: {}, Range index: {}, size: {}, internal position: {}, Done byte count: {}", (Object)operation.toString(), (Object)currRangeIdx, (Object)range2read.size(), (Object)range2read.position(), (Object)countBytesDone);
                        }
                        break block10;
                    }
                    operation.currRangeIdx(++currRangeIdx);
                }
                operation.countBytesDone(rangesSizeSum);
                return true;
            }
            long currRangeSize = range2read.size();
            long currPos = DataItem.rangeOffset((int)currRangeIdx) + countBytesDone;
            inputStream.seek(currPos);
            MappedByteBuffer inBuff = DirectMemUtil.getThreadLocalReusableBuff((long)(currRangeSize - countBytesDone));
            int n = inputStream.read(inBuff);
            if (n < 0) {
                throw new DataSizeException(rangesSizeSum, countBytesDone);
            }
            ((ByteBuffer)inBuff).flip();
            try {
                range2read.verify((ByteBuffer)inBuff);
                range2read.position(range2read.position() + (long)n);
                countBytesDone += (long)n;
            }
            catch (DataCorruptionException e) {
                throw new DataCorruptionException(currPos + e.getOffset() - countBytesDone, e.expected, e.actual);
            }
            if (Loggers.MSG.isTraceEnabled()) {
                Loggers.MSG.trace("I/O task: {}, Done bytes count: {}, Curr range size: {}", (Object)operation.toString(), (Object)countBytesDone, (Object)range2read.size());
            }
            if (countBytesDone == currRangeSize) {
                operation.currRangeIdx(currRangeIdx + 1);
                operation.countBytesDone(0L);
            } else {
                operation.countBytesDone(countBytesDone);
            }
        }
        return rangesSizeSum <= 0L || rangesSizeSum <= countBytesDone;
    }

    protected boolean invokeFileReadAndVerifyFixedRanges(DataOperation<? extends DataItem> operation, DataItem fileItem, FSDataInputStream inputStream, List<Range> fixedRanges) throws DataSizeException, DataCorruptionException, IOException {
        long countBytesDone;
        long baseItemSize = fileItem.size();
        long fixedRangesSizeSum = operation.markedRangesSize();
        long rangeBytesDone = countBytesDone = operation.countBytesDone();
        if (fixedRangesSizeSum > 0L && fixedRangesSizeSum > countBytesDone) {
            int currFixedRangeIdx = operation.currRangeIdx();
            if (currFixedRangeIdx < fixedRanges.size()) {
                long fixedRangeSize;
                Range fixedRange = fixedRanges.get(currFixedRangeIdx);
                long currOffset = fixedRange.getBeg();
                long fixedRangeEnd = fixedRange.getEnd();
                if (currOffset == -1L) {
                    currOffset = baseItemSize - fixedRangeEnd;
                    fixedRangeSize = fixedRangeEnd;
                } else {
                    fixedRangeSize = fixedRangeEnd == -1L ? baseItemSize - currOffset : fixedRangeEnd - currOffset + 1L;
                }
                int n = DataItem.rangeCount((long)((currOffset += rangeBytesDone) + 1L)) - 1;
                long cellOffset = DataItem.rangeOffset((int)n);
                long cellEnd = Math.min(baseItemSize, DataItem.rangeOffset((int)(n + 1)));
                DataItem currRange = fileItem.slice(cellOffset, cellEnd - cellOffset);
                if (fileItem.isRangeUpdated(n)) {
                    currRange.layer(fileItem.layer() + 1);
                }
                currRange.position(currOffset - cellOffset);
                inputStream.seek(currOffset);
                MappedByteBuffer inBuff = DirectMemUtil.getThreadLocalReusableBuff((long)Math.min(fixedRangeSize - countBytesDone, currRange.size() - currRange.position()));
                int m = inputStream.read(inBuff);
                if (m < 0) {
                    throw new DataSizeException(fixedRangesSizeSum, countBytesDone);
                }
                ((ByteBuffer)inBuff).flip();
                try {
                    currRange.verify((ByteBuffer)inBuff);
                    currRange.position(currRange.position() + (long)m);
                }
                catch (DataCorruptionException e) {
                    throw new DataCorruptionException(currOffset + e.getOffset() - countBytesDone, e.expected, e.actual);
                }
                if ((rangeBytesDone += (long)m) == fixedRangeSize) {
                    if (currFixedRangeIdx == fixedRanges.size() - 1) {
                        operation.countBytesDone(fixedRangesSizeSum);
                        return true;
                    }
                    operation.currRangeIdx(currFixedRangeIdx + 1);
                    rangeBytesDone = 0L;
                }
                operation.countBytesDone(rangeBytesDone);
            } else {
                operation.countBytesDone(fixedRangesSizeSum);
            }
        }
        return fixedRangesSizeSum <= 0L || fixedRangesSizeSum <= countBytesDone;
    }

    protected boolean invokeFileRead(DataOperation<? extends DataItem> operation, DataItem fileItem, FSDataInputStream inputStream) throws IOException {
        long contentSize;
        long countBytesDone = operation.countBytesDone();
        if (countBytesDone < (contentSize = fileItem.size())) {
            int n = inputStream.read(DirectMemUtil.getThreadLocalReusableBuff((long)(contentSize - countBytesDone)));
            if (n < 0) {
                operation.countBytesDone(countBytesDone);
                fileItem.size(countBytesDone);
                return true;
            }
            operation.countBytesDone(countBytesDone += (long)n);
        }
        return countBytesDone >= contentSize;
    }

    protected boolean invokeFileReadRandomRanges(DataOperation<? extends DataItem> operation, DataItem fileItem, FSDataInputStream inputStream, BitSet[] maskRangesPair) throws IOException {
        long countBytesDone = operation.countBytesDone();
        long rangesSizeSum = operation.markedRangesSize();
        if (rangesSizeSum > 0L && rangesSizeSum > countBytesDone) {
            int currRangeIdx;
            block6: {
                while ((currRangeIdx = operation.currRangeIdx()) < DataItem.rangeCount((long)fileItem.size())) {
                    if (!maskRangesPair[0].get(currRangeIdx) && !maskRangesPair[1].get(currRangeIdx)) {
                        operation.currRangeIdx(++currRangeIdx);
                        continue;
                    }
                    break block6;
                }
                operation.countBytesDone(rangesSizeSum);
                return true;
            }
            DataItem range2read = operation.currRange();
            long currRangeSize = range2read.size();
            inputStream.seek(DataItem.rangeOffset((int)currRangeIdx) + countBytesDone);
            int n = inputStream.read(DirectMemUtil.getThreadLocalReusableBuff((long)(currRangeSize - countBytesDone)));
            if (n < 0) {
                operation.countBytesDone(countBytesDone);
                return true;
            }
            if ((countBytesDone += (long)n) == currRangeSize) {
                operation.currRangeIdx(currRangeIdx + 1);
                operation.countBytesDone(0L);
            } else {
                operation.countBytesDone(countBytesDone);
            }
        }
        return rangesSizeSum <= 0L || rangesSizeSum <= countBytesDone;
    }

    protected boolean invokeFileReadFixedRanges(DataOperation<? extends DataItem> operation, DataItem fileItem, FSDataInputStream inputStream, List<Range> byteRanges) throws IOException {
        long countBytesDone = operation.countBytesDone();
        long baseItemSize = fileItem.size();
        long rangesSizeSum = operation.markedRangesSize();
        if (rangesSizeSum > 0L && rangesSizeSum > countBytesDone) {
            int currRangeIdx = operation.currRangeIdx();
            if (currRangeIdx < byteRanges.size()) {
                long rangeSize;
                Range byteRange = byteRanges.get(currRangeIdx);
                long rangeBeg = byteRange.getBeg();
                long rangeEnd = byteRange.getEnd();
                if (rangeBeg == -1L) {
                    rangeBeg = baseItemSize - rangeEnd;
                    rangeSize = rangeEnd;
                } else {
                    rangeSize = rangeEnd == -1L ? baseItemSize - rangeBeg : rangeEnd - rangeBeg + 1L;
                }
                inputStream.seek(rangeBeg + countBytesDone);
                int n = inputStream.read(DirectMemUtil.getThreadLocalReusableBuff((long)(rangeSize - countBytesDone)));
                if (n < 0) {
                    operation.countBytesDone(countBytesDone);
                    return true;
                }
                if ((countBytesDone += (long)n) == rangeSize) {
                    operation.currRangeIdx(currRangeIdx + 1);
                    operation.countBytesDone(0L);
                } else {
                    operation.countBytesDone(countBytesDone);
                }
            } else {
                operation.countBytesDone(rangesSizeSum);
            }
        }
        return rangesSizeSum <= 0L || rangesSizeSum <= countBytesDone;
    }

    protected boolean invokeFileAppend(DataOperation<? extends DataItem> operation, DataItem fileItem, FSDataOutputStream outputStream, Range appendRange) throws IOException {
        long countBytesDone = operation.countBytesDone();
        long appendSize = appendRange.getSize();
        long remainingSize = appendSize - countBytesDone;
        if (remainingSize > 0L) {
            BufferedWritableByteChannel outputChan = OutputStreamWrapperChannel.getThreadLocalInstance((OutputStream)outputStream, (long)remainingSize);
            long n = fileItem.writeToSocketChannel((WritableByteChannel)outputChan, remainingSize);
            outputStream.hflush();
            operation.countBytesDone(countBytesDone + n);
            fileItem.size(fileItem.size() + n);
        }
        return remainingSize <= 0L;
    }

    protected boolean invokeFileDelete(DataOperation<? extends DataItem> fileOperation) throws IOException {
        String dstPath = fileOperation.dstPath();
        DataItem fileItem = fileOperation.item();
        String itemName = fileItem.name();
        Path filePath = HdfsStorageDriver.getFilePath(dstPath, itemName);
        FileSystem endpoint = this.getEndpoint(this.getNextEndpointAddr());
        if (!endpoint.delete(filePath, false)) {
            Loggers.ERR.debug("Failed to delete the file {} @ {}", (Object)filePath, (Object)endpoint.getCanonicalServiceName());
            fileOperation.startResponse();
            fileOperation.finishResponse();
            fileOperation.status(Operation.Status.RESP_FAIL_UNKNOWN);
        }
        return true;
    }

    public List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count) throws IOException {
        return ListHelper.list(itemFactory, path, prefix, idRadix, lastPrevItem, count, this.getEndpoint(this.endpointAddrs[0]));
    }

    public void adjustIoBuffers(long avgTransferSize, OpType opType) {
        int size = avgTransferSize < 4096L ? 4096 : (0x1000000L < avgTransferSize ? 0x1000000 : (int)avgTransferSize);
        if (OpType.CREATE.equals((Object)opType)) {
            Loggers.MSG.info("Adjust output buffer size: {}", (Object)SizeInBytes.formatFixedSize((long)size));
            this.outBuffSize = size;
        } else if (OpType.READ.equals((Object)opType)) {
            Loggers.MSG.info("Adjust input buffer size: {}", (Object)SizeInBytes.formatFixedSize((long)size));
            this.inBuffSize = size;
        }
    }

    protected void doClose() throws IOException {
        super.doClose();
        this.hadoopConfig.clear();
        for (FSDataInputStream input : this.fileInputStreams.values()) {
            input.close();
        }
        this.fileInputStreams.clear();
        for (FSDataOutputStream output : this.fileOutputStreams.values()) {
            output.close();
        }
        this.fileOutputStreams.clear();
        for (int i = 0; i < this.endpointAddrs.length; ++i) {
            this.endpointAddrs[i] = null;
        }
        if (this.ugi != null) {
            FileSystem.closeAllForUGI(this.ugi);
        } else {
            FileSystem.closeAll();
        }
    }

    public String toString() {
        return String.format(super.toString(), "hdfs");
    }
}

