/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.hdfs;

import com.emc.mongoose.base.item.DataItemFactory;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public interface ListHelper {
    public static <I extends Item> List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count, FileSystem endpoint) throws IOException {
        boolean lastPrevItemNameFound;
        String lastPrevItemName;
        int prefixLen;
        RemoteIterator<LocatedFileStatus> it = endpoint.listFiles(new Path(path), false);
        ArrayList<Item> items = new ArrayList<Item>(count);
        int n = prefixLen = prefix == null ? 0 : prefix.length();
        if (lastPrevItem == null) {
            lastPrevItemName = null;
            lastPrevItemNameFound = true;
        } else {
            lastPrevItemName = lastPrevItem.name();
            lastPrevItemNameFound = false;
        }
        long listedCount = 0L;
        while (it.hasNext() && listedCount < (long)count) {
            long nextId;
            LocatedFileStatus lfs = it.next();
            if (itemFactory instanceof DataItemFactory ? lfs.isDirectory() : !lfs.isDirectory()) continue;
            Path nextPath = lfs.getPath();
            String nextPathStr = nextPath.toUri().getPath();
            String nextName = nextPath.getName();
            if (!lastPrevItemNameFound) {
                lastPrevItemNameFound = nextPathStr.equals(lastPrevItemName);
                continue;
            }
            try {
                if (prefixLen > 0) {
                    if (!nextName.startsWith(prefix)) continue;
                    nextId = Long.parseLong(nextName.substring(prefixLen), idRadix);
                } else {
                    nextId = Long.parseLong(nextName, idRadix);
                }
            }
            catch (NumberFormatException e) {
                nextId = 0L;
            }
            long nextSize = lfs.getLen();
            Item nextFile = itemFactory.getItem(nextPathStr, nextId, nextSize);
            items.add(nextFile);
            ++listedCount;
        }
        return items;
    }
}

