/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class DiskBalancerWorkItem {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectReader READER = new ObjectMapper().readerFor(DiskBalancerWorkItem.class);
    private long startTime;
    private long secondsElapsed;
    private long bytesToCopy;
    private long bytesCopied;
    private long errorCount;
    private String errMsg;
    private long blocksCopied;
    private long maxDiskErrors;
    private long tolerancePercent;
    private long bandwidth;

    public DiskBalancerWorkItem() {
    }

    public DiskBalancerWorkItem(long bytesToCopy, long bytesCopied) {
        this.bytesToCopy = bytesToCopy;
        this.bytesCopied = bytesCopied;
    }

    public static DiskBalancerWorkItem parseJson(String json) throws IOException {
        Preconditions.checkNotNull(json);
        return (DiskBalancerWorkItem)READER.readValue(json);
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public void incErrorCount() {
        ++this.errorCount;
    }

    public long getBytesCopied() {
        return this.bytesCopied;
    }

    public void setBytesCopied(long bytesCopied) {
        this.bytesCopied = bytesCopied;
    }

    public void incCopiedSoFar(long delta) {
        this.bytesCopied += delta;
    }

    public long getBytesToCopy() {
        return this.bytesToCopy;
    }

    public long getBlocksCopied() {
        return this.blocksCopied;
    }

    public void incBlocksCopied() {
        ++this.blocksCopied;
    }

    public String toJson() throws IOException {
        return MAPPER.writeValueAsString((Object)this);
    }

    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    public void setBlocksCopied(long blocksCopied) {
        this.blocksCopied = blocksCopied;
    }

    public long getMaxDiskErrors() {
        return this.maxDiskErrors;
    }

    public void setMaxDiskErrors(long maxDiskErrors) {
        this.maxDiskErrors = maxDiskErrors;
    }

    public long getTolerancePercent() {
        return this.tolerancePercent;
    }

    public void setTolerancePercent(long tolerancePercent) {
        this.tolerancePercent = tolerancePercent;
    }

    public long getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getSecondsElapsed() {
        return this.secondsElapsed;
    }

    public void setSecondsElapsed(long secondsElapsed) {
        this.secondsElapsed = secondsElapsed;
    }
}

