/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.kafka;

import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.data.DataOperation;
import com.emc.mongoose.base.item.op.path.PathOperation;
import com.emc.mongoose.base.storage.Credential;
import com.emc.mongoose.storage.driver.coop.CoopStorageDriverBase;
import com.github.akurilov.confuse.Config;
import java.io.IOException;
import java.util.List;

public class KafkaStorageDriver<I extends Item, O extends Operation<I>>
extends CoopStorageDriverBase<I, O> {
    public KafkaStorageDriver(String testStepId, DataInput dataInput, Config storageConfig, boolean verifyFlag, int batchSize) throws IllegalConfigurationException {
        super(testStepId, dataInput, storageConfig, verifyFlag, batchSize);
    }

    protected final boolean submit(O op) throws IllegalStateException {
        if (this.concurrencyThrottle.tryAcquire()) {
            OpType opType = op.type();
            if (op instanceof DataOperation) {
                this.submitRecordOperation((DataOperation)op, opType);
            } else if (op instanceof PathOperation) {
                this.submitTopicOperation((PathOperation)op, opType);
            } else {
                throw new AssertionError((Object)"storage driver doesn't support the token operations");
            }
        }
        return true;
    }

    private void submitRecordOperation(DataOperation op, OpType opType) {
        switch (opType) {
            case CREATE: {
                this.submitRecordCreateOperation();
                break;
            }
            case READ: {
                this.submitRecordReadOperation();
                break;
            }
            case UPDATE: {
                throw new AssertionError((Object)"Not implemented");
            }
            case DELETE: {
                this.submitRecordDeleteOperation();
                break;
            }
            case LIST: {
                throw new AssertionError((Object)"Not implemented");
            }
            default: {
                throw new AssertionError((Object)"Not implemented");
            }
        }
    }

    private void submitRecordDeleteOperation() {
    }

    private void submitRecordReadOperation() {
    }

    private void submitRecordCreateOperation() {
    }

    private void submitTopicOperation(PathOperation op, OpType opType) {
        switch (opType) {
            case CREATE: {
                this.submitTopicCreateOperation();
                break;
            }
            case READ: {
                this.submitTopicReadOperation();
                break;
            }
            case UPDATE: {
                throw new AssertionError((Object)"Not implemented");
            }
            case DELETE: {
                this.submitTopicDeleteOperation();
                break;
            }
            case LIST: {
                this.submitTopicDeleteOperation();
            }
            default: {
                throw new AssertionError((Object)"Not implemented");
            }
        }
    }

    private void submitTopicCreateOperation() {
    }

    private void submitTopicReadOperation() {
    }

    private void submitTopicDeleteOperation() {
    }

    protected final int submit(List<O> ops, int from, int to) throws IllegalStateException {
        for (int i = from; i < to; ++i) {
            if (this.submit((Operation)ops.get(i))) continue;
            return i - from;
        }
        return to - from;
    }

    protected final int submit(List<O> ops) throws IllegalStateException {
        int opsCount = ops.size();
        for (int i = 0; i < opsCount; ++i) {
            if (this.submit((Operation)ops.get(i))) continue;
            return i;
        }
        return opsCount;
    }

    protected String requestNewPath(String path) {
        throw new AssertionError((Object)"Should not be invoked");
    }

    protected String requestNewAuthToken(Credential credential) {
        throw new AssertionError((Object)"Should not be invoked");
    }

    public List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count) throws IOException {
        return null;
    }

    public void adjustIoBuffers(long avgTransferSize, OpType opType) {
    }
}

