/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metadata
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Metadata.class);
    public static final long TOPIC_EXPIRY_MS = 300000L;
    private static final long TOPIC_EXPIRY_NEEDS_UPDATE = -1L;
    private final long refreshBackoffMs;
    private final long metadataExpireMs;
    private int version;
    private long lastRefreshMs;
    private long lastSuccessfulRefreshMs;
    private AuthenticationException authenticationException;
    private Cluster cluster;
    private boolean needUpdate;
    private final Map<String, Long> topics;
    private final List<Listener> listeners;
    private final ClusterResourceListeners clusterResourceListeners;
    private boolean needMetadataForAllTopics;
    private final boolean allowAutoTopicCreation;
    private final boolean topicExpiryEnabled;
    private boolean isClosed;

    public Metadata(long refreshBackoffMs, long metadataExpireMs, boolean allowAutoTopicCreation) {
        this(refreshBackoffMs, metadataExpireMs, allowAutoTopicCreation, false, new ClusterResourceListeners());
    }

    public Metadata(long refreshBackoffMs, long metadataExpireMs, boolean allowAutoTopicCreation, boolean topicExpiryEnabled, ClusterResourceListeners clusterResourceListeners) {
        this.refreshBackoffMs = refreshBackoffMs;
        this.metadataExpireMs = metadataExpireMs;
        this.allowAutoTopicCreation = allowAutoTopicCreation;
        this.topicExpiryEnabled = topicExpiryEnabled;
        this.lastRefreshMs = 0L;
        this.lastSuccessfulRefreshMs = 0L;
        this.version = 0;
        this.cluster = Cluster.empty();
        this.needUpdate = false;
        this.topics = new HashMap<String, Long>();
        this.listeners = new ArrayList<Listener>();
        this.clusterResourceListeners = clusterResourceListeners;
        this.needMetadataForAllTopics = false;
        this.isClosed = false;
    }

    public synchronized Cluster fetch() {
        return this.cluster;
    }

    public synchronized void add(String topic) {
        Objects.requireNonNull(topic, "topic cannot be null");
        if (this.topics.put(topic, -1L) == null) {
            this.requestUpdateForNewTopics();
        }
    }

    public synchronized long timeToAllowUpdate(long nowMs) {
        return Math.max(this.lastRefreshMs + this.refreshBackoffMs - nowMs, 0L);
    }

    public synchronized long timeToNextUpdate(long nowMs) {
        long timeToExpire = this.needUpdate ? 0L : Math.max(this.lastSuccessfulRefreshMs + this.metadataExpireMs - nowMs, 0L);
        return Math.max(timeToExpire, this.timeToAllowUpdate(nowMs));
    }

    public synchronized int requestUpdate() {
        this.needUpdate = true;
        return this.version;
    }

    public synchronized boolean updateRequested() {
        return this.needUpdate;
    }

    public synchronized AuthenticationException getAndClearAuthenticationException() {
        if (this.authenticationException != null) {
            AuthenticationException exception = this.authenticationException;
            this.authenticationException = null;
            return exception;
        }
        return null;
    }

    public synchronized void awaitUpdate(int lastVersion, long maxWaitMs) throws InterruptedException {
        if (maxWaitMs < 0L) {
            throw new IllegalArgumentException("Max time to wait for metadata updates should not be < 0 milliseconds");
        }
        long begin = System.currentTimeMillis();
        long remainingWaitMs = maxWaitMs;
        while (this.version <= lastVersion && !this.isClosed()) {
            long elapsed;
            AuthenticationException ex = this.getAndClearAuthenticationException();
            if (ex != null) {
                throw ex;
            }
            if (remainingWaitMs != 0L) {
                this.wait(remainingWaitMs);
            }
            if ((elapsed = System.currentTimeMillis() - begin) >= maxWaitMs) {
                throw new TimeoutException("Failed to update metadata after " + maxWaitMs + " ms.");
            }
            remainingWaitMs = maxWaitMs - elapsed;
        }
        if (this.isClosed()) {
            throw new KafkaException("Requested metadata update after close");
        }
    }

    public synchronized void setTopics(Collection<String> topics) {
        if (!this.topics.keySet().containsAll(topics)) {
            this.requestUpdateForNewTopics();
        }
        this.topics.clear();
        for (String topic : topics) {
            this.topics.put(topic, -1L);
        }
    }

    public synchronized Set<String> topics() {
        return new HashSet<String>(this.topics.keySet());
    }

    public synchronized boolean containsTopic(String topic) {
        return this.topics.containsKey(topic);
    }

    public synchronized void update(Cluster newCluster, Set<String> unavailableTopics, long now) {
        Objects.requireNonNull(newCluster, "cluster should not be null");
        if (this.isClosed()) {
            throw new IllegalStateException("Update requested after metadata close");
        }
        this.needUpdate = false;
        this.lastRefreshMs = now;
        this.lastSuccessfulRefreshMs = now;
        ++this.version;
        if (this.topicExpiryEnabled) {
            Iterator<Object> it = this.topics.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                long expireMs = (Long)entry.getValue();
                if (expireMs == -1L) {
                    entry.setValue(now + 300000L);
                    continue;
                }
                if (expireMs > now) continue;
                it.remove();
                log.debug("Removing unused topic {} from the metadata list, expiryMs {} now {}", entry.getKey(), expireMs, now);
            }
        }
        for (Listener listener : this.listeners) {
            listener.onMetadataUpdate(newCluster, unavailableTopics);
        }
        String previousClusterId = this.cluster.clusterResource().clusterId();
        if (this.needMetadataForAllTopics) {
            this.needUpdate = false;
            this.cluster = this.getClusterForCurrentTopics(newCluster);
        } else {
            this.cluster = newCluster;
        }
        if (!newCluster.isBootstrapConfigured()) {
            String newClusterId = newCluster.clusterResource().clusterId();
            if (newClusterId == null ? previousClusterId != null : !newClusterId.equals(previousClusterId)) {
                log.info("Cluster ID: {}", (Object)newClusterId);
            }
            this.clusterResourceListeners.onUpdate(newCluster.clusterResource());
        }
        this.notifyAll();
        log.debug("Updated cluster metadata version {} to {}", (Object)this.version, (Object)this.cluster);
    }

    public synchronized void failedUpdate(long now, AuthenticationException authenticationException) {
        this.lastRefreshMs = now;
        this.authenticationException = authenticationException;
        if (authenticationException != null) {
            this.notifyAll();
        }
    }

    public synchronized int version() {
        return this.version;
    }

    public synchronized long lastSuccessfulUpdate() {
        return this.lastSuccessfulRefreshMs;
    }

    public boolean allowAutoTopicCreation() {
        return this.allowAutoTopicCreation;
    }

    public synchronized void needMetadataForAllTopics(boolean needMetadataForAllTopics) {
        if (needMetadataForAllTopics && !this.needMetadataForAllTopics) {
            this.requestUpdateForNewTopics();
        }
        this.needMetadataForAllTopics = needMetadataForAllTopics;
    }

    public synchronized boolean needMetadataForAllTopics() {
        return this.needMetadataForAllTopics;
    }

    public synchronized void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void close() {
        this.isClosed = true;
        this.notifyAll();
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    private synchronized void requestUpdateForNewTopics() {
        this.lastRefreshMs = 0L;
        this.requestUpdate();
    }

    private Cluster getClusterForCurrentTopics(Cluster cluster) {
        HashSet<String> unauthorizedTopics = new HashSet<String>();
        HashSet<String> invalidTopics = new HashSet<String>();
        ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>();
        List<Node> nodes = Collections.emptyList();
        Set<String> internalTopics = Collections.emptySet();
        Node controller = null;
        String clusterId = null;
        if (cluster != null) {
            clusterId = cluster.clusterResource().clusterId();
            internalTopics = cluster.internalTopics();
            unauthorizedTopics.addAll(cluster.unauthorizedTopics());
            unauthorizedTopics.retainAll(this.topics.keySet());
            invalidTopics.addAll(cluster.invalidTopics());
            invalidTopics.addAll(this.cluster.invalidTopics());
            for (String topic : this.topics.keySet()) {
                List<PartitionInfo> partitionInfoList = cluster.partitionsForTopic(topic);
                if (partitionInfoList.isEmpty()) continue;
                partitionInfos.addAll(partitionInfoList);
            }
            nodes = cluster.nodes();
            controller = cluster.controller();
        }
        return new Cluster(clusterId, nodes, partitionInfos, unauthorizedTopics, invalidTopics, internalTopics, controller);
    }

    public static interface Listener {
        public void onMetadataUpdate(Cluster var1, Set<String> var2);
    }
}

