/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class AdminMetadataManager {
    private Logger log;
    private final long refreshBackoffMs;
    private final long metadataExpireMs;
    private final AdminMetadataUpdater updater;
    private State state = State.QUIESCENT;
    private long lastMetadataUpdateMs = 0L;
    private long lastMetadataFetchAttemptMs = 0L;
    private Cluster cluster = Cluster.empty();
    private AuthenticationException authException = null;

    public AdminMetadataManager(LogContext logContext, long refreshBackoffMs, long metadataExpireMs) {
        this.log = logContext.logger(AdminMetadataManager.class);
        this.refreshBackoffMs = refreshBackoffMs;
        this.metadataExpireMs = metadataExpireMs;
        this.updater = new AdminMetadataUpdater();
    }

    public AdminMetadataUpdater updater() {
        return this.updater;
    }

    public boolean isReady() {
        if (this.authException != null) {
            this.log.debug("Metadata is not usable: failed to get metadata.", this.authException);
            throw this.authException;
        }
        if (this.cluster.nodes().isEmpty()) {
            this.log.trace("Metadata is not ready: bootstrap nodes have not been initialized yet.");
            return false;
        }
        if (this.cluster.isBootstrapConfigured()) {
            this.log.trace("Metadata is not ready: we have not fetched metadata from the bootstrap nodes yet.");
            return false;
        }
        this.log.trace("Metadata is ready to use.");
        return true;
    }

    public Node controller() {
        return this.cluster.controller();
    }

    public Node nodeById(int nodeId) {
        return this.cluster.nodeById(nodeId);
    }

    public void requestUpdate() {
        if (this.state == State.QUIESCENT) {
            this.state = State.UPDATE_REQUESTED;
            this.log.debug("Requesting metadata update.");
        }
    }

    public void clearController() {
        if (this.cluster.controller() != null) {
            this.log.trace("Clearing cached controller node {}.", (Object)this.cluster.controller());
            this.cluster = new Cluster(this.cluster.clusterResource().clusterId(), this.cluster.nodes(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null);
        }
    }

    public long metadataFetchDelayMs(long now) {
        switch (this.state) {
            case QUIESCENT: {
                return Math.max(this.delayBeforeNextAttemptMs(now), this.delayBeforeNextExpireMs(now));
            }
            case UPDATE_REQUESTED: {
                return this.delayBeforeNextAttemptMs(now);
            }
        }
        return Long.MAX_VALUE;
    }

    private long delayBeforeNextExpireMs(long now) {
        long timeSinceUpdate = now - this.lastMetadataUpdateMs;
        return Math.max(0L, this.metadataExpireMs - timeSinceUpdate);
    }

    private long delayBeforeNextAttemptMs(long now) {
        long timeSinceAttempt = now - this.lastMetadataFetchAttemptMs;
        return Math.max(0L, this.refreshBackoffMs - timeSinceAttempt);
    }

    public void transitionToUpdatePending(long now) {
        this.state = State.UPDATE_PENDING;
        this.lastMetadataFetchAttemptMs = now;
    }

    public void updateFailed(Throwable exception) {
        this.state = State.QUIESCENT;
        if (exception instanceof AuthenticationException) {
            this.log.warn("Metadata update failed due to authentication error", exception);
            this.authException = (AuthenticationException)exception;
        } else {
            this.log.info("Metadata update failed", exception);
        }
    }

    public void update(Cluster cluster, long now) {
        if (cluster.isBootstrapConfigured()) {
            this.log.debug("Setting bootstrap cluster metadata {}.", (Object)cluster);
        } else {
            this.log.debug("Updating cluster metadata to {}", (Object)cluster);
            this.lastMetadataUpdateMs = now;
        }
        this.state = State.QUIESCENT;
        this.authException = null;
        if (!cluster.nodes().isEmpty()) {
            this.cluster = cluster;
        }
    }

    static enum State {
        QUIESCENT,
        UPDATE_REQUESTED,
        UPDATE_PENDING;

    }

    public class AdminMetadataUpdater
    implements MetadataUpdater {
        @Override
        public List<Node> fetchNodes() {
            return AdminMetadataManager.this.cluster.nodes();
        }

        @Override
        public boolean isUpdateDue(long now) {
            return false;
        }

        @Override
        public long maybeUpdate(long now) {
            return Long.MAX_VALUE;
        }

        @Override
        public void handleDisconnection(String destination) {
        }

        @Override
        public void handleAuthenticationFailure(AuthenticationException e) {
            AdminMetadataManager.this.updateFailed(e);
        }

        @Override
        public void handleCompletedMetadataResponse(RequestHeader requestHeader, long now, MetadataResponse metadataResponse) {
        }

        @Override
        public void requestUpdate() {
            AdminMetadataManager.this.requestUpdate();
        }

        @Override
        public void close() {
        }
    }
}

