/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.net.base;

import com.emc.mongoose.common.api.SizeInBytes;
import com.emc.mongoose.common.concurrent.ThreadUtil;
import com.emc.mongoose.common.exception.UserShootHisFootException;
import com.emc.mongoose.common.net.ssl.SslContext;
import com.emc.mongoose.model.NamingThreadFactory;
import com.emc.mongoose.model.data.ContentSource;
import com.emc.mongoose.model.io.IoType;
import com.emc.mongoose.model.io.task.IoTask;
import com.emc.mongoose.model.item.Item;
import com.emc.mongoose.storage.driver.base.StorageDriverBase;
import com.emc.mongoose.storage.driver.net.base.NetStorageDriver;
import com.emc.mongoose.storage.driver.net.base.RequestSentCallback;
import com.emc.mongoose.storage.driver.net.base.pool.BasicMultiNodeConnPool;
import com.emc.mongoose.storage.driver.net.base.pool.NonBlockingConnPool;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.commons.lang.SystemUtils;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;

public abstract class NetStorageDriverBase<I extends Item, O extends IoTask<I>>
extends StorageDriverBase<I, O>
implements NetStorageDriver<I, O>,
ChannelPoolHandler {
    protected final String[] storageNodeAddrs;
    protected final Bootstrap bootstrap;
    protected final int storageNodePort;
    private final EventLoopGroup workerGroup;
    private final NonBlockingConnPool connPool;
    private final int socketTimeout;
    protected final boolean sslFlag;

    protected NetStorageDriverBase(String jobName, ContentSource contentSrc, Config.LoadConfig loadConfig, Config.StorageConfig storageConfig, boolean verifyFlag) throws UserShootHisFootException {
        super(jobName, contentSrc, loadConfig, storageConfig, verifyFlag);
        Config.StorageConfig.NetConfig netConfig = storageConfig.getNetConfig();
        this.sslFlag = netConfig.getSsl();
        long sto = netConfig.getTimeoutMilliSec();
        if (sto < 0L || sto > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Socket timeout shouldn't be more than 2147483647 seconds and less than 0");
        }
        this.socketTimeout = (int)sto;
        Config.StorageConfig.NetConfig.NodeConfig nodeConfig = netConfig.getNodeConfig();
        this.storageNodePort = nodeConfig.getPort();
        String[] t = nodeConfig.getAddrs().toArray(new String[0]);
        this.storageNodeAddrs = new String[t.length];
        for (int i = 0; i < t.length; ++i) {
            String n = t[i];
            this.storageNodeAddrs[i] = n + (n.contains(":") ? "" : ":" + this.storageNodePort);
        }
        int confWorkerCount = storageConfig.getDriverConfig().getIoConfig().getWorkers();
        int workerCount = confWorkerCount < 1 ? Math.min(this.concurrencyLevel, ThreadUtil.getHardwareThreadCount()) : confWorkerCount;
        this.workerGroup = SystemUtils.IS_OS_LINUX ? new EpollEventLoopGroup(workerCount, (ThreadFactory)new NamingThreadFactory(this.toString() + "/ioWorker", true)) : new NioEventLoopGroup(workerCount, (ThreadFactory)new NamingThreadFactory(this.toString() + "/ioWorker", true));
        this.bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group(this.workerGroup)).channel(SystemUtils.IS_OS_LINUX ? EpollSocketChannel.class : NioSocketChannel.class);
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)netConfig.getTimeoutMilliSec());
        int size = (int)netConfig.getRcvBuf().get();
        if (size > 0) {
            this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)size);
        }
        if ((size = (int)netConfig.getSndBuf().get()) > 0) {
            this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)size);
        }
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)netConfig.getKeepAlive());
        this.bootstrap.option(ChannelOption.SO_LINGER, (Object)netConfig.getLinger());
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)netConfig.getReuseAddr());
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)netConfig.getTcpNoDelay());
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"step.name", (String)this.stepName).put("class.name", NetStorageDriverBase.class.getSimpleName());){
            this.connPool = this.createConnectionPool();
        }
    }

    protected NonBlockingConnPool createConnectionPool() {
        return new BasicMultiNodeConnPool(this.concurrencyLevel, this.concurrencyThrottle, this.storageNodeAddrs, this.bootstrap, this, this.storageNodePort);
    }

    public final void adjustIoBuffers(SizeInBytes avgDataItemSize, IoType ioType) {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"step.name", (String)this.stepName).put("class.name", NetStorageDriverBase.class.getSimpleName());){
            int size = avgDataItemSize.get() < 4096L ? 4096 : (0x1000000L < avgDataItemSize.get() ? 0x1000000 : (int)avgDataItemSize.get());
            if (IoType.CREATE.equals((Object)ioType)) {
                Loggers.MSG.info("Adjust output buffer size: {}", (Object)SizeInBytes.formatFixedSize((long)size));
                this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)4096);
                this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)size);
            } else if (IoType.READ.equals((Object)ioType)) {
                Loggers.MSG.info("Adjust input buffer size: {}", (Object)SizeInBytes.formatFixedSize((long)size));
                this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)size);
                this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)4096);
            } else {
                this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)4096);
                this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)4096);
            }
        }
    }

    protected Channel getUnpooledConnection() throws ConnectException, InterruptedException {
        InetSocketAddress nodeAddr;
        String na = this.storageNodeAddrs[0];
        if (na.contains(":")) {
            String[] addrParts = na.split(":");
            nodeAddr = new InetSocketAddress(addrParts[0], Integer.parseInt(addrParts[1]));
        } else {
            nodeAddr = new InetSocketAddress(na, this.storageNodePort);
        }
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.workerGroup)).channel(SystemUtils.IS_OS_LINUX ? EpollSocketChannel.class : NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected final void initChannel(SocketChannel channel) throws Exception {
                try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"step.name", (String)NetStorageDriverBase.this.stepName).put("class.name", StorageDriverBase.class.getSimpleName());){
                    NetStorageDriverBase.this.appendHandlers(channel.pipeline());
                    Loggers.MSG.debug("{}: new unpooled channel {}, pipeline: {}", (Object)NetStorageDriverBase.this.stepName, (Object)channel.hashCode(), (Object)channel.pipeline());
                }
            }
        });
        return bootstrap.connect((SocketAddress)nodeAddr).sync().channel();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean submit(O ioTask) throws InterruptedException {
        if (!this.isStarted()) {
            throw new InterruptedException();
        }
        ioTask.reset();
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"step.name", (String)this.stepName).put("class.name", StorageDriverBase.class.getSimpleName());){
            if (IoType.NOOP.equals((Object)ioTask.getIoType())) {
                this.concurrencyThrottle.acquire();
                ioTask.startRequest();
                this.sendRequest(null, null, ioTask);
                ioTask.finishRequest();
                this.concurrencyThrottle.release();
                ioTask.setStatus(IoTask.Status.SUCC);
                ioTask.startResponse();
                this.complete(null, ioTask);
                return true;
            }
            Channel conn = this.connPool.lease();
            if (conn == null) {
                boolean bl = false;
                return bl;
            }
            conn.attr(ATTR_KEY_IOTASK).set(ioTask);
            ioTask.setNodeAddr((String)conn.attr(NonBlockingConnPool.ATTR_KEY_NODE).get());
            ioTask.startRequest();
            this.sendRequest(conn, conn.newPromise().addListener((GenericFutureListener)new RequestSentCallback((IoTask)ioTask)), ioTask);
            return true;
        }
        catch (IllegalStateException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Submit the I/O task in the invalid state", (Object[])new Object[0]);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int submit(List<O> ioTasks, int from, int to) throws InterruptedException {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"step.name", (String)this.stepName).put("class.name", StorageDriverBase.class.getSimpleName());){
            int i = from;
            while (i < to) {
                if (!this.isStarted()) return to - from;
                IoTask nextIoTask = (IoTask)ioTasks.get(i);
                nextIoTask.reset();
                if (IoType.NOOP.equals((Object)nextIoTask.getIoType())) {
                    this.concurrencyThrottle.acquire();
                    nextIoTask.startRequest();
                    this.sendRequest(null, null, nextIoTask);
                    nextIoTask.finishRequest();
                    this.concurrencyThrottle.release();
                    nextIoTask.setStatus(IoTask.Status.SUCC);
                    nextIoTask.startResponse();
                    this.complete(null, nextIoTask);
                } else {
                    Channel conn = this.connPool.lease();
                    if (conn == null) {
                        int n = i - from;
                        return n;
                    }
                    conn.attr(ATTR_KEY_IOTASK).set((Object)nextIoTask);
                    nextIoTask.setNodeAddr((String)conn.attr(NonBlockingConnPool.ATTR_KEY_NODE).get());
                    nextIoTask.startRequest();
                    this.sendRequest(conn, conn.newPromise().addListener((GenericFutureListener)new RequestSentCallback(nextIoTask)), nextIoTask);
                }
                ++i;
            }
            return to - from;
        }
        catch (IllegalStateException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Submit the I/O task in the invalid state", (Object[])new Object[0]);
            return to - from;
        }
        catch (RejectedExecutionException e) {
            if (this.isInterrupted()) return to - from;
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to submit the I/O task", (Object[])new Object[0]);
        }
        return to - from;
    }

    protected final int submit(List<O> ioTasks) throws InterruptedException {
        return this.submit(ioTasks, 0, ioTasks.size());
    }

    protected abstract void sendRequest(Channel var1, ChannelPromise var2, O var3);

    @Override
    public void complete(Channel channel, O ioTask) {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"step.name", (String)this.stepName).put("class.name", StorageDriverBase.class.getSimpleName());){
            ioTask.finishResponse();
        }
        catch (IllegalStateException e) {
            LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"{}: invalid I/O task state", (Object[])new Object[]{ioTask.toString()});
        }
        if (!IoType.NOOP.equals((Object)ioTask.getIoType())) {
            this.connPool.release(channel);
        }
        this.ioTaskCompleted((IoTask)ioTask);
    }

    public final void channelReleased(Channel channel) throws Exception {
    }

    public final void channelAcquired(Channel channel) throws Exception {
    }

    public final void channelCreated(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        this.appendHandlers(pipeline);
        if (Loggers.MSG.isTraceEnabled()) {
            Loggers.MSG.trace("{}: new channel pipeline configured: {}", (Object)this.stepName, (Object)pipeline.toString());
        }
    }

    protected void appendHandlers(ChannelPipeline pipeline) {
        if (this.sslFlag) {
            Loggers.MSG.debug("{}: SSL/TLS is enabled for the channel", (Object)this.stepName);
            SSLEngine sslEngine = SslContext.INSTANCE.createSSLEngine();
            sslEngine.setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "SSLv3"});
            sslEngine.setUseClientMode(true);
            sslEngine.setEnabledCipherSuites(SslContext.INSTANCE.getServerSocketFactory().getSupportedCipherSuites());
            pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
        }
        if (this.socketTimeout > 0) {
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler((long)this.socketTimeout, (long)this.socketTimeout, (long)this.socketTimeout, TimeUnit.MILLISECONDS)});
        }
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return false;
    }

    protected final void doInterrupt() throws IllegalStateException {
        block17: {
            try (CloseableThreadContext.Instance ctx = CloseableThreadContext.put((String)"step.name", (String)this.stepName).put("class.name", this.getClass().getSimpleName());){
                super.doInterrupt();
                try {
                    this.connPool.close();
                }
                catch (IOException e) {
                    LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"{}: failed to close the connection pool", (Object[])new Object[]{this.toString()});
                }
                try {
                    if (this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS).await(10L)) {
                        Loggers.MSG.debug("{}: I/O workers stopped in time", (Object)this.toString());
                        break block17;
                    }
                    Loggers.ERR.debug("{}: I/O workers stopping timeout", (Object)this.toString());
                }
                catch (InterruptedException e) {
                    LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Graceful I/O workers shutdown was interrupted", (Object[])new Object[0]);
                }
            }
        }
    }
}

