/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.net.base.data;

import com.emc.mongoose.common.api.ByteRange;
import com.emc.mongoose.common.io.ThreadLocalByteBuffer;
import com.emc.mongoose.model.data.DataCorruptionException;
import com.emc.mongoose.model.data.DataSizeException;
import com.emc.mongoose.model.data.DataVerificationException;
import com.emc.mongoose.model.io.task.IoTask;
import com.emc.mongoose.model.io.task.data.DataIoTask;
import com.emc.mongoose.model.item.DataItem;
import com.emc.mongoose.ui.log.Loggers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;

public abstract class ResponseContentUtil {
    public static void verifyChunk(DataIoTask dataIoTask, long countBytesDone, ByteBuf contentChunk, int chunkSize) throws IOException {
        block12: {
            List byteRanges = dataIoTask.getFixedRanges();
            DataItem item = dataIoTask.getItem();
            try {
                if (byteRanges != null && !byteRanges.isEmpty()) {
                    ResponseContentUtil.verifyChunkDataAndSize(dataIoTask, item, countBytesDone, contentChunk, chunkSize, byteRanges);
                } else if (dataIoTask.hasMarkedRanges()) {
                    ResponseContentUtil.verifyChunkDataAndSize(dataIoTask, item, countBytesDone, contentChunk, chunkSize, dataIoTask.getMarkedRangesMaskPair());
                } else {
                    if (item.isUpdated()) {
                        ResponseContentUtil.verifyChunkUpdatedData(dataIoTask, item, countBytesDone, contentChunk, chunkSize);
                    } else {
                        if ((long)chunkSize > item.size() - countBytesDone) {
                            throw new DataSizeException(item.size(), countBytesDone + (long)chunkSize);
                        }
                        ResponseContentUtil.verifyChunkData(item, contentChunk, 0, chunkSize);
                    }
                    dataIoTask.setCountBytesDone(countBytesDone + (long)chunkSize);
                }
            }
            catch (DataVerificationException e) {
                DataItem dataItem = dataIoTask.getItem();
                dataIoTask.setCountBytesDone(e.getOffset());
                dataIoTask.setStatus(IoTask.Status.RESP_FAIL_CORRUPT);
                if (e instanceof DataSizeException) {
                    try {
                        Loggers.MSG.debug("{}: invalid size, expected: {}, actual: {} ", (Object)dataItem.getName(), (Object)dataItem.size(), (Object)e.getOffset());
                    }
                    catch (IOException iOException) {}
                }
                if (!(e instanceof DataCorruptionException)) break block12;
                DataCorruptionException ee = (DataCorruptionException)e;
                Loggers.MSG.debug("{}: content mismatch @ offset {}, expected: {}, actual: {} ", (Object)dataItem.getName(), (Object)ee.getOffset(), (Object)String.format("\"0x%X\"", ee.expected), (Object)String.format("\"0x%X\"", ee.actual));
            }
        }
    }

    private static void verifyChunkDataAndSize(DataIoTask dataIoTask, DataItem dataItem, long countBytesDone, ByteBuf chunkData, int chunkSize, List<ByteRange> byteRanges) throws DataCorruptionException, IOException {
        long rangesSizeSum = dataIoTask.getMarkedRangesSize();
        if ((long)chunkSize > rangesSizeSum - countBytesDone) {
            throw new DataSizeException(dataIoTask.getMarkedRangesSize(), countBytesDone + (long)chunkSize);
        }
        long baseItemSize = dataItem.size();
        long rangeBytesDone = countBytesDone;
        int chunkOffset = 0;
        while (chunkOffset < chunkSize) {
            long rangeSize;
            int currRangeIdx = dataIoTask.getCurrRangeIdx();
            ByteRange byteRange = byteRanges.get(currRangeIdx);
            long currOffset = byteRange.getBeg();
            long rangeEnd = byteRange.getEnd();
            if (currOffset == -1L) {
                currOffset = baseItemSize - rangeEnd;
                rangeSize = rangeEnd;
            } else {
                rangeSize = rangeEnd == -1L ? baseItemSize - currOffset : rangeEnd - currOffset + 1L;
            }
            int n = DataItem.getRangeCount((long)((currOffset += rangeBytesDone) + 1L)) - 1;
            long cellOffset = DataItem.getRangeOffset((int)n);
            long cellEnd = Math.min(baseItemSize, DataItem.getRangeOffset((int)(n + 1)));
            DataItem currRange = dataItem.slice(cellOffset, cellEnd);
            if (dataItem.isRangeUpdated(n)) {
                currRange.layer(dataItem.layer() + 1);
            }
            currRange.position(currOffset - cellOffset);
            n = (int)Math.min((long)(chunkSize - chunkOffset), Math.min(rangeSize - rangeBytesDone, cellEnd - currOffset));
            ResponseContentUtil.verifyChunkData(currRange, chunkData, chunkOffset, n);
            chunkOffset += n;
            if ((rangeBytesDone += (long)n) == rangeSize) {
                if (currRangeIdx == byteRanges.size() - 1) {
                    dataIoTask.setCountBytesDone(rangesSizeSum);
                    break;
                }
                dataIoTask.setCurrRangeIdx(currRangeIdx + 1);
                rangeBytesDone = 0L;
            }
            dataIoTask.setCountBytesDone(rangeBytesDone);
        }
    }

    private static void verifyChunkDataAndSize(DataIoTask dataIoTask, DataItem dataItem, long countBytesDone, ByteBuf chunkData, int chunkSize, BitSet[] markedRangesMaskPair) throws DataCorruptionException, IOException {
        if ((long)chunkSize > dataIoTask.getMarkedRangesSize() - countBytesDone) {
            throw new DataSizeException(dataIoTask.getMarkedRangesSize(), countBytesDone + (long)chunkSize);
        }
        long rangeBytesDone = countBytesDone;
        int chunkOffset = 0;
        while (chunkOffset < chunkSize) {
            int currRangeIdx = dataIoTask.getCurrRangeIdx();
            if (!markedRangesMaskPair[0].get(currRangeIdx) && !markedRangesMaskPair[1].get(currRangeIdx)) {
                if (-1 == markedRangesMaskPair[0].nextSetBit(currRangeIdx) && -1 == markedRangesMaskPair[1].nextSetBit(currRangeIdx)) {
                    dataIoTask.setCountBytesDone(dataIoTask.getMarkedRangesSize());
                    return;
                }
                dataIoTask.setCurrRangeIdx(currRangeIdx + 1);
                continue;
            }
            DataItem currRange = dataIoTask.getCurrRange();
            long rangeSize = dataItem.getRangeSize(currRangeIdx);
            currRange.position(rangeBytesDone);
            int n = (int)Math.min((long)(chunkSize - chunkOffset), rangeSize - rangeBytesDone);
            ResponseContentUtil.verifyChunkData(currRange, chunkData, chunkOffset, n);
            chunkOffset += n;
            if ((rangeBytesDone += (long)n) == rangeSize) {
                if (-1 == markedRangesMaskPair[0].nextSetBit(currRangeIdx + 1) && -1 == markedRangesMaskPair[1].nextSetBit(currRangeIdx + 1)) {
                    dataIoTask.setCountBytesDone(dataIoTask.getMarkedRangesSize());
                    return;
                }
                dataIoTask.setCurrRangeIdx(currRangeIdx + 1);
                rangeBytesDone = 0L;
            }
            dataIoTask.setCountBytesDone(rangeBytesDone);
        }
    }

    private static void verifyChunkUpdatedData(DataIoTask dataIoTask, DataItem item, long countBytesDone, ByteBuf chunkData, int chunkSize) throws DataCorruptionException, IOException {
        int remainingSize;
        for (int chunkCountDone = 0; chunkCountDone < chunkSize; chunkCountDone += remainingSize) {
            int currRangeIdx = dataIoTask.getCurrRangeIdx();
            long nextRangeOffset = DataItem.getRangeOffset((int)(currRangeIdx + 1));
            if (countBytesDone + (long)chunkCountDone == nextRangeOffset) {
                if (nextRangeOffset < item.size()) {
                    nextRangeOffset = DataItem.getRangeOffset((int)(++currRangeIdx + 1));
                    dataIoTask.setCurrRangeIdx(currRangeIdx);
                } else {
                    throw new DataSizeException(item.size(), countBytesDone + (long)chunkSize);
                }
            }
            DataItem currRange = dataIoTask.getCurrRange();
            try {
                remainingSize = (int)Math.min((long)(chunkSize - chunkCountDone), nextRangeOffset - countBytesDone - (long)chunkCountDone);
                ResponseContentUtil.verifyChunkData(currRange, chunkData, chunkCountDone, remainingSize);
                continue;
            }
            catch (DataCorruptionException e) {
                throw new DataCorruptionException(DataItem.getRangeOffset((int)dataIoTask.getCurrRangeIdx()) + e.getOffset(), e.expected, e.actual);
            }
        }
    }

    private static void verifyChunkData(DataItem item, ByteBuf chunkData, int chunkOffset, int remainingSize) throws DataCorruptionException, IOException {
        int i;
        ByteBuffer bb = ThreadLocalByteBuffer.get((long)remainingSize);
        bb.limit(remainingSize);
        for (int n = 0; n < remainingSize; n += item.read(bb)) {
        }
        bb.flip();
        ByteBuf buff = Unpooled.wrappedBuffer((ByteBuffer)bb);
        boolean fastEquals = true;
        int buffPos = 0;
        int chunkPos = chunkOffset;
        if (buff.writerIndex() - remainingSize < buffPos || chunkData.writerIndex() - remainingSize < chunkPos) {
            fastEquals = false;
        } else {
            int longCount = remainingSize >>> 3;
            int byteCount = remainingSize & 7;
            for (i = longCount; i > 0; --i) {
                if (buff.getLong(buffPos) != chunkData.getLong(chunkPos)) {
                    fastEquals = false;
                    break;
                }
                buffPos += 8;
                chunkPos += 8;
            }
            if (fastEquals) {
                for (i = byteCount; i > 0; --i) {
                    if (buff.getByte(buffPos) != chunkData.getByte(chunkPos)) {
                        fastEquals = false;
                        break;
                    }
                    ++buffPos;
                    ++chunkPos;
                }
            }
        }
        if (fastEquals) {
            buff.release();
            return;
        }
        for (i = 0; i < remainingSize; ++i) {
            byte actual;
            byte expected = buff.getByte(i);
            if (expected == (actual = chunkData.getByte(chunkOffset + i))) continue;
            buff.release();
            throw new DataCorruptionException((long)i, expected, actual);
        }
        buff.release();
    }
}

