/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.net.base.pool;

import com.emc.mongoose.storage.driver.net.base.pool.NonBlockingConnPool;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.pool.ChannelPoolHandler;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.logging.log4j.Level;

public class BasicMultiNodeConnPool
implements NonBlockingConnPool {
    private final Semaphore concurrencyThrottle;
    private final String[] nodes;
    private final int n;
    private final Map<String, Bootstrap> bootstrapMap;
    private final Map<String, Queue<Channel>> connsMap;
    private final Object2IntMap<String> connsCountMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicMultiNodeConnPool(int concurrencyLevel, Semaphore concurrencyThrottle, String[] nodes, Bootstrap bootstrap, final ChannelPoolHandler connPoolHandler, int defaultPort) {
        this.concurrencyThrottle = concurrencyThrottle;
        if (nodes.length == 0) {
            throw new IllegalArgumentException("Empty nodes array argument");
        }
        this.nodes = nodes;
        this.n = nodes.length;
        this.bootstrapMap = new HashMap<String, Bootstrap>(this.n);
        this.connsMap = new HashMap<String, Queue<Channel>>(this.n);
        this.connsCountMap = new Object2IntOpenHashMap(this.n);
        for (String node : nodes) {
            InetSocketAddress nodeAddr;
            if (node.contains(":")) {
                String[] addrParts = node.split(":");
                nodeAddr = new InetSocketAddress(addrParts[0], Integer.parseInt(addrParts[1]));
            } else {
                nodeAddr = new InetSocketAddress(node, defaultPort);
            }
            this.bootstrapMap.put(node, (Bootstrap)bootstrap.clone().remoteAddress((SocketAddress)nodeAddr).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected final void initChannel(Channel conn) throws Exception {
                    assert (conn.eventLoop().inEventLoop());
                    connPoolHandler.channelCreated(conn);
                }
            }));
            this.connsMap.put(node, new ConcurrentLinkedQueue());
            this.connsCountMap.put((Object)node, 0);
        }
        for (int i = 0; i < concurrencyLevel; ++i) {
            Channel conn = this.connect();
            if (conn == null) {
                Loggers.ERR.warn("Failed to pre-create the connections to the target nodes");
                break;
            }
            String nodeAddr = (String)conn.attr(ATTR_KEY_NODE).get();
            if (conn.isActive()) {
                Queue<Channel> connQueue = this.connsMap.get(nodeAddr);
                if (connQueue == null) continue;
                connQueue.add(conn);
                continue;
            }
            Object2IntMap<String> object2IntMap = this.connsCountMap;
            synchronized (object2IntMap) {
                this.connsCountMap.put((Object)nodeAddr, (Integer)this.connsCountMap.get((Object)nodeAddr) - 1);
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel connect() {
        Channel conn = null;
        String selectedNodeAddr = null;
        int minConnsCount = Integer.MAX_VALUE;
        int nextConnsCount = 0;
        Object2IntMap<String> object2IntMap = this.connsCountMap;
        synchronized (object2IntMap) {
            for (int i = 0; i < this.n; ++i) {
                String nextNodeAddr = this.nodes[i];
                nextConnsCount = (Integer)this.connsCountMap.get((Object)nextNodeAddr);
                if (nextConnsCount == 0) {
                    selectedNodeAddr = nextNodeAddr;
                    break;
                }
                if (nextConnsCount >= minConnsCount) continue;
                minConnsCount = nextConnsCount;
                selectedNodeAddr = nextNodeAddr;
            }
            Loggers.MSG.debug("New connection to \"{}\"", selectedNodeAddr);
            try {
                conn = this.connect(selectedNodeAddr);
                conn.attr(ATTR_KEY_NODE).set(selectedNodeAddr);
                this.connsCountMap.put((Object)selectedNodeAddr, nextConnsCount + 1);
            }
            catch (Exception e) {
                LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to create a new connection to {}", (Object[])new Object[]{selectedNodeAddr});
            }
        }
        return conn;
    }

    protected Channel connect(String addr) throws Exception {
        return this.bootstrapMap.get(addr).connect().sync().channel();
    }

    protected Channel poll() {
        int i;
        for (int j = i = ThreadLocalRandom.current().nextInt(this.n); j < i + this.n; ++j) {
            Queue<Channel> connQueue = this.connsMap.get(this.nodes[j % this.n]);
            Channel conn = connQueue.poll();
            if (conn == null) continue;
            return conn;
        }
        return null;
    }

    @Override
    public final Channel lease() {
        Channel conn = null;
        if (this.concurrencyThrottle.tryAcquire()) {
            conn = this.poll();
            if (null == conn) {
                conn = this.connect();
            }
            if (conn == null) {
                this.concurrencyThrottle.release();
            }
        }
        return conn;
    }

    @Override
    public final int lease(List<Channel> conns, int maxCount) {
        int availableCount = this.concurrencyThrottle.drainPermits();
        if (availableCount == 0) {
            return availableCount;
        }
        if (availableCount > maxCount) {
            this.concurrencyThrottle.release(availableCount - maxCount);
            availableCount = maxCount;
        }
        for (int i = 0; i < availableCount; ++i) {
            Channel conn = this.poll();
            if (null == conn) {
                conn = this.connect();
            }
            if (conn == null) {
                this.concurrencyThrottle.release(availableCount - i);
                return i;
            }
            conns.add(conn);
        }
        return availableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void release(Channel conn) {
        String nodeAddr = (String)conn.attr(ATTR_KEY_NODE).get();
        if (conn.isActive()) {
            Queue<Channel> connQueue = this.connsMap.get(nodeAddr);
            if (connQueue != null) {
                connQueue.add(conn);
            }
        } else {
            Object2IntMap<String> object2IntMap = this.connsCountMap;
            synchronized (object2IntMap) {
                this.connsCountMap.put((Object)nodeAddr, (Integer)this.connsCountMap.get((Object)nodeAddr) - 1);
            }
            conn.close();
        }
        this.concurrencyThrottle.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void release(List<Channel> conns) {
        for (Channel conn : conns) {
            String nodeAddr = (String)conn.attr(ATTR_KEY_NODE).get();
            if (conn.isActive()) {
                Queue<Channel> connQueue = this.connsMap.get(nodeAddr);
                connQueue.add(conn);
            } else {
                Object2IntMap<String> object2IntMap = this.connsCountMap;
                synchronized (object2IntMap) {
                    this.connsCountMap.put((Object)nodeAddr, (Integer)this.connsCountMap.get((Object)nodeAddr) - 1);
                }
                conn.close();
            }
            this.concurrencyThrottle.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        for (String nodeAddr : this.nodes) {
            Channel nextConn;
            Queue<Channel> connQueue = this.connsMap.get(nodeAddr);
            while (null != (nextConn = connQueue.poll())) {
                nextConn.close();
            }
        }
        this.connsMap.clear();
        Object2IntMap<String> object2IntMap = this.connsCountMap;
        synchronized (object2IntMap) {
            this.connsCountMap.clear();
        }
        this.bootstrapMap.clear();
    }
}

