/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.coop.netty.data;

import com.emc.mongoose.base.item.DataItem;
import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

public class DataItemFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    protected final DataItem dataItem;
    protected final long baseItemSize;
    protected long doneByteCount = 0L;

    public DataItemFileRegion(DataItem dataItem) throws IOException {
        this.dataItem = dataItem;
        this.baseItemSize = dataItem.size();
    }

    @Override
    public long position() {
        return this.doneByteCount;
    }

    @Override
    @Deprecated
    public long transfered() {
        return this.doneByteCount;
    }

    @Override
    public long transferred() {
        return this.doneByteCount;
    }

    @Override
    public long count() {
        return this.baseItemSize;
    }

    @Override
    public long transferTo(WritableByteChannel target, long position) throws IOException {
        this.dataItem.position(position);
        this.doneByteCount += this.dataItem.writeToSocketChannel(target, this.baseItemSize - position);
        return this.doneByteCount;
    }

    @Override
    public FileRegion retain() {
        super.retain();
        return this;
    }

    @Override
    public FileRegion retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public FileRegion touch() {
        return this.touch(this);
    }

    @Override
    public FileRegion touch(Object hint) {
        return this;
    }

    @Override
    protected void deallocate() {
    }
}

