/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.coop.netty.data;

import com.emc.mongoose.base.data.DataCorruptionException;
import com.emc.mongoose.base.data.DataSizeException;
import com.emc.mongoose.base.data.DataVerificationException;
import com.emc.mongoose.base.item.DataItem;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.data.DataOperation;
import com.emc.mongoose.base.logging.Loggers;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.system.DirectMemUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.BitSet;
import java.util.List;

public abstract class ResponseContentUtil {
    public static void verifyChunk(DataOperation dataOp, long countBytesDone, ByteBuf contentChunk, int chunkSize) throws IOException {
        block12: {
            List byteRanges = dataOp.fixedRanges();
            DataItem item = dataOp.item();
            try {
                if (byteRanges != null && !byteRanges.isEmpty()) {
                    ResponseContentUtil.verifyChunkDataAndSize(dataOp, item, countBytesDone, contentChunk, chunkSize, byteRanges);
                } else if (dataOp.hasMarkedRanges()) {
                    ResponseContentUtil.verifyChunkDataAndSize(dataOp, item, countBytesDone, contentChunk, chunkSize, dataOp.markedRangesMaskPair());
                } else {
                    if (item.isUpdated()) {
                        ResponseContentUtil.verifyChunkUpdatedData(dataOp, item, countBytesDone, contentChunk, chunkSize);
                    } else {
                        if ((long)chunkSize > item.size() - countBytesDone) {
                            throw new DataSizeException(item.size(), countBytesDone + (long)chunkSize);
                        }
                        ResponseContentUtil.verifyChunkData(item, contentChunk, 0, chunkSize);
                    }
                    dataOp.countBytesDone(countBytesDone + (long)chunkSize);
                }
            }
            catch (DataVerificationException e) {
                DataItem dataItem = dataOp.item();
                dataOp.countBytesDone(e.getOffset());
                dataOp.status(Operation.Status.RESP_FAIL_CORRUPT);
                if (e instanceof DataSizeException) {
                    try {
                        Loggers.MSG.debug("{}: invalid size, expected: {}, actual: {} ", (Object)dataItem.name(), (Object)dataItem.size(), (Object)e.getOffset());
                    }
                    catch (IOException iOException) {}
                }
                if (!(e instanceof DataCorruptionException)) break block12;
                DataCorruptionException ee = (DataCorruptionException)e;
                Loggers.MSG.debug("{}: content mismatch @ offset {}, expected: {}, actual: {} ", (Object)dataItem.name(), (Object)ee.getOffset(), (Object)String.format("\"0x%X\"", ee.expected & 0xFF), (Object)String.format("\"0x%X\"", ee.actual & 0xFF));
            }
        }
    }

    private static void verifyChunkDataAndSize(DataOperation dataOp, DataItem dataItem, long countBytesDone, ByteBuf chunkData, int chunkSize, List<Range> byteRanges) throws DataCorruptionException, IOException {
        long rangesSizeSum = dataOp.markedRangesSize();
        if ((long)chunkSize > rangesSizeSum - countBytesDone) {
            throw new DataSizeException(dataOp.markedRangesSize(), countBytesDone + (long)chunkSize);
        }
        long baseItemSize = dataItem.size();
        long rangeBytesDone = countBytesDone;
        int chunkOffset = 0;
        while (chunkOffset < chunkSize) {
            long rangeSize;
            int currRangeIdx = dataOp.currRangeIdx();
            Range byteRange = byteRanges.get(currRangeIdx);
            long currOffset = byteRange.getBeg();
            long rangeEnd = byteRange.getEnd();
            if (currOffset == -1L) {
                currOffset = baseItemSize - rangeEnd;
                rangeSize = rangeEnd;
            } else {
                rangeSize = rangeEnd == -1L ? baseItemSize - currOffset : rangeEnd - currOffset + 1L;
            }
            int n = DataItem.rangeCount((long)((currOffset += rangeBytesDone) + 1L)) - 1;
            long cellOffset = DataItem.rangeOffset((int)n);
            long cellEnd = Math.min(baseItemSize, DataItem.rangeOffset((int)(n + 1)));
            DataItem currRange = dataItem.slice(cellOffset, cellEnd - cellOffset);
            if (dataItem.isRangeUpdated(n)) {
                currRange.layer(dataItem.layer() + 1);
            }
            currRange.position(currOffset - cellOffset);
            n = (int)Math.min((long)(chunkSize - chunkOffset), Math.min(rangeSize - rangeBytesDone, cellEnd - currOffset));
            ResponseContentUtil.verifyChunkData(currRange, chunkData, chunkOffset, n);
            chunkOffset += n;
            if ((rangeBytesDone += (long)n) == rangeSize) {
                if (currRangeIdx == byteRanges.size() - 1) {
                    dataOp.countBytesDone(rangesSizeSum);
                    break;
                }
                dataOp.currRangeIdx(currRangeIdx + 1);
                rangeBytesDone = 0L;
            }
            dataOp.countBytesDone(rangeBytesDone);
        }
    }

    private static void verifyChunkDataAndSize(DataOperation dataOp, DataItem dataItem, long countBytesDone, ByteBuf chunkData, int chunkSize, BitSet[] markedRangesMaskPair) throws DataCorruptionException, IOException {
        if ((long)chunkSize > dataOp.markedRangesSize() - countBytesDone) {
            throw new DataSizeException(dataOp.markedRangesSize(), countBytesDone + (long)chunkSize);
        }
        long rangeBytesDone = countBytesDone;
        int chunkOffset = 0;
        while (chunkOffset < chunkSize) {
            int currRangeIdx = dataOp.currRangeIdx();
            if (!markedRangesMaskPair[0].get(currRangeIdx) && !markedRangesMaskPair[1].get(currRangeIdx)) {
                if (-1 == markedRangesMaskPair[0].nextSetBit(currRangeIdx) && -1 == markedRangesMaskPair[1].nextSetBit(currRangeIdx)) {
                    dataOp.countBytesDone(dataOp.markedRangesSize());
                    return;
                }
                dataOp.currRangeIdx(currRangeIdx + 1);
                continue;
            }
            DataItem currRange = dataOp.currRange();
            long rangeSize = dataItem.rangeSize(currRangeIdx);
            currRange.position(rangeBytesDone);
            int n = (int)Math.min((long)(chunkSize - chunkOffset), rangeSize - rangeBytesDone);
            ResponseContentUtil.verifyChunkData(currRange, chunkData, chunkOffset, n);
            chunkOffset += n;
            if ((rangeBytesDone += (long)n) == rangeSize) {
                if (-1 == markedRangesMaskPair[0].nextSetBit(currRangeIdx + 1) && -1 == markedRangesMaskPair[1].nextSetBit(currRangeIdx + 1)) {
                    dataOp.countBytesDone(dataOp.markedRangesSize());
                    return;
                }
                dataOp.currRangeIdx(currRangeIdx + 1);
                rangeBytesDone = 0L;
            }
            dataOp.countBytesDone(rangeBytesDone);
        }
    }

    private static void verifyChunkUpdatedData(DataOperation dataOp, DataItem item, long countBytesDone, ByteBuf chunkData, int chunkSize) throws DataCorruptionException, IOException {
        int remainingSize;
        for (int chunkCountDone = 0; chunkCountDone < chunkSize; chunkCountDone += remainingSize) {
            int currRangeIdx = dataOp.currRangeIdx();
            long nextRangeOffset = DataItem.rangeOffset((int)(currRangeIdx + 1));
            if (countBytesDone + (long)chunkCountDone == nextRangeOffset) {
                if (nextRangeOffset < item.size()) {
                    nextRangeOffset = DataItem.rangeOffset((int)(++currRangeIdx + 1));
                    dataOp.currRangeIdx(currRangeIdx);
                } else {
                    throw new DataSizeException(item.size(), countBytesDone + (long)chunkSize);
                }
            }
            DataItem currRange = dataOp.currRange();
            try {
                remainingSize = (int)Math.min((long)(chunkSize - chunkCountDone), nextRangeOffset - countBytesDone - (long)chunkCountDone);
                ResponseContentUtil.verifyChunkData(currRange, chunkData, chunkCountDone, remainingSize);
                continue;
            }
            catch (DataCorruptionException e) {
                throw new DataCorruptionException(DataItem.rangeOffset((int)dataOp.currRangeIdx()) + e.getOffset(), e.expected, e.actual);
            }
        }
    }

    private static void verifyChunkData(DataItem item, ByteBuf chunkData, int chunkOffset, int remainingSize) throws DataCorruptionException, IOException {
        int i;
        MappedByteBuffer bb = DirectMemUtil.getThreadLocalReusableBuff((long)remainingSize);
        ((ByteBuffer)bb).limit(remainingSize);
        for (int n = 0; n < remainingSize; n += item.read((ByteBuffer)bb)) {
        }
        ((ByteBuffer)bb).flip();
        ByteBuf buff = Unpooled.wrappedBuffer((ByteBuffer)bb);
        boolean fastEquals = true;
        int buffPos = 0;
        int chunkPos = chunkOffset;
        if (buff.writerIndex() - remainingSize < buffPos || chunkData.writerIndex() - remainingSize < chunkPos) {
            fastEquals = false;
        } else {
            int longCount = remainingSize >>> 3;
            int byteCount = remainingSize & 7;
            for (i = longCount; i > 0; --i) {
                if (buff.getLong(buffPos) != chunkData.getLong(chunkPos)) {
                    fastEquals = false;
                    break;
                }
                buffPos += 8;
                chunkPos += 8;
            }
            if (fastEquals) {
                for (i = byteCount; i > 0; --i) {
                    if (buff.getByte(buffPos) != chunkData.getByte(chunkPos)) {
                        fastEquals = false;
                        break;
                    }
                    ++buffPos;
                    ++chunkPos;
                }
            }
        }
        if (fastEquals) {
            buff.release();
            return;
        }
        for (i = 0; i < remainingSize; ++i) {
            byte actual;
            byte expected = buff.getByte(i);
            if (expected == (actual = chunkData.getByte(chunkOffset + i))) continue;
            buff.release();
            throw new DataCorruptionException((long)i, expected, actual);
        }
        buff.release();
    }
}

