/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.coop.netty;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.storage.driver.coop.netty.NettyStorageDriver;
import com.emc.mongoose.storage.driver.coop.netty.NettyStorageDriverBase;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.timeout.IdleStateEvent;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;

public abstract class ResponseHandlerBase<M, I extends Item, O extends Operation<I>>
extends SimpleChannelInboundHandler<M> {
    private static final String CLS_NAME = ResponseHandlerBase.class.getSimpleName();
    protected final NettyStorageDriverBase<I, O> driver;
    protected final boolean verifyFlag;

    protected ResponseHandlerBase(NettyStorageDriverBase<I, O> driver, boolean verifyFlag) {
        this.driver = driver;
        this.verifyFlag = verifyFlag;
    }

    @Override
    protected final void channelRead0(ChannelHandlerContext ctx, M msg) throws Exception {
        ThreadContext.put((String)"class_name", (String)CLS_NAME);
        Channel channel = ctx.channel();
        Operation op = channel.attr(NettyStorageDriver.ATTR_KEY_OPERATION).get();
        this.handle(channel, op, msg);
    }

    protected abstract void handle(Channel var1, O var2, M var3) throws IOException;

    @Override
    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws IOException {
        Channel channel = ctx.channel();
        Operation op = channel.attr(NettyStorageDriver.ATTR_KEY_OPERATION).get();
        if (op != null) {
            if (this.driver.isStarted() || this.driver.isShutdown()) {
                LogUtil.exception((Level)Level.WARN, (Throwable)cause, (String)"Premature channel closure", (Object[])new Object[0]);
                op.status(Operation.Status.FAIL_IO);
            } else if (cause instanceof PrematureChannelClosureException) {
                op.status(Operation.Status.INTERRUPTED);
            } else {
                LogUtil.exception((Level)Level.WARN, (Throwable)cause, (String)"Client handler failure", (Object[])new Object[0]);
                op.status(Operation.Status.FAIL_UNKNOWN);
            }
            if (!this.driver.isStopped()) {
                try {
                    this.driver.complete(channel, op);
                }
                catch (Exception e) {
                    Exceptions.throwUncheckedIfInterrupted((Throwable)e);
                    LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"Failed to complete the load operation", (Object[])new Object[0]);
                }
            }
        }
    }

    @Override
    public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            throw new SocketTimeoutException();
        }
    }
}

