/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.coop.netty.mock;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.item.DataItem;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.composite.data.CompositeDataOperation;
import com.emc.mongoose.base.item.op.data.DataOperation;
import com.emc.mongoose.base.storage.Credential;
import com.emc.mongoose.storage.driver.coop.netty.NettyStorageDriverBase;
import com.github.akurilov.commons.math.Random;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.netty.connection.pool.NonBlockingConnPool;
import com.github.akurilov.netty.connection.pool.mock.MultiNodeConnPoolMock;
import io.netty.channel.Channel;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class NettyStorageDriverMock<I extends Item, O extends Operation<I>>
extends NettyStorageDriverBase<I, O> {
    private final Random rnd = new Random();

    public NettyStorageDriverMock(String stepId, DataInput itemDataInput, Config storageConfig, boolean verifyFlag, int batchSize) throws IllegalConfigurationException, InterruptedException {
        super(stepId, itemDataInput, storageConfig, verifyFlag, batchSize);
    }

    @Override
    protected NonBlockingConnPool createConnectionPool() {
        return new MultiNodeConnPoolMock(this.storageNodeAddrs, this.bootstrap, this, this.storageNodePort, this.connAttemptsLimit);
    }

    @Override
    protected final void sendRequest(Channel channel, O op) {
        OpType opType = op.type();
        try {
            Item item;
            if (OpType.CREATE.equals((Object)opType)) {
                DataOperation dataOp;
                item = op.item();
                if (item instanceof DataItem && !((dataOp = (DataOperation)op) instanceof CompositeDataOperation)) {
                    DataItem dataItem = (DataItem)item;
                    dataOp.countBytesDone(dataItem.size());
                }
            } else if (OpType.UPDATE.equals((Object)opType) && (item = op.item()) instanceof DataItem) {
                DataItem dataItem = (DataItem)item;
                DataOperation dataOp = (DataOperation)op;
                List fixedRanges = dataOp.fixedRanges();
                if (fixedRanges == null || fixedRanges.isEmpty()) {
                    dataItem.commitUpdatedRanges(dataOp.markedRangesMaskPair());
                } else {
                    dataItem.size(dataItem.size() + dataOp.markedRangesSize());
                }
                dataOp.countBytesDone(dataOp.markedRangesSize());
            }
        }
        catch (IOException item) {
            // empty catch block
        }
        op.status(Operation.Status.SUCC);
        try {
            this.reqSentCallback.operationComplete(channel.newSucceededFuture());
        }
        catch (Exception e) {
            Exceptions.throwUncheckedIfInterrupted((Throwable)e);
            e.printStackTrace(System.err);
        }
        op.finishRequest();
        op.startResponse();
        this.complete(channel, op);
    }

    protected String requestNewPath(String path) {
        return path;
    }

    protected final String requestNewAuthToken(Credential credential) {
        return Long.toHexString(this.rnd.nextLong());
    }

    public final List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count) throws IOException {
        return Collections.emptyList();
    }
}

