/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.nio.base;

import com.emc.mongoose.common.concurrent.ThreadUtil;
import com.emc.mongoose.common.exception.UserShootHisFootException;
import com.emc.mongoose.model.NamingThreadFactory;
import com.emc.mongoose.model.io.task.IoTask;
import com.emc.mongoose.model.item.Item;
import com.emc.mongoose.model.storage.StorageDriver;
import com.emc.mongoose.storage.driver.base.StorageDriverBase;
import com.emc.mongoose.ui.config.Config;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.logging.log4j.Level;

public abstract class NioStorageDriverBase<I extends Item, O extends IoTask<I>>
extends StorageDriverBase<I, O>
implements StorageDriver<I, O> {
    private static final int MIN_TASK_BUFF_CAPACITY = 16384;
    private final ThreadPoolExecutor ioTaskExecutor;
    private final int ioWorkerCount;
    private final int ioTaskBuffCapacity;
    private final Runnable[] ioWorkerTasks;
    private final BlockingQueue<O>[] ioTaskQueues;

    public NioStorageDriverBase(String jobName, Config.LoadConfig loadConfig, Config.StorageConfig storageConfig, boolean verifyFlag) throws UserShootHisFootException {
        super(jobName, loadConfig, storageConfig, verifyFlag);
        int confWorkerCount = storageConfig.getDriverConfig().getIoConfig().getWorkers();
        this.ioWorkerCount = confWorkerCount < 1 ? Math.min(this.concurrencyLevel, ThreadUtil.getHardwareThreadCount()) : confWorkerCount;
        this.ioWorkerTasks = new Runnable[this.ioWorkerCount];
        this.ioTaskQueues = new BlockingQueue[this.ioWorkerCount];
        this.ioTaskBuffCapacity = Math.max(16384, this.concurrencyLevel / this.ioWorkerCount);
        for (int i = 0; i < this.ioWorkerCount; ++i) {
            this.ioTaskQueues[i] = new ArrayBlockingQueue<O>(this.ioTaskBuffCapacity);
            this.ioWorkerTasks[i] = new NioWorkerTask(this.ioTaskQueues[i]);
        }
        this.ioTaskExecutor = new ThreadPoolExecutor(this.ioWorkerCount, this.ioWorkerCount, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.ioWorkerCount), (ThreadFactory)new NamingThreadFactory(this.toString() + "/ioWorker", true));
    }

    protected abstract void invokeNio(O var1);

    protected final void doStart() throws IllegalStateException {
        super.doStart();
        for (Runnable ioWorkerTask : this.ioWorkerTasks) {
            this.ioTaskExecutor.execute(ioWorkerTask);
        }
    }

    protected final void doShutdown() throws IllegalStateException {
        this.ioTaskExecutor.shutdown();
    }

    protected final void doInterrupt() throws IllegalStateException {
        try {
            if (!this.ioTaskExecutor.awaitTermination(250L, TimeUnit.MILLISECONDS)) {
                Loggers.ERR.error("Failed to stop the remaining I/O tasks in 0.25 second");
            }
        }
        catch (InterruptedException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Unexpected interruption", (Object[])new Object[0]);
        }
        this.ioTaskExecutor.shutdownNow();
        assert (this.ioTaskExecutor.isTerminated());
        super.doInterrupt();
    }

    protected final boolean submit(O ioTask) throws InterruptedException {
        ioTask.reset();
        for (int i = 0; i < this.ioWorkerCount; ++i) {
            if (!this.isStarted()) {
                throw new InterruptedException();
            }
            if (this.ioTaskQueues[(int)(System.nanoTime() % (long)this.ioWorkerCount)].offer(ioTask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected final int submit(List<O> ioTasks, int from, int to) throws InterruptedException {
        int i = from;
        block0: while (i < to) {
            IoTask nextIoTask = (IoTask)ioTasks.get(i);
            nextIoTask.reset();
            for (int j = 0; j < this.ioWorkerCount; ++j) {
                if (!this.isStarted()) {
                    throw new InterruptedException();
                }
                if (!this.ioTaskQueues[(int)(System.nanoTime() % (long)this.ioWorkerCount)].offer(nextIoTask)) continue;
                ++i;
                continue block0;
            }
        }
        return i - from;
    }

    protected final int submit(List<O> ioTasks) throws InterruptedException {
        return this.submit(ioTasks, 0, ioTasks.size());
    }

    public final boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.ioTaskExecutor.awaitTermination(timeout, timeUnit);
    }

    protected void doClose() throws IOException {
        super.doClose();
        for (int i = 0; i < this.ioWorkerCount; ++i) {
            this.ioWorkerTasks[i] = null;
            this.ioTaskQueues[i].clear();
            this.ioTaskQueues[i] = null;
        }
    }

    private final class NioWorkerTask
    implements Runnable {
        private final List<O> ioTaskBuff;
        private final BlockingQueue<O> ioTaskQueue;

        public NioWorkerTask(BlockingQueue<O> ioTaskQueue) {
            this.ioTaskBuff = new ArrayList(NioStorageDriverBase.this.ioTaskBuffCapacity);
            this.ioTaskQueue = ioTaskQueue;
        }

        @Override
        public final void run() {
            IoTask ioTask;
            int ioTaskBuffSize;
            while (NioStorageDriverBase.this.isStarted() || NioStorageDriverBase.this.isShutdown()) {
                ioTaskBuffSize = this.ioTaskBuff.size();
                if (NioStorageDriverBase.this.isStarted() && ioTaskBuffSize < NioStorageDriverBase.this.ioTaskBuffCapacity) {
                    ioTaskBuffSize += this.ioTaskQueue.drainTo(this.ioTaskBuff, NioStorageDriverBase.this.ioTaskBuffCapacity - ioTaskBuffSize);
                }
                if (ioTaskBuffSize > 0) {
                    Iterator ioTaskIterator = this.ioTaskBuff.iterator();
                    while (ioTaskIterator.hasNext()) {
                        ioTask = (IoTask)ioTaskIterator.next();
                        if (IoTask.Status.PENDING.equals((Object)ioTask.getStatus())) {
                            if (!NioStorageDriverBase.this.isStarted()) {
                                ioTaskIterator.remove();
                                continue;
                            }
                            if (!NioStorageDriverBase.this.concurrencyThrottle.tryAcquire()) continue;
                            ioTask.startRequest();
                            ioTask.finishRequest();
                        }
                        NioStorageDriverBase.this.invokeNio(ioTask);
                        if (IoTask.Status.ACTIVE.equals((Object)ioTask.getStatus())) continue;
                        NioStorageDriverBase.this.concurrencyThrottle.release();
                        ioTaskIterator.remove();
                        NioStorageDriverBase.this.ioTaskCompleted(ioTask);
                    }
                    continue;
                }
                LockSupport.parkNanos(1L);
            }
            ioTaskBuffSize = this.ioTaskBuff.size();
            Loggers.MSG.debug("Finish {} remaining active tasks finally", (Object)ioTaskBuffSize);
            for (int i = 0; i < ioTaskBuffSize; ++i) {
                ioTask = (IoTask)this.ioTaskBuff.get(i);
                while (IoTask.Status.ACTIVE.equals((Object)ioTask.getStatus())) {
                    NioStorageDriverBase.this.invokeNio(ioTask);
                }
                NioStorageDriverBase.this.concurrencyThrottle.release();
                NioStorageDriverBase.this.ioTaskCompleted(ioTask);
            }
            Loggers.MSG.debug("Finish the remaining active tasks done");
        }
    }
}

