/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.coop.nio;

import com.emc.mongoose.base.Exceptions;
import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.storage.driver.coop.CoopStorageDriverBase;
import com.emc.mongoose.storage.driver.coop.nio.NioStorageDriver;
import com.github.akurilov.commons.collection.CircularArrayBuffer;
import com.github.akurilov.commons.collection.CircularBuffer;
import com.github.akurilov.commons.concurrent.ThreadUtil;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.fiber4j.ExclusiveFiberBase;
import com.github.akurilov.fiber4j.Fiber;
import com.github.akurilov.fiber4j.FibersExecutor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ThreadDumpMessage;

public abstract class NioStorageDriverBase<I extends Item, O extends Operation<I>>
extends CoopStorageDriverBase<I, O>
implements NioStorageDriver<I, O> {
    private static final String CLS_NAME = NioStorageDriverBase.class.getSimpleName();
    private static final FibersExecutor IO_EXECUTOR = new FibersExecutor(false);
    private final int ioWorkerCount;
    private final int opBuffCapacity;
    private final List<Fiber> ioFibers;
    private final CircularBuffer<O>[] opBuffs;
    private final Lock[] opBuffLocks;
    private final AtomicLong rrc = new AtomicLong(0L);

    public NioStorageDriverBase(String testStepId, DataInput dataInput, Config storageConfig, boolean verifyFlag, int batchSize) throws IllegalConfigurationException {
        super(testStepId, dataInput, storageConfig, verifyFlag, batchSize);
        int confWorkerCount = storageConfig.intVal("driver-threads");
        this.ioWorkerCount = confWorkerCount > 0 ? confWorkerCount : (this.concurrencyLimit > 0 ? Math.min(this.concurrencyLimit, ThreadUtil.getHardwareThreadCount()) : ThreadUtil.getHardwareThreadCount());
        this.ioFibers = new ArrayList<Fiber>(this.ioWorkerCount);
        this.opBuffs = new CircularBuffer[this.ioWorkerCount];
        this.opBuffLocks = new Lock[this.ioWorkerCount];
        this.opBuffCapacity = Math.max(4096, this.concurrencyLimit / this.ioWorkerCount);
        for (int i = 0; i < this.ioWorkerCount; ++i) {
            this.opBuffs[i] = new CircularArrayBuffer(this.opBuffCapacity);
            this.opBuffLocks[i] = new ReentrantLock();
            this.ioFibers.add((Fiber)new NioWorkerTask(IO_EXECUTOR, this.opBuffs[i], this.opBuffLocks[i]));
        }
    }

    protected abstract void invokeNio(O var1);

    protected final void doStart() throws IllegalStateException {
        super.doStart();
        for (Fiber ioFiber : this.ioFibers) {
            try {
                ioFiber.start();
            }
            catch (IOException iOException) {}
        }
    }

    protected final void doShutdown() throws IllegalStateException {
        super.doShutdown();
        for (Fiber ioFiber : this.ioFibers) {
            try {
                ioFiber.shutdown();
            }
            catch (IOException iOException) {}
        }
    }

    protected final void doStop() throws IllegalStateException {
        super.doStop();
        for (Fiber ioFiber : this.ioFibers) {
            try {
                ioFiber.stop();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean submit(O op) throws IllegalStateException {
        for (int i = 0; i < this.ioWorkerCount; ++i) {
            if (!this.isStarted()) {
                throw new IllegalStateException();
            }
            int j = (int)(this.rrc.getAndIncrement() % (long)this.ioWorkerCount);
            CircularBuffer<O> opBuff = this.opBuffs[j];
            Lock opBuffLock = this.opBuffLocks[j];
            if (opBuffLock.tryLock()) {
                try {
                    boolean bl = opBuff.size() < this.opBuffCapacity && opBuff.add(op);
                    return bl;
                }
                finally {
                    opBuffLock.unlock();
                }
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int submit(List<O> ops, int from, int to) throws IllegalStateException {
        int j = from;
        for (int i = 0; i < this.ioWorkerCount; ++i) {
            if (!this.isStarted()) {
                throw new IllegalStateException();
            }
            int m = (int)(this.rrc.getAndIncrement() % (long)this.ioWorkerCount);
            CircularBuffer<O> opBuff = this.opBuffs[m];
            Lock opBuffLock = this.opBuffLocks[m];
            if (!opBuffLock.tryLock()) continue;
            try {
                int n = Math.min(to - j, this.opBuffCapacity - opBuff.size());
                for (int k = 0; k < n; ++k) {
                    opBuff.add((Object)((Operation)ops.get(j + k)));
                }
                j += n;
                continue;
            }
            finally {
                opBuffLock.unlock();
            }
        }
        return j - from;
    }

    protected final int submit(List<O> ops) throws IllegalStateException {
        return this.submit(ops, 0, ops.size());
    }

    protected final void finishOperation(O op) {
        try {
            op.startResponse();
            op.finishResponse();
            op.status(Operation.Status.SUCC);
        }
        catch (IllegalStateException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"{}: finishing the load operation which is in an invalid state", (Object[])new Object[]{op.toString()});
            op.status(Operation.Status.FAIL_UNKNOWN);
        }
    }

    protected void doClose() throws IOException {
        this.ioFibers.forEach(fiber -> {
            try {
                fiber.close();
            }
            catch (Exception e) {
                LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to close the I/O fiber: {}", (Object[])new Object[]{fiber});
            }
        });
        this.ioFibers.clear();
        for (int i = 0; i < this.ioWorkerCount; ++i) {
            block14: {
                try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"class_name", (String)CLS_NAME);){
                    if (this.opBuffLocks[i].tryLock(10000000000L, TimeUnit.NANOSECONDS)) {
                        try {
                            this.opBuffs[i].clear();
                            break block14;
                        }
                        finally {
                            this.opBuffLocks[i].unlock();
                        }
                    }
                    if (this.opBuffs[i].size() > 0) {
                        Loggers.ERR.debug((Message)new ThreadDumpMessage("Failed to obtain the load operations buff lock in time"));
                    }
                }
                catch (InterruptedException e) {
                    com.github.akurilov.commons.lang.Exceptions.throwUnchecked((Throwable)e);
                }
            }
            this.opBuffs[i] = null;
        }
        super.doClose();
    }

    private final class NioWorkerTask
    extends ExclusiveFiberBase {
        private final CircularBuffer<O> opBuff;
        private final List<O> opLocalBuff;
        private int opBuffSize;
        private O op;

        public NioWorkerTask(FibersExecutor executor, CircularBuffer<O> opBuff, Lock opBuffLock) {
            super(executor, opBuffLock);
            this.opBuff = opBuff;
            this.opLocalBuff = new ArrayList(NioStorageDriverBase.this.opBuffCapacity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void invokeTimedExclusively(long startTimeNanos) {
            ThreadContext.put((String)"step_id", (String)NioStorageDriverBase.this.stepId);
            this.opBuffSize = this.opBuff.size();
            if (this.opBuffSize > 0) {
                int i;
                try {
                    for (i = 0; i < this.opBuffSize; ++i) {
                        this.op = (Operation)this.opBuff.get(i);
                        if (System.nanoTime() - startTimeNanos >= 10000000L) {
                            this.opLocalBuff.add(this.op);
                            continue;
                        }
                        if (Operation.Status.PENDING.equals((Object)this.op.status())) {
                            if (!this.isStarted()) continue;
                            if (!NioStorageDriverBase.this.concurrencyThrottle.tryAcquire()) {
                                this.opLocalBuff.add(this.op);
                                continue;
                            }
                            this.op.startRequest();
                            this.op.finishRequest();
                        }
                        NioStorageDriverBase.this.invokeNio(this.op);
                        if (!Operation.Status.ACTIVE.equals((Object)this.op.status())) {
                            NioStorageDriverBase.this.concurrencyThrottle.release();
                            NioStorageDriverBase.this.handleCompleted(this.op);
                            continue;
                        }
                        this.opLocalBuff.add(this.op);
                    }
                }
                catch (Throwable cause) {
                    Exceptions.throwUncheckedIfInterrupted((Throwable)cause);
                    LogUtil.exception((Level)Level.ERROR, (Throwable)cause, (String)"I/O worker failure", (Object[])new Object[0]);
                }
                finally {
                    this.opBuff.clear();
                    this.opBuffSize = this.opLocalBuff.size();
                    if (this.opBuffSize > 0) {
                        for (i = 0; i < this.opBuffSize; ++i) {
                            this.opBuff.add((Object)((Operation)this.opLocalBuff.get(i)));
                        }
                        this.opLocalBuff.clear();
                    }
                }
            }
        }

        protected final void doStop() {
            this.opBuffSize = this.opBuff.size();
            Loggers.MSG.debug("Finish {} remaining active load operations finally", (Object)this.opBuffSize);
            for (int i = 0; i < this.opBuffSize; ++i) {
                this.op = (Operation)this.opBuff.get(i);
                if (!Operation.Status.ACTIVE.equals((Object)this.op.status())) continue;
                this.op.status(Operation.Status.INTERRUPTED);
                NioStorageDriverBase.this.concurrencyThrottle.release();
                NioStorageDriverBase.this.handleCompleted(this.op);
            }
            Loggers.MSG.debug("Finish the remaining active load operations done");
        }

        protected final void doClose() {
            this.opBuff.clear();
        }
    }
}

