/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.preempt;

import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.logging.LogContextThreadFactory;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.base.storage.driver.StorageDriver;
import com.emc.mongoose.base.storage.driver.StorageDriverBase;
import com.github.akurilov.commons.lang.Exceptions;
import com.github.akurilov.confuse.Config;
import java.io.EOFException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class PreemptStorageDriverBase<I extends Item, O extends Operation<I>>
extends StorageDriverBase<I, O>
implements StorageDriver<I, O> {
    private final ThreadPoolExecutor ioExecutor;

    protected PreemptStorageDriverBase(String stepId, DataInput itemDataInput, Config storageConfig, boolean verifyFlag) throws IllegalConfigurationException {
        super(stepId, itemDataInput, storageConfig, verifyFlag);
        if (this.ioWorkerCount != this.concurrencyLimit) {
            throw new IllegalArgumentException("Storage driver I/O worker count (" + this.ioWorkerCount + ") should be equal to the  concurrency limit (" + this.concurrencyLimit + ")");
        }
        int inQueueSize = storageConfig.intVal("driver-limit-queue-input");
        this.ioExecutor = new ThreadPoolExecutor(this.ioWorkerCount, this.ioWorkerCount, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(inQueueSize), (ThreadFactory)new LogContextThreadFactory("io-executor-" + stepId, true));
    }

    public final boolean put(O op) {
        try {
            this.ioExecutor.execute(this.wrapToBlocking(op));
            return true;
        }
        catch (RejectedExecutionException e) {
            if (!this.isStarted() || this.ioExecutor.isShutdown() || this.ioExecutor.isTerminated()) {
                Exceptions.throwUnchecked((Throwable)new EOFException());
            }
            return false;
        }
    }

    public final int put(List<O> ops, int from, int to) {
        int i;
        if (!this.isStarted() || this.ioExecutor.isShutdown() || this.ioExecutor.isTerminated()) {
            Exceptions.throwUnchecked((Throwable)new EOFException());
        }
        try {
            for (i = from; i < to; ++i) {
                this.ioExecutor.execute(this.wrapToBlocking((Operation)ops.get(i)));
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return i - from;
    }

    public final int put(List<O> ops) {
        return this.put(ops, 0, ops.size());
    }

    private Runnable wrapToBlocking(O op) {
        if (this.prepare((Operation)op)) {
            return () -> {
                this.execute(op);
                this.handleCompleted((Operation)op);
            };
        }
        return () -> {
            op.status(Operation.Status.FAIL_UNKNOWN);
            this.handleCompleted((Operation)op);
        };
    }

    protected abstract void execute(O var1);

    public final int activeOpCount() {
        return this.ioExecutor.getActiveCount();
    }

    public final long scheduledOpCount() {
        return this.ioExecutor.getTaskCount();
    }

    public final long completedOpCount() {
        return this.ioExecutor.getCompletedTaskCount();
    }

    public final boolean isIdle() {
        return this.ioExecutor.getActiveCount() == 0;
    }

    protected void doStart() {
        this.ioExecutor.prestartAllCoreThreads();
        Loggers.MSG.debug("{}: started", (Object)this.toString());
    }

    protected void doShutdown() {
        this.ioExecutor.shutdown();
        this.ioExecutor.getQueue().clear();
        Loggers.MSG.debug("{}: shut down", (Object)this.toString());
    }

    protected void doStop() {
        Loggers.MSG.debug("{}: interrupting...", (Object)this.toString());
        try {
            if (this.ioExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                Loggers.MSG.debug("{}: interrupting finished in 1 seconds", (Object)this.toString());
            } else {
                Loggers.ERR.debug("{}: interrupting did not finish in 1 second, forcing", (Object)this.toString());
            }
        }
        catch (InterruptedException e) {
            this.ioExecutor.shutdownNow();
            Exceptions.throwUnchecked((Throwable)e);
        }
        finally {
            Loggers.MSG.debug("{}: interrupted", (Object)this.toString());
        }
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.ioExecutor.awaitTermination(timeout, timeUnit);
    }
}

