/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.preempt.mock;

import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.item.DataItem;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.ItemFactory;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.data.DataOperation;
import com.emc.mongoose.base.storage.Credential;
import com.emc.mongoose.storage.driver.preempt.PreemptStorageDriverBase;
import com.github.akurilov.commons.math.Random;
import com.github.akurilov.confuse.Config;
import java.io.IOException;
import java.util.List;

public class PreemptStorageDriverMock<I extends Item, O extends Operation<I>>
extends PreemptStorageDriverBase<I, O> {
    private final Random rnd = new Random();

    public PreemptStorageDriverMock(String stepId, DataInput itemDataInput, Config storageConfig, boolean verifyFlag) throws IllegalConfigurationException {
        super(stepId, itemDataInput, storageConfig, verifyFlag);
    }

    @Override
    protected void execute(O op) {
        op.startRequest();
        op.finishRequest();
        op.startResponse();
        if (op instanceof DataOperation) {
            DataOperation dataOp = (DataOperation)op;
            DataItem dataItem = dataOp.item();
            switch (dataOp.type()) {
                case CREATE: {
                    try {
                        dataOp.countBytesDone(dataItem.size());
                    }
                    catch (IOException iOException) {}
                    break;
                }
                case READ: {
                    dataOp.startDataResponse();
                    break;
                }
                case UPDATE: {
                    List fixedRanges = dataOp.fixedRanges();
                    if (fixedRanges == null || fixedRanges.isEmpty()) {
                        if (dataOp.hasMarkedRanges()) {
                            dataOp.countBytesDone(dataOp.markedRangesSize());
                            break;
                        }
                        try {
                            dataOp.countBytesDone(dataItem.size());
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    dataOp.countBytesDone(dataOp.markedRangesSize());
                    break;
                }
            }
        }
        op.finishResponse();
        op.status(Operation.Status.SUCC);
    }

    protected String requestNewPath(String path) {
        return path;
    }

    protected String requestNewAuthToken(Credential credential) {
        return Long.toHexString(this.rnd.nextLong());
    }

    public List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count) throws IOException {
        return null;
    }

    public void adjustIoBuffers(long avgTransferSize, OpType opType) {
    }
}

