/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.s3;

import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.composite.data.CompositeDataIoTask;
import com.emc.mongoose.api.model.io.task.partial.data.PartialDataIoTask;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.storage.driver.net.http.base.HttpResponseHandlerBase;
import com.emc.mongoose.storage.driver.s3.AmzS3Api;
import com.emc.mongoose.storage.driver.s3.AmzS3StorageDriver;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;

public final class AmzS3ResponseHandler<I extends Item, O extends IoTask<I>>
extends HttpResponseHandlerBase<I, O> {
    private static final AttributeKey<ByteBuf> CONTENT_ATTR_KEY = AttributeKey.newInstance((String)"content");
    private static final int MIN_CONTENT_SIZE = 256;
    private static final int MAX_CONTENT_SIZE = 1024;
    private static final Pattern PATTERN_UPLOAD_ID = Pattern.compile("<UploadId>([a-zA-Z\\d\\-_+=/]+)</UploadId>", 8);

    public AmzS3ResponseHandler(AmzS3StorageDriver<I, O> driver, boolean verifyFlag) {
        super(driver, verifyFlag);
    }

    protected final void handleResponseHeaders(O ioTask, HttpHeaders respHeaders) {
        if (ioTask instanceof PartialDataIoTask) {
            PartialDataIoTask subTask = (PartialDataIoTask)ioTask;
            String eTag = respHeaders.get((CharSequence)HttpHeaderNames.ETAG);
            CompositeDataIoTask mpuTask = subTask.getParent();
            mpuTask.put(Integer.toString(subTask.getPartNumber() + 1), eTag);
        }
    }

    protected final void handleResponseContentChunk(Channel channel, O ioTask, ByteBuf contentChunk) throws IOException {
        if (ioTask instanceof CompositeDataIoTask) {
            this.handleInitMultipartUploadResponseContentChunk(channel, contentChunk);
        } else {
            super.handleResponseContentChunk(channel, ioTask, contentChunk);
        }
    }

    private void handleInitMultipartUploadResponseContentChunk(Channel channel, ByteBuf contentChunk) {
        Attribute contentAttr = channel.attr(CONTENT_ATTR_KEY);
        contentAttr.compareAndSet(null, (Object)Unpooled.buffer((int)256));
        ByteBuf content = (ByteBuf)contentAttr.get();
        try {
            content.writeBytes(contentChunk);
        }
        catch (IndexOutOfBoundsException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"HTTP content input buffer overflow, expected no more than {} bytes", (Object[])new Object[]{1024});
        }
    }

    protected final void handleResponseContentFinish(Channel channel, O ioTask) {
        Attribute contentAttr = channel.attr(CONTENT_ATTR_KEY);
        ByteBuf content = (ByteBuf)contentAttr.get();
        if (content != null && content.readableBytes() > 0) {
            CompositeDataIoTask mpuIoTask;
            if (ioTask instanceof CompositeDataIoTask && !(mpuIoTask = (CompositeDataIoTask)ioTask).allSubTasksDone()) {
                String contentStr = content.toString(StandardCharsets.UTF_8);
                Matcher m = PATTERN_UPLOAD_ID.matcher(contentStr);
                if (m.find()) {
                    channel.attr(AmzS3Api.KEY_ATTR_UPLOAD_ID).set((Object)m.group(1));
                } else {
                    Loggers.ERR.warn("Upload id not found in the following response content:\n{}", (Object)contentStr);
                }
            }
            content.clear();
        }
        super.handleResponseContentFinish(channel, ioTask);
    }
}

