/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.s3;

import com.emc.mongoose.api.common.exception.OmgShootMyFootException;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.composite.data.CompositeDataIoTask;
import com.emc.mongoose.api.model.io.task.partial.data.PartialDataIoTask;
import com.emc.mongoose.api.model.item.DataItem;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.api.model.storage.Credential;
import com.emc.mongoose.storage.driver.net.http.base.HttpStorageDriverBase;
import com.emc.mongoose.storage.driver.s3.AmzS3Api;
import com.emc.mongoose.storage.driver.s3.AmzS3ResponseHandler;
import com.emc.mongoose.storage.driver.s3.BucketXmlListingHandler;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.Level;
import org.xml.sax.SAXException;

public class AmzS3StorageDriver<I extends Item, O extends IoTask<I>>
extends HttpStorageDriverBase<I, O> {
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final ThreadLocal<SAXParser> THREAD_LOCAL_XML_PARSER = new ThreadLocal();
    private static final ThreadLocal<StringBuilder> BUFF_CANONICAL = ThreadLocal.withInitial(StringBuilder::new);
    private static final ThreadLocal<StringBuilder> BUCKET_LIST_QUERY = ThreadLocal.withInitial(StringBuilder::new);
    private static final ThreadLocal<Map<String, Mac>> MAC_BY_SECRET = ThreadLocal.withInitial(HashMap::new);
    private static final Function<String, Mac> GET_MAC_BY_SECRET = secret -> {
        SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA1");
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKey);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    };
    private static final ThreadLocal<StringBuilder> THREAD_LOCAL_STRB = new ThreadLocal<StringBuilder>(){

        @Override
        protected final StringBuilder initialValue() {
            return new StringBuilder();
        }
    };

    public AmzS3StorageDriver(String stepId, DataInput itemDataInput, LoadConfig loadConfig, StorageConfig storageConfig, boolean verifyFlag) throws OmgShootMyFootException, InterruptedException {
        super(stepId, itemDataInput, loadConfig, storageConfig, verifyFlag);
        this.requestAuthTokenFunc = null;
    }

    protected String requestNewPath(String path) {
        DefaultFullHttpRequest putBucketVersioningReq;
        FullHttpResponse getBucketVersioningResp;
        FullHttpResponse checkBucketResp;
        String nodeAddr = this.storageNodeAddrs[0];
        DefaultHttpHeaders reqHeaders = new DefaultHttpHeaders();
        reqHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)nodeAddr);
        reqHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        reqHeaders.set((CharSequence)HttpHeaderNames.DATE, DATE_SUPPLIER.get());
        this.applyDynamicHeaders((HttpHeaders)reqHeaders);
        this.applySharedHeaders((HttpHeaders)reqHeaders);
        Credential credential = this.pathToCredMap.getOrDefault(path, this.credential);
        this.applyAuthHeaders((HttpHeaders)reqHeaders, HttpMethod.HEAD, path, credential);
        DefaultFullHttpRequest checkBucketReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.HEAD, path, Unpooled.EMPTY_BUFFER, (HttpHeaders)reqHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        try {
            checkBucketResp = this.executeHttpRequest((FullHttpRequest)checkBucketReq);
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
        catch (ConnectException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to connect to the storage node", (Object[])new Object[0]);
            return null;
        }
        boolean bucketExistedBefore = true;
        if (checkBucketResp != null) {
            if (HttpResponseStatus.NOT_FOUND.equals((Object)checkBucketResp.status())) {
                bucketExistedBefore = false;
            } else if (!HttpStatusClass.SUCCESS.equals((Object)checkBucketResp.status().codeClass())) {
                Loggers.ERR.warn("The bucket checking response is: {}", (Object)checkBucketResp.status().toString());
            }
            checkBucketResp.release();
        }
        if (!bucketExistedBefore) {
            FullHttpResponse putBucketResp;
            reqHeaders = new DefaultHttpHeaders();
            reqHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)nodeAddr);
            reqHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            reqHeaders.set((CharSequence)HttpHeaderNames.DATE, DATE_SUPPLIER.get());
            this.applyMetaDataHeaders((HttpHeaders)reqHeaders);
            this.applyAuthHeaders((HttpHeaders)reqHeaders, HttpMethod.PUT, path, credential);
            DefaultFullHttpRequest putBucketReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, path, Unpooled.EMPTY_BUFFER, (HttpHeaders)reqHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            try {
                putBucketResp = this.executeHttpRequest((FullHttpRequest)putBucketReq);
            }
            catch (InterruptedException e) {
                throw new CancellationException();
            }
            catch (ConnectException e) {
                LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to connect to the storage node", (Object[])new Object[0]);
                return null;
            }
            if (!HttpStatusClass.SUCCESS.equals((Object)putBucketResp.status().codeClass())) {
                Loggers.ERR.warn("The bucket creating response is: {}", (Object)putBucketResp.status().toString());
                return null;
            }
            putBucketResp.release();
        }
        String bucketVersioningReqUri = path + "?" + "versioning";
        reqHeaders = new DefaultHttpHeaders();
        reqHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)nodeAddr);
        reqHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        reqHeaders.set((CharSequence)HttpHeaderNames.DATE, DATE_SUPPLIER.get());
        this.applyAuthHeaders((HttpHeaders)reqHeaders, HttpMethod.GET, bucketVersioningReqUri, credential);
        DefaultFullHttpRequest getBucketVersioningReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, bucketVersioningReqUri, Unpooled.EMPTY_BUFFER, (HttpHeaders)reqHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        try {
            getBucketVersioningResp = this.executeHttpRequest((FullHttpRequest)getBucketVersioningReq);
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
        catch (ConnectException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to connect to the storage node", (Object[])new Object[0]);
            return null;
        }
        if (!HttpStatusClass.SUCCESS.equals((Object)getBucketVersioningResp.status().codeClass())) {
            Loggers.ERR.warn("The bucket versioning checking response is: {}", (Object)getBucketVersioningResp.status().toString());
            return null;
        }
        String content = getBucketVersioningResp.content().toString(StandardCharsets.US_ASCII);
        boolean versioningEnabled = content.contains("Enabled");
        getBucketVersioningResp.release();
        if (!this.versioning && versioningEnabled) {
            FullHttpResponse putBucketVersioningResp;
            reqHeaders = new DefaultHttpHeaders();
            reqHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)nodeAddr);
            reqHeaders.set((CharSequence)HttpHeaderNames.DATE, DATE_SUPPLIER.get());
            reqHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)AmzS3Api.VERSIONING_DISABLE_CONTENT.length);
            this.applyAuthHeaders((HttpHeaders)reqHeaders, HttpMethod.PUT, bucketVersioningReqUri, credential);
            putBucketVersioningReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, bucketVersioningReqUri, Unpooled.wrappedBuffer((byte[])AmzS3Api.VERSIONING_DISABLE_CONTENT).retain(), (HttpHeaders)reqHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            try {
                putBucketVersioningResp = this.executeHttpRequest((FullHttpRequest)putBucketVersioningReq);
            }
            catch (InterruptedException e) {
                throw new CancellationException();
            }
            catch (ConnectException e) {
                LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to connect to the storage node", (Object[])new Object[0]);
                return null;
            }
            if (!HttpStatusClass.SUCCESS.equals((Object)putBucketVersioningResp.status().codeClass())) {
                Loggers.ERR.warn("The bucket versioning setting response is: {}", (Object)putBucketVersioningResp.status().toString());
                putBucketVersioningResp.release();
                return null;
            }
            putBucketVersioningResp.release();
        } else if (this.versioning && !versioningEnabled) {
            FullHttpResponse putBucketVersioningResp;
            reqHeaders = new DefaultHttpHeaders();
            reqHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)nodeAddr);
            reqHeaders.set((CharSequence)HttpHeaderNames.DATE, DATE_SUPPLIER.get());
            reqHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)AmzS3Api.VERSIONING_ENABLE_CONTENT.length);
            this.applyAuthHeaders((HttpHeaders)reqHeaders, HttpMethod.PUT, bucketVersioningReqUri, credential);
            putBucketVersioningReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, bucketVersioningReqUri, Unpooled.wrappedBuffer((byte[])AmzS3Api.VERSIONING_ENABLE_CONTENT).retain(), (HttpHeaders)reqHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            try {
                putBucketVersioningResp = this.executeHttpRequest((FullHttpRequest)putBucketVersioningReq);
            }
            catch (InterruptedException e) {
                throw new CancellationException();
            }
            catch (ConnectException e) {
                LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to connect to the storage node", (Object[])new Object[0]);
                return null;
            }
            if (!HttpStatusClass.SUCCESS.equals((Object)putBucketVersioningResp.status().codeClass())) {
                Loggers.ERR.warn("The bucket versioning setting response is: {}", (Object)putBucketVersioningResp.status().toString());
                putBucketVersioningResp.release();
                return null;
            }
            putBucketVersioningResp.release();
        }
        return path;
    }

    protected final String requestNewAuthToken(Credential credential) {
        throw new AssertionError((Object)"Should not be invoked");
    }

    public final List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count) throws IOException {
        int countLimit = count < 1 || count > 1000 ? 1000 : count;
        String nodeAddr = this.storageNodeAddrs[0];
        DefaultHttpHeaders reqHeaders = new DefaultHttpHeaders();
        reqHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)nodeAddr);
        reqHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        reqHeaders.set((CharSequence)HttpHeaderNames.DATE, DATE_SUPPLIER.get());
        this.applyDynamicHeaders((HttpHeaders)reqHeaders);
        this.applySharedHeaders((HttpHeaders)reqHeaders);
        StringBuilder queryBuilder = BUCKET_LIST_QUERY.get();
        queryBuilder.setLength(0);
        queryBuilder.append(path).append('?');
        if (prefix != null && !prefix.isEmpty()) {
            queryBuilder.append("prefix=").append(prefix);
        }
        if (lastPrevItem != null) {
            String lastItemName;
            if ('?' != queryBuilder.charAt(queryBuilder.length() - 1)) {
                queryBuilder.append('&');
            }
            if ((lastItemName = lastPrevItem.getName()).contains("/")) {
                lastItemName = lastItemName.substring(lastItemName.lastIndexOf(47) + 1);
            }
            queryBuilder.append("marker=").append(lastItemName);
        }
        if ('?' != queryBuilder.charAt(queryBuilder.length() - 1)) {
            queryBuilder.append('&');
        }
        queryBuilder.append("max-keys=").append(countLimit);
        String query = queryBuilder.toString();
        this.applyAuthHeaders((HttpHeaders)reqHeaders, HttpMethod.GET, path, this.credential);
        DefaultFullHttpRequest checkBucketReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, query, Unpooled.EMPTY_BUFFER, (HttpHeaders)reqHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        ArrayList buff = new ArrayList(countLimit);
        try {
            FullHttpResponse listResp = this.executeHttpRequest((FullHttpRequest)checkBucketReq);
            ByteBuf listRespContent = listResp.content();
            SAXParser listRespParser = THREAD_LOCAL_XML_PARSER.get();
            if (listRespParser == null) {
                listRespParser = SAXParserFactory.newInstance().newSAXParser();
                THREAD_LOCAL_XML_PARSER.set(listRespParser);
            } else {
                listRespParser.reset();
            }
            BucketXmlListingHandler listingHandler = new BucketXmlListingHandler(buff, path, itemFactory, idRadix);
            try (ByteBufInputStream contentStream = new ByteBufInputStream(listRespContent);){
                listRespParser.parse((InputStream)contentStream, listingHandler);
            }
            listRespContent.release();
            if (buff.size() == 0) {
                throw new EOFException();
            }
            if (!listingHandler.isTruncated()) {
                buff.add(null);
            }
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
        catch (ParserConfigurationException | SAXException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to init the XML response parser", (Object[])new Object[0]);
        }
        catch (ConnectException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to connect to the storage node", (Object[])new Object[0]);
        }
        return buff;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected HttpRequest getHttpRequest(O ioTask, String nodeAddr) throws URISyntaxException {
        void var3_10;
        IoType ioType = ioTask.getIoType();
        if (ioTask instanceof CompositeDataIoTask) {
            if (!IoType.CREATE.equals((Object)ioType)) throw new AssertionError((Object)"Non-create multipart operations are not implemented yet");
            CompositeDataIoTask mpuTask = (CompositeDataIoTask)ioTask;
            if (mpuTask.allSubTasksDone()) {
                FullHttpRequest fullHttpRequest = this.getCompleteMpuRequest(mpuTask, nodeAddr);
                return var3_10;
            } else {
                HttpRequest httpRequest = this.getInitMpuRequest(ioTask, nodeAddr);
            }
            return var3_10;
        } else if (ioTask instanceof PartialDataIoTask) {
            if (!IoType.CREATE.equals((Object)ioType)) throw new AssertionError((Object)"Non-create multipart operations are not implemented yet");
            HttpRequest httpRequest = this.getUploadPartRequest((PartialDataIoTask)ioTask, nodeAddr);
            return var3_10;
        } else {
            HttpRequest httpRequest = super.getHttpRequest(ioTask, nodeAddr);
        }
        return var3_10;
    }

    protected final HttpMethod getTokenHttpMethod(IoType ioType) {
        throw new AssertionError((Object)"Not implemented yet");
    }

    protected final HttpMethod getPathHttpMethod(IoType ioType) {
        switch (ioType) {
            case UPDATE: {
                throw new AssertionError((Object)"Not implemnted yet");
            }
            case READ: {
                return HttpMethod.GET;
            }
            case DELETE: {
                return HttpMethod.DELETE;
            }
        }
        return HttpMethod.PUT;
    }

    protected final String getTokenUriPath(I item, String srcPath, String dstPath, IoType ioType) {
        throw new AssertionError((Object)"Not implemented");
    }

    protected final String getPathUriPath(I item, String srcPath, String dstPath, IoType ioType) {
        String itemName = item.getName();
        if (itemName.startsWith("/")) {
            return itemName;
        }
        return "/" + itemName;
    }

    protected void applyMetaDataHeaders(HttpHeaders httpHeaders) {
    }

    private HttpRequest getInitMpuRequest(O ioTask, String nodeAddr) {
        Item item = ioTask.getItem();
        String srcPath = ioTask.getSrcPath();
        if (srcPath != null && !srcPath.isEmpty()) {
            throw new AssertionError((Object)"Multipart copy operation is not implemented yet");
        }
        String uriPath = this.getDataUriPath(item, srcPath, ioTask.getDstPath(), IoType.CREATE) + "?uploads";
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        if (nodeAddr != null) {
            httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)nodeAddr);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.DATE, DATE_SUPPLIER.get());
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        HttpMethod httpMethod = HttpMethod.POST;
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uriPath, (HttpHeaders)httpHeaders);
        this.applyMetaDataHeaders((HttpHeaders)httpHeaders);
        this.applyDynamicHeaders((HttpHeaders)httpHeaders);
        this.applySharedHeaders((HttpHeaders)httpHeaders);
        this.applyAuthHeaders((HttpHeaders)httpHeaders, httpMethod, uriPath, ioTask.getCredential());
        return httpRequest;
    }

    private HttpRequest getUploadPartRequest(PartialDataIoTask ioTask, String nodeAddr) {
        DataItem item = ioTask.getItem();
        String srcPath = ioTask.getSrcPath();
        String uriPath = this.getDataUriPath((Item)item, srcPath, ioTask.getDstPath(), IoType.CREATE) + "?partNumber=" + (ioTask.getPartNumber() + 1) + "&uploadId=" + ioTask.getParent().get("uploadId");
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        if (nodeAddr != null) {
            httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)nodeAddr);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.DATE, DATE_SUPPLIER.get());
        HttpMethod httpMethod = HttpMethod.PUT;
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uriPath, (HttpHeaders)httpHeaders);
        try {
            httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)item.size());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.applyMetaDataHeaders((HttpHeaders)httpHeaders);
        this.applyDynamicHeaders((HttpHeaders)httpHeaders);
        this.applySharedHeaders((HttpHeaders)httpHeaders);
        this.applyAuthHeaders((HttpHeaders)httpHeaders, httpMethod, uriPath, ioTask.getCredential());
        return httpRequest;
    }

    private FullHttpRequest getCompleteMpuRequest(CompositeDataIoTask mpuTask, String nodeAddr) {
        StringBuilder content = THREAD_LOCAL_STRB.get();
        content.setLength(0);
        content.append("<CompleteMultipartUpload>\n");
        List subTasks = mpuTask.getSubTasks();
        for (PartialDataIoTask subTask : subTasks) {
            int nextPartNum = subTask.getPartNumber() + 1;
            String nextEtag = mpuTask.get(Integer.toString(nextPartNum));
            content.append("\t<Part>\n\t\t<PartNumber>").append(nextPartNum).append("</PartNumber>\n\t\t<ETag>").append(nextEtag).append("</ETag>\n\t</Part>\n");
        }
        content.append("</CompleteMultipartUpload>");
        String srcPath = mpuTask.getSrcPath();
        Item item = mpuTask.getItem();
        String uploadId = mpuTask.get("uploadId");
        String uriPath = this.getDataUriPath(item, srcPath, mpuTask.getDstPath(), IoType.CREATE) + "?uploadId=" + uploadId;
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)nodeAddr);
        httpHeaders.set((CharSequence)HttpHeaderNames.DATE, DATE_SUPPLIER.get());
        HttpMethod httpMethod = HttpMethod.POST;
        String contentStr = content.toString();
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uriPath, Unpooled.wrappedBuffer((byte[])contentStr.getBytes()), (HttpHeaders)httpHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.length());
        this.applyMetaDataHeaders((HttpHeaders)httpHeaders);
        this.applyDynamicHeaders((HttpHeaders)httpHeaders);
        this.applySharedHeaders((HttpHeaders)httpHeaders);
        this.applyAuthHeaders((HttpHeaders)httpHeaders, httpMethod, uriPath, mpuTask.getCredential());
        return httpRequest;
    }

    public void complete(Channel channel, O ioTask) {
        if (channel != null && ioTask instanceof CompositeDataIoTask) {
            CompositeDataIoTask compositeIoTask = (CompositeDataIoTask)ioTask;
            if (compositeIoTask.allSubTasksDone()) {
                Loggers.MULTIPART.info("{},{},{}", (Object)compositeIoTask.getItem().getName(), (Object)compositeIoTask.get("uploadId"), (Object)compositeIoTask.getLatency());
            } else {
                String uploadId = (String)channel.attr(AmzS3Api.KEY_ATTR_UPLOAD_ID).get();
                if (uploadId == null) {
                    ioTask.setStatus(IoTask.Status.RESP_FAIL_NOT_FOUND);
                } else {
                    compositeIoTask.put("uploadId", uploadId);
                }
            }
        }
        super.complete(channel, ioTask);
    }

    protected final void appendHandlers(ChannelPipeline pipeline) {
        super.appendHandlers(pipeline);
        pipeline.addLast(new ChannelHandler[]{new AmzS3ResponseHandler(this, this.verifyFlag)});
    }

    protected final void applyCopyHeaders(HttpHeaders httpHeaders, String srcPath) throws URISyntaxException {
        httpHeaders.set("x-amz-copy-source", (Object)srcPath);
    }

    protected final void applyAuthHeaders(HttpHeaders httpHeaders, HttpMethod httpMethod, String dstUriPath, Credential credential) {
        String secret;
        String uid;
        if (credential != null) {
            uid = credential.getUid();
            secret = credential.getSecret();
        } else if (this.credential != null) {
            uid = this.credential.getUid();
            secret = this.credential.getSecret();
        } else {
            return;
        }
        if (uid == null || secret == null) {
            return;
        }
        Mac mac = MAC_BY_SECRET.get().computeIfAbsent(secret, GET_MAC_BY_SECRET);
        String canonicalForm = this.getCanonical(httpHeaders, httpMethod, dstUriPath);
        byte[] sigData = mac.doFinal(canonicalForm.getBytes());
        httpHeaders.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)("AWS " + uid + ':' + BASE64_ENCODER.encodeToString(sigData)));
    }

    protected String getCanonical(HttpHeaders httpHeaders, HttpMethod httpMethod, String dstUriPath) {
        String headerName;
        StringBuilder buffCanonical = BUFF_CANONICAL.get();
        buffCanonical.setLength(0);
        buffCanonical.append(httpMethod.name());
        for (AsciiString headerName2 : AmzS3Api.HEADERS_CANONICAL) {
            if (httpHeaders.contains((CharSequence)headerName2)) {
                for (String headerValue : httpHeaders.getAll((CharSequence)headerName2)) {
                    buffCanonical.append('\n').append(headerValue);
                }
                continue;
            }
            if (this.sharedHeaders != null && this.sharedHeaders.contains((CharSequence)headerName2)) {
                buffCanonical.append('\n').append(this.sharedHeaders.get((CharSequence)headerName2));
                continue;
            }
            buffCanonical.append('\n');
        }
        TreeMap sortedHeaders = new TreeMap();
        if (this.sharedHeaders != null) {
            for (Map.Entry header : this.sharedHeaders) {
                headerName = ((String)header.getKey()).toLowerCase();
                if (!headerName.startsWith("x-amz-")) continue;
                sortedHeaders.put(headerName, header.getValue());
            }
        }
        for (Map.Entry header : httpHeaders) {
            headerName = ((String)header.getKey()).toLowerCase();
            if (!headerName.startsWith("x-amz-")) continue;
            sortedHeaders.put(headerName, header.getValue());
        }
        for (Map.Entry sortedHeader : sortedHeaders.entrySet()) {
            buffCanonical.append('\n').append((String)sortedHeader.getKey()).append(':').append((String)sortedHeader.getValue());
        }
        buffCanonical.append('\n');
        buffCanonical.append(dstUriPath);
        if (Loggers.MSG.isTraceEnabled()) {
            Loggers.MSG.trace("Canonical representation:\n{}", (Object)buffCanonical);
        }
        return buffCanonical.toString();
    }

    public String toString() {
        return String.format(super.toString(), "amzs3");
    }
}

