/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.s3;

import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class BucketXmlListingHandler<I extends Item>
extends DefaultHandler {
    private int count = 0;
    private boolean isInsideItem = false;
    private boolean itIsItemId = false;
    private boolean itIsItemSize = false;
    private boolean itIsTruncateFlag = false;
    private boolean isTruncatedFlag = false;
    private String oid = null;
    private String strSize = null;
    private long offset;
    private I nextItem;
    private final List<I> itemsBuffer;
    private final String path;
    private final ItemFactory<I> itemFactory;
    private final int idRadix;

    public BucketXmlListingHandler(List<I> itemsBuffer, String path, ItemFactory<I> itemFactory, int idRadix) {
        this.itemsBuffer = itemsBuffer;
        this.path = path == null ? "" : (path.endsWith("/") ? path : path + "/");
        this.itemFactory = itemFactory;
        this.idRadix = idRadix;
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.isInsideItem = this.isInsideItem || "Contents".equals(qName);
        this.itIsItemId = this.isInsideItem && "Key".equals(qName);
        this.itIsItemSize = this.isInsideItem && "Size".equals(qName);
        this.itIsTruncateFlag = "IsTruncated".equals(qName);
        super.startElement(uri, localName, qName, attrs);
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        this.itIsItemId = this.itIsItemId && !"Key".equals(qName);
        this.itIsItemSize = this.itIsItemSize && !"Size".equals(qName);
        boolean bl = this.itIsTruncateFlag = this.itIsTruncateFlag && !"IsTruncated".equals(qName);
        if (this.isInsideItem && "Contents".equals(qName)) {
            this.isInsideItem = false;
            long size = -1L;
            if (this.strSize != null && this.strSize.length() > 0) {
                try {
                    size = Long.parseLong(this.strSize);
                }
                catch (NumberFormatException e) {
                    LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Data object size should be a 64 bit number", (Object[])new Object[0]);
                }
            } else {
                Loggers.ERR.trace("No \"{}\" element or empty", (Object)"Size");
            }
            if (this.oid != null && this.oid.length() > 0 && size > -1L) {
                try {
                    this.offset = Long.parseLong(this.oid, this.idRadix);
                }
                catch (NumberFormatException e) {
                    LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to parse the item id \"{}\"", (Object[])new Object[]{this.oid});
                    this.offset = 0L;
                }
                this.nextItem = this.itemFactory.getItem(this.path + this.oid, this.offset, size);
                this.itemsBuffer.add(this.nextItem);
                ++this.count;
            } else {
                Loggers.ERR.trace("Invalid object id ({}) or size ({})", (Object)this.oid, (Object)this.strSize);
            }
        }
        super.endElement(uri, localName, qName);
    }

    @Override
    public final void characters(char[] buff, int start, int length) throws SAXException {
        if (this.itIsItemId) {
            this.oid = new String(buff, start, length);
        } else if (this.itIsItemSize) {
            this.strSize = new String(buff, start, length);
        } else if (this.itIsTruncateFlag) {
            this.isTruncatedFlag = Boolean.parseBoolean(new String(buff, start, length));
        }
        super.characters(buff, start, length);
    }

    public final boolean isTruncated() {
        return this.isTruncatedFlag;
    }
}

