/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.base;

import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.storage.driver.base.StorageDriverBase;
import com.emc.mongoose.ui.log.LogUtil;
import com.github.akurilov.commons.collection.OptLockArrayBuffer;
import com.github.akurilov.commons.collection.OptLockBuffer;
import com.github.akurilov.coroutines.CoroutinesProcessor;
import com.github.akurilov.coroutines.ExclusiveCoroutineBase;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;

public final class IoTasksDispatchCoroutine<I extends Item, O extends IoTask<I>>
extends ExclusiveCoroutineBase {
    private static final String CLS_NAME = IoTasksDispatchCoroutine.class.getSimpleName();
    private final String stepId;
    private final int batchSize;
    private final BlockingQueue<O> childTasksQueue;
    private final BlockingQueue<O> inTasksQueue;
    private final StorageDriverBase<I, O> storageDriver;
    private final OptLockBuffer<O> buff;
    private int n = 0;
    private int m;

    public IoTasksDispatchCoroutine(CoroutinesProcessor coroutinesProcessor, StorageDriverBase<I, O> storageDriver, BlockingQueue<O> inTasksQueue, BlockingQueue<O> childTasksQueue, String stepId, int batchSize) {
        this(coroutinesProcessor, (OptLockBuffer<O>)new OptLockArrayBuffer(batchSize), storageDriver, inTasksQueue, childTasksQueue, stepId, batchSize);
    }

    private IoTasksDispatchCoroutine(CoroutinesProcessor coroutinesProcessor, OptLockBuffer<O> buff, StorageDriverBase<I, O> storageDriver, BlockingQueue<O> inTasksQueue, BlockingQueue<O> childTasksQueue, String stepId, int batchSize) {
        super(coroutinesProcessor, buff);
        this.storageDriver = storageDriver;
        this.inTasksQueue = inTasksQueue;
        this.childTasksQueue = childTasksQueue;
        this.stepId = stepId;
        this.batchSize = batchSize;
        this.buff = buff;
    }

    protected final void invokeTimedExclusively(long startTimeNanos) {
        ThreadContext.put((String)"stepId", (String)this.stepId);
        ThreadContext.put((String)"className", (String)CLS_NAME);
        try {
            if (this.n < this.batchSize) {
                this.n += this.childTasksQueue.drainTo((Collection<O>)this.buff, this.batchSize - this.n);
            }
            if (100000000L <= System.nanoTime() - startTimeNanos) {
                return;
            }
            if (this.n < this.batchSize) {
                this.n += this.inTasksQueue.drainTo((Collection<O>)this.buff, this.batchSize - this.n);
            }
            if (100000000L <= System.nanoTime() - startTimeNanos) {
                return;
            }
            if (this.n > 0) {
                if (this.n == 1) {
                    if (this.storageDriver.submit((IoTask)this.buff.get(0))) {
                        this.buff.clear();
                        --this.n;
                    }
                } else {
                    this.m = this.storageDriver.submit((List<O>)this.buff, 0, this.n);
                    if (this.m > 0) {
                        this.buff.removeRange(0, this.m);
                        this.n -= this.m;
                    }
                }
            }
        }
        catch (IllegalStateException e) {
            LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"{}: failed to submit some I/O tasks due to the illegal storage driver state ({})", (Object[])new Object[]{this.storageDriver.toString(), this.storageDriver.getState()});
        }
    }

    protected final void doClose() {
        this.buff.clear();
    }
}

