/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.base;

import com.emc.mongoose.api.common.exception.OmgDoesNotPerformException;
import com.emc.mongoose.api.common.exception.OmgShootMyFootException;
import com.emc.mongoose.api.model.concurrent.DaemonBase;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.composite.CompositeIoTask;
import com.emc.mongoose.api.model.io.task.data.DataIoTask;
import com.emc.mongoose.api.model.io.task.partial.PartialIoTask;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.api.model.storage.Credential;
import com.emc.mongoose.api.model.storage.StorageDriver;
import com.emc.mongoose.storage.driver.base.AsyncCurrentDateSupplier;
import com.emc.mongoose.storage.driver.base.IoTasksDispatchCoroutine;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.storage.auth.AuthConfig;
import com.emc.mongoose.ui.config.storage.driver.queue.QueueConfig;
import com.emc.mongoose.ui.log.Loggers;
import com.github.akurilov.commons.io.Input;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.apache.logging.log4j.CloseableThreadContext;

public abstract class StorageDriverBase<I extends Item, O extends IoTask<I>>
extends DaemonBase
implements StorageDriver<I, O> {
    public static AsyncCurrentDateSupplier DATE_SUPPLIER = null;
    private final DataInput itemDataInput;
    private final int batchSize;
    private final int outputQueueCapacity;
    protected final BlockingQueue<O> childTasksQueue;
    private final BlockingQueue<O> inTasksQueue;
    private final BlockingQueue<O> ioResultsQueue;
    protected final String stepId;
    protected final int concurrencyLevel;
    protected final Semaphore concurrencyThrottle;
    protected final Credential credential;
    protected final boolean verifyFlag;
    private final LongAdder scheduledTaskCount = new LongAdder();
    private final LongAdder completedTaskCount = new LongAdder();
    protected final ConcurrentMap<String, Credential> pathToCredMap = new ConcurrentHashMap<String, Credential>(1);
    private final ConcurrentMap<String, String> pathMap = new ConcurrentHashMap<String, String>(1);
    protected Function<String, String> requestNewPathFunc = this::requestNewPath;
    protected final ConcurrentMap<Credential, String> authTokens = new ConcurrentHashMap<Credential, String>(1);
    protected Function<Credential, String> requestAuthTokenFunc = this::requestNewAuthToken;
    private final IoTasksDispatchCoroutine ioTasksDispatchCoroutine;

    protected abstract String requestNewPath(String var1);

    protected abstract String requestNewAuthToken(Credential var1);

    protected StorageDriverBase(String stepId, DataInput itemDataInput, LoadConfig loadConfig, StorageConfig storageConfig, boolean verifyFlag) throws OmgShootMyFootException {
        this.itemDataInput = itemDataInput;
        this.batchSize = loadConfig.getBatchConfig().getSize();
        QueueConfig queueConfig = storageConfig.getDriverConfig().getQueueConfig();
        this.outputQueueCapacity = queueConfig.getOutput();
        this.childTasksQueue = new ArrayBlockingQueue<O>(queueConfig.getInput());
        this.inTasksQueue = new ArrayBlockingQueue<O>(queueConfig.getInput());
        this.ioResultsQueue = new ArrayBlockingQueue<O>(this.outputQueueCapacity);
        this.stepId = stepId;
        AuthConfig authConfig = storageConfig.getAuthConfig();
        this.credential = Credential.getInstance((String)authConfig.getUid(), (String)authConfig.getSecret());
        String authToken = authConfig.getToken();
        if (authToken != null) {
            if (this.credential == null) {
                this.authTokens.put(Credential.NONE, authToken);
            } else {
                this.authTokens.put(this.credential, authToken);
            }
        }
        this.concurrencyLevel = loadConfig.getLimitConfig().getConcurrency();
        this.concurrencyThrottle = this.concurrencyLevel > 0 ? new Semaphore(this.concurrencyLevel, true) : new Semaphore(Integer.MAX_VALUE, false);
        this.verifyFlag = verifyFlag;
        this.ioTasksDispatchCoroutine = new IoTasksDispatchCoroutine(SVC_EXECUTOR, this, this.inTasksQueue, this.childTasksQueue, stepId, this.batchSize);
    }

    protected void doStart() throws IllegalStateException {
        this.ioTasksDispatchCoroutine.start();
    }

    public final boolean put(O task) throws EOFException, ServerException {
        if (!this.isStarted()) {
            throw new EOFException();
        }
        this.prepareIoTask(task);
        if (this.inTasksQueue.offer(task)) {
            this.scheduledTaskCount.increment();
            return true;
        }
        return false;
    }

    public final int put(List<O> tasks, int from, int to) throws EOFException, ServerException {
        int i;
        if (!this.isStarted()) {
            throw new EOFException();
        }
        for (i = from; i < to && this.isStarted(); ++i) {
            IoTask nextTask = (IoTask)tasks.get(i);
            this.prepareIoTask(nextTask);
            if (!this.inTasksQueue.offer(tasks.get(i))) break;
        }
        int n = i - from;
        this.scheduledTaskCount.add(n);
        return n;
    }

    public final int put(List<O> tasks) throws EOFException, ServerException {
        if (!this.isStarted()) {
            throw new EOFException();
        }
        int n = 0;
        for (IoTask nextIoTask : tasks) {
            if (!this.isStarted()) break;
            this.prepareIoTask(nextIoTask);
            if (!this.inTasksQueue.offer(nextIoTask)) break;
            ++n;
        }
        this.scheduledTaskCount.add(n);
        return n;
    }

    protected void prepareIoTask(O ioTask) throws ServerException {
        ioTask.reset();
        if (ioTask instanceof DataIoTask) {
            ((DataIoTask)ioTask).getItem().setDataInput(this.itemDataInput);
        }
        String dstPath = ioTask.getDstPath();
        Credential credential = ioTask.getCredential();
        if (credential != null) {
            this.pathToCredMap.putIfAbsent(dstPath == null ? "" : dstPath, credential);
            if (this.requestAuthTokenFunc != null) {
                this.authTokens.computeIfAbsent(credential, this.requestAuthTokenFunc);
            }
        }
        if (this.requestNewPathFunc != null && dstPath != null && !dstPath.isEmpty() && null == this.pathMap.computeIfAbsent(dstPath, this.requestNewPathFunc)) {
            Loggers.ERR.debug("Failed to compute the destination path for the I/O task {}", ioTask);
            ioTask.setStatus(IoTask.Status.FAIL_UNKNOWN);
        }
    }

    public final int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public final int getActiveTaskCount() {
        if (this.concurrencyLevel > 0) {
            return this.concurrencyLevel - this.concurrencyThrottle.availablePermits();
        }
        return Integer.MAX_VALUE - this.concurrencyThrottle.availablePermits();
    }

    public final long getScheduledTaskCount() {
        return this.scheduledTaskCount.sum();
    }

    public final long getCompletedTaskCount() {
        return this.completedTaskCount.sum();
    }

    public final boolean isIdle() {
        if (this.concurrencyLevel > 0) {
            return !this.concurrencyThrottle.hasQueuedThreads() && this.concurrencyThrottle.availablePermits() >= this.concurrencyLevel;
        }
        return this.concurrencyThrottle.availablePermits() == Integer.MAX_VALUE;
    }

    public final O get() {
        return (O)((IoTask)this.ioResultsQueue.poll());
    }

    public final List<O> getAll() {
        int n = this.ioResultsQueue.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList ioTaskResults = new ArrayList(n);
        this.ioResultsQueue.drainTo(ioTaskResults, n);
        return ioTaskResults;
    }

    public final long skip(long count) {
        int n = (int)Math.min(count, Integer.MAX_VALUE);
        ArrayList tmpBuff = new ArrayList(n);
        n = this.ioResultsQueue.drainTo(tmpBuff, n);
        tmpBuff.clear();
        return n;
    }

    protected final void ioTaskCompleted(O ioTask) {
        PartialIoTask subTask;
        CompositeIoTask parentTask;
        IoTask ioTaskResult;
        this.completedTaskCount.increment();
        if (Loggers.MSG.isTraceEnabled()) {
            Loggers.MSG.trace("{}: I/O task completed", ioTask);
        }
        if (!this.ioResultsQueue.offer(ioTaskResult = ioTask.getResult())) {
            Loggers.ERR.warn("{}: I/O task results queue overflow, dropping the result", (Object)this.toString());
        }
        if (ioTask instanceof CompositeIoTask) {
            CompositeIoTask parentTask2 = (CompositeIoTask)ioTask;
            if (!parentTask2.allSubTasksDone()) {
                List subTasks = parentTask2.getSubTasks();
                for (IoTask nextSubTask : subTasks) {
                    if (this.childTasksQueue.offer(nextSubTask)) continue;
                    Loggers.ERR.warn("{}: I/O child tasks queue overflow, dropping the I/O sub-task", (Object)this.toString());
                    break;
                }
            }
        } else if (ioTask instanceof PartialIoTask && (parentTask = (subTask = (PartialIoTask)ioTask).getParent()).allSubTasksDone() && !this.childTasksQueue.offer(parentTask)) {
            Loggers.ERR.warn("{}: I/O child tasks queue overflow, dropping the I/O task", (Object)this.toString());
        }
    }

    protected abstract boolean submit(O var1) throws IllegalStateException;

    protected abstract int submit(List<O> var1, int var2, int var3) throws IllegalStateException;

    protected abstract int submit(List<O> var1) throws IllegalStateException;

    public Input<O> getInput() {
        return this;
    }

    protected void doShutdown() {
        this.ioTasksDispatchCoroutine.stop();
        Loggers.MSG.debug("{}: shut down", (Object)this.toString());
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return false;
    }

    protected void doClose() throws IOException, IllegalStateException {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"stepId", (String)this.stepId).put("className", StorageDriverBase.class.getSimpleName());){
            this.ioTasksDispatchCoroutine.close();
            this.itemDataInput.close();
            this.childTasksQueue.clear();
            this.inTasksQueue.clear();
            int ioResultsQueueSize = this.ioResultsQueue.size();
            if (ioResultsQueueSize > 0) {
                Loggers.ERR.warn("{}: I/O results queue contains {} unhandled elements", (Object)this.toString(), (Object)ioResultsQueueSize);
            }
            this.ioResultsQueue.clear();
            this.authTokens.clear();
            this.pathToCredMap.clear();
            this.pathMap.clear();
            Loggers.MSG.debug("{}: closed", (Object)this.toString());
        }
    }

    public String toString() {
        return "storage/driver/" + this.concurrencyLevel + "/%s/" + ((Object)((Object)this)).hashCode();
    }

    static {
        try {
            DATE_SUPPLIER = new AsyncCurrentDateSupplier(SVC_EXECUTOR);
        }
        catch (OmgDoesNotPerformException e) {
            e.printStackTrace(System.err);
        }
    }
}

