/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.perf;

import com.emc.mongoose.common.concurrent.RateThrottle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.Test;

public class RateThrottleTest {
    @Test
    public void testRate100mHzNonBatch() throws Exception {
        double rateLimit = 0.1;
        int timeLimitSec = 50;
        RateThrottle throttle = new RateThrottle(0.1);
        Object subj = new Object();
        LongAdder counter = new LongAdder();
        Thread submThread = new Thread(() -> {
            while (true) {
                if (throttle.tryAcquire(subj)) {
                    counter.increment();
                    continue;
                }
                LockSupport.parkNanos(1L);
            }
        });
        submThread.start();
        TimeUnit.SECONDS.timedJoin(submThread, 50L);
        submThread.interrupt();
        Assert.assertEquals((double)5.0, (double)counter.sum(), (double)1.0);
    }

    @Test
    public void testRate10HzNonBatch() throws Exception {
        int rateLimit = 10;
        int timeLimitSec = 10;
        RateThrottle throttle = new RateThrottle(10.0);
        Object subj = new Object();
        LongAdder counter = new LongAdder();
        Thread submThread = new Thread(() -> {
            while (true) {
                if (throttle.tryAcquire(subj)) {
                    counter.increment();
                    continue;
                }
                LockSupport.parkNanos(1L);
            }
        });
        submThread.start();
        TimeUnit.SECONDS.timedJoin(submThread, 10L);
        submThread.interrupt();
        Assert.assertEquals((float)100.0f, (float)counter.sum(), (float)1.0f);
    }

    @Test
    public void testRate100kHzNonBatch() throws Exception {
        int rateLimit = 100000;
        int timeLimitSec = 20;
        RateThrottle throttle = new RateThrottle(100000.0);
        Object subj = new Object();
        LongAdder counter = new LongAdder();
        Thread submThread = new Thread(() -> {
            while (true) {
                if (throttle.tryAcquire(subj)) {
                    counter.increment();
                    continue;
                }
                LockSupport.parkNanos(1L);
            }
        });
        submThread.start();
        TimeUnit.SECONDS.timedJoin(submThread, 20L);
        submThread.interrupt();
        Assert.assertEquals((float)2000000.0f, (float)counter.sum(), (float)400000.0f);
    }

    @Test
    public void testRate1HzBatch() throws Exception {
        boolean rateLimit = true;
        int timeLimitSec = 50;
        RateThrottle throttle = new RateThrottle(1.0);
        Object subj = new Object();
        LongAdder counter = new LongAdder();
        Thread submThread = new Thread(() -> {
            while (true) {
                int n;
                if ((n = throttle.tryAcquire(subj, 10)) > 0) {
                    counter.add(n);
                    continue;
                }
                LockSupport.parkNanos(1L);
            }
        });
        submThread.start();
        TimeUnit.SECONDS.timedJoin(submThread, 50L);
        submThread.interrupt();
        Assert.assertEquals((float)50.0f, (float)counter.sum(), (float)10.0f);
    }

    @Test
    public void testRate100HzBatch() throws Exception {
        int rateLimit = 100;
        int timeLimitSec = 50;
        RateThrottle throttle = new RateThrottle(100.0);
        Object subj = new Object();
        LongAdder counter = new LongAdder();
        Thread submThread = new Thread(() -> {
            while (true) {
                int n;
                if ((n = throttle.tryAcquire(subj, 100)) > 0) {
                    counter.add(n);
                    continue;
                }
                LockSupport.parkNanos(1L);
            }
        });
        submThread.start();
        TimeUnit.SECONDS.timedJoin(submThread, 50L);
        submThread.interrupt();
        Assert.assertEquals((float)5000.0f, (float)counter.sum(), (float)500.0f);
    }

    @Test
    public void testRate1MHzBatch() throws Exception {
        int rateLimit = 1000000;
        int timeLimitSec = 10;
        RateThrottle throttle = new RateThrottle(1000000.0);
        Object subj = new Object();
        LongAdder counter = new LongAdder();
        Thread submThread = new Thread(() -> {
            while (true) {
                int n;
                if ((n = throttle.tryAcquire(subj, 100)) > 0) {
                    counter.add(n);
                    continue;
                }
                LockSupport.parkNanos(1L);
            }
        });
        submThread.start();
        TimeUnit.SECONDS.timedJoin(submThread, 10L);
        submThread.interrupt();
        Assert.assertEquals((float)1.0E7f, (float)counter.sum(), (float)2000000.0f);
    }

    @Test
    public void testRate1kHzBatchConcurrent() {
        int rateLimit = 1000;
        int timeLimitSec = 20;
        Object subj = new Object();
        RateThrottle throttle = new RateThrottle(1000.0);
        LongAdder counter = new LongAdder();
        ExecutorService execSvc = Executors.newFixedThreadPool(4);
        int i = 0;
        while (i < 4) {
            int j = i++;
            execSvc.submit(() -> {
                while (true) {
                    if (j == 0) {
                        if (throttle.tryAcquire(subj)) {
                            counter.increment();
                            continue;
                        }
                        LockSupport.parkNanos(1L);
                        continue;
                    }
                    int n = throttle.tryAcquire(subj, 1 + j);
                    if (n > 0) {
                        counter.add(n);
                        continue;
                    }
                    LockSupport.parkNanos(1L);
                }
            });
        }
        execSvc.shutdown();
        try {
            execSvc.awaitTermination(20L, TimeUnit.SECONDS);
            execSvc.shutdownNow();
            Assert.assertEquals((float)20000.0f, (float)counter.sum(), (float)4000.0f);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

