/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.perf;

import com.emc.mongoose.common.io.Input;
import com.emc.mongoose.common.io.Output;
import com.emc.mongoose.model.DaemonBase;
import com.emc.mongoose.model.svc.RoundRobinOutputsTransferSvcTask;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RoundRobinOutputsTransferSvcTaskTest {
    private static final int BATCH_SIZE = 4096;
    private static final int TEST_TIME_LIMIT_SEC = 30;
    private final List<CountingOutput> outputs;
    private final Output rrcOutput;
    private final int outputCount;

    public RoundRobinOutputsTransferSvcTaskTest(int outputCount) throws Exception {
        this.outputCount = outputCount;
        this.outputs = new ArrayList<CountingOutput>(outputCount);
        for (int i = 0; i < outputCount; ++i) {
            this.outputs.add(new CountingOutput());
        }
        try (DaemonMock daemonMock = new DaemonMock();){
            this.rrcOutput = new RoundRobinOutputsTransferSvcTask(this.outputs, daemonMock.getSvcTasks(), 4096);
            Thread t = new Thread(() -> {
                int i;
                Thread currentThread = Thread.currentThread();
                ArrayList<Object> buff = new ArrayList<Object>(4096);
                for (i = 0; i < 4096; ++i) {
                    buff.add(new Object());
                }
                try {
                    while (!currentThread.isInterrupted()) {
                        for (i = 0; i < 4096; i += this.rrcOutput.put(buff, i, 4096)) {
                        }
                    }
                }
                catch (EOFException i2) {
                }
                catch (Throwable e) {
                    Assert.fail((String)e.toString());
                }
            });
            daemonMock.start();
            t.start();
            TimeUnit.SECONDS.timedJoin(t, 30L);
            t.interrupt();
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        return Arrays.asList({1}, {2}, {5}, {10}, {20}, {50}, {100});
    }

    @Test
    public void test() throws Exception {
        long count = 0L;
        for (CountingOutput co : this.outputs) {
            count += co.count.sum();
        }
        System.out.println("Rate for " + this.outputs.size() + " outputs: " + count / 30L);
    }

    private static final class CountingOutput<T>
    implements Output<T> {
        public final LongAdder count = new LongAdder();

        private CountingOutput() {
        }

        public boolean put(T item) throws IOException {
            this.count.increment();
            return true;
        }

        public int put(List<T> buffer, int from, int to) throws IOException {
            this.count.add(to - from);
            return to - from;
        }

        public int put(List<T> buffer) throws IOException {
            this.count.add(buffer.size());
            return buffer.size();
        }

        public Input<T> getInput() throws IOException {
            return null;
        }

        public void close() throws IOException {
        }
    }

    private static final class DaemonMock
    extends DaemonBase {
        private DaemonMock() {
        }

        public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException, RemoteException {
            return false;
        }

        protected void doShutdown() throws IllegalStateException {
        }

        protected void doInterrupt() throws IllegalStateException {
        }
    }
}

