/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.perf;

import com.emc.mongoose.common.concurrent.FutureTaskBase;
import com.emc.mongoose.common.concurrent.ThreadUtil;
import java.util.ArrayList;
import java.util.Deque;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class ThreadPoolExecutorTest {
    private static final int BATCH_SIZE = 4096;
    private static final int QUEUE_SIZE_LIMIT = 1000000;
    private static final int TIME_LIMIT_SEC = 50;

    @Test
    public final void testUnpooledTasksRate() throws Exception {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(ThreadUtil.getHardwareThreadCount(), ThreadUtil.getHardwareThreadCount(), 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000000));
        LongAdder completedTaskCounter = new LongAdder();
        Thread t = new Thread(() -> {
            block4: while (true) {
                UnpooledCounterIncrementTask task = new UnpooledCounterIncrementTask(completedTaskCounter);
                while (true) {
                    try {
                        executor.execute((Runnable)((Object)task));
                        continue block4;
                    }
                    catch (RejectedExecutionException ignored) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            continue block4;
                        }
                    }
                }
                break;
            }
        });
        t.start();
        TimeUnit.SECONDS.timedJoin(t, 50L);
        System.out.println("Unpooled tasks rate: " + completedTaskCounter.sum() / 50L);
        t.interrupt();
        executor.shutdownNow();
    }

    @Test
    public final void testPooledTasksRate() throws Exception {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(ThreadUtil.getHardwareThreadCount(), ThreadUtil.getHardwareThreadCount(), 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000000));
        LongAdder completedTaskCounter = new LongAdder();
        Thread t = new Thread(() -> {
            block4: while (true) {
                PooledCounterIncrementTask task = PooledCounterIncrementTask.getInstance(completedTaskCounter);
                while (true) {
                    try {
                        executor.execute((Runnable)((Object)task));
                        continue block4;
                    }
                    catch (RejectedExecutionException ignored) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            continue block4;
                        }
                    }
                }
                break;
            }
        });
        t.start();
        TimeUnit.SECONDS.timedJoin(t, 50L);
        System.out.println("Pooled tasks rate: " + completedTaskCounter.sum() / 50L);
        t.interrupt();
        executor.shutdownNow();
    }

    @Test
    public final void testPooledTasksRate2() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(ThreadUtil.getHardwareThreadCount());
        ArrayBlockingQueue tasksQueue = new ArrayBlockingQueue(1000000);
        for (int i = 0; i < ThreadUtil.getHardwareThreadCount(); ++i) {
            executor.submit(() -> {
                ArrayList tasksBuff = new ArrayList(4096);
                Thread currentThread = Thread.currentThread();
                while (!currentThread.isInterrupted()) {
                    tasksQueue.drainTo(tasksBuff, 4096);
                    for (RunnableFuture nextTask : tasksBuff) {
                        nextTask.run();
                    }
                    tasksBuff.clear();
                }
            });
        }
        LongAdder completedTaskCounter = new LongAdder();
        Thread t = new Thread(() -> {
            while (true) {
                PooledCounterIncrementTask task = PooledCounterIncrementTask.getInstance(completedTaskCounter);
                try {
                    tasksQueue.put(task);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        t.start();
        TimeUnit.SECONDS.timedJoin(t, 50L);
        System.out.println("Pooled tasks rate 2: " + completedTaskCounter.sum() / 50L);
        t.interrupt();
        executor.shutdownNow();
    }

    @Test
    public final void testUnpooledTasksRate2() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(ThreadUtil.getHardwareThreadCount());
        ArrayBlockingQueue tasksQueue = new ArrayBlockingQueue(1000000);
        for (int i = 0; i < ThreadUtil.getHardwareThreadCount(); ++i) {
            executor.submit(() -> {
                ArrayList tasksBuff = new ArrayList(4096);
                Thread currentThread = Thread.currentThread();
                while (!currentThread.isInterrupted()) {
                    tasksQueue.drainTo(tasksBuff, 4096);
                    for (RunnableFuture nextTask : tasksBuff) {
                        nextTask.run();
                    }
                    tasksBuff.clear();
                }
            });
        }
        LongAdder completedTaskCounter = new LongAdder();
        Thread t = new Thread(() -> {
            while (true) {
                UnpooledCounterIncrementTask task = new UnpooledCounterIncrementTask(completedTaskCounter);
                try {
                    tasksQueue.put(task);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        t.start();
        TimeUnit.SECONDS.timedJoin(t, 50L);
        System.out.println("Unpooled tasks rate 2: " + completedTaskCounter.sum() / 50L);
        t.interrupt();
        executor.shutdownNow();
    }

    private static final class PooledCounterIncrementTask<Void>
    extends FutureTaskBase<Void> {
        private LongAdder sharedCounter;
        private static final Deque<PooledCounterIncrementTask> POOL = new ConcurrentLinkedDeque<PooledCounterIncrementTask>();

        private PooledCounterIncrementTask() {
        }

        public static PooledCounterIncrementTask getInstance(LongAdder sharedCounter) {
            PooledCounterIncrementTask task = POOL.poll();
            if (task == null) {
                task = new PooledCounterIncrementTask();
            }
            task.sharedCounter = sharedCounter;
            return task;
        }

        public final void run() {
            this.sharedCounter.increment();
            POOL.offer(this);
        }
    }

    private static final class UnpooledCounterIncrementTask<Void>
    extends FutureTaskBase<Void> {
        private final LongAdder sharedCounter;

        public UnpooledCounterIncrementTask(LongAdder sharedCounter) {
            this.sharedCounter = sharedCounter;
        }

        public final void run() {
            this.sharedCounter.increment();
        }
    }
}

