/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.perf.util.mock;

import com.emc.mongoose.common.exception.UserShootHisFootException;
import com.emc.mongoose.model.data.ContentSource;
import com.emc.mongoose.model.io.task.IoTask;
import com.emc.mongoose.model.io.task.data.DataIoTask;
import com.emc.mongoose.model.item.DataItem;
import com.emc.mongoose.model.item.Item;
import com.emc.mongoose.model.item.ItemFactory;
import com.emc.mongoose.model.storage.Credential;
import com.emc.mongoose.storage.driver.net.base.NetStorageDriverBase;
import com.emc.mongoose.storage.driver.net.base.pool.NonBlockingConnPool;
import com.emc.mongoose.tests.perf.util.mock.BasicMultiNodeConnPoolMock;
import com.emc.mongoose.ui.config.Config;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.pool.ChannelPoolHandler;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Collections;
import java.util.List;

public final class NetStorageDriverMock<I extends Item, O extends IoTask<I>>
extends NetStorageDriverBase<I, O> {
    public NetStorageDriverMock(String jobName, ContentSource contentSrc, Config.LoadConfig loadConfig, Config.StorageConfig storageConfig, boolean verifyFlag) throws UserShootHisFootException {
        super(jobName, contentSrc, loadConfig, storageConfig, verifyFlag);
    }

    protected final NonBlockingConnPool createConnectionPool() {
        return new BasicMultiNodeConnPoolMock(this.concurrencyLevel, this.concurrencyThrottle, this.storageNodeAddrs, this.bootstrap, (ChannelPoolHandler)this, this.storageNodePort);
    }

    protected final Channel getUnpooledConnection() throws ConnectException, InterruptedException {
        return new EmbeddedChannel();
    }

    public final List<I> list(ItemFactory<I> itemFactory, String path, String prefix, int idRadix, I lastPrevItem, int count) throws IOException {
        return Collections.emptyList();
    }

    protected final String requestNewPath(String path) {
        return path;
    }

    protected final String requestNewAuthToken(Credential credential) {
        return credential == null ? "" : credential.toString();
    }

    protected final void sendRequest(Channel channel, ChannelPromise channelPromise, O ioTask) {
        ioTask.finishRequest();
        ioTask.startResponse();
        if (ioTask instanceof DataIoTask) {
            DataIoTask dataIoTask = (DataIoTask)ioTask;
            DataItem dataItem = dataIoTask.getItem();
            switch (dataIoTask.getIoType()) {
                case CREATE: {
                    try {
                        dataIoTask.setCountBytesDone(dataItem.size());
                    }
                    catch (IOException iOException) {}
                    break;
                }
                case READ: {
                    dataIoTask.startDataResponse();
                }
                case UPDATE: {
                    List fixedByteRanges = dataIoTask.getFixedRanges();
                    if (fixedByteRanges == null || fixedByteRanges.isEmpty()) {
                        if (dataIoTask.hasMarkedRanges()) {
                            dataIoTask.setCountBytesDone(dataIoTask.getMarkedRangesSize());
                            break;
                        }
                        try {
                            dataIoTask.setCountBytesDone(dataItem.size());
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    dataIoTask.setCountBytesDone(dataIoTask.getMarkedRangesSize());
                    break;
                }
            }
            dataIoTask.startDataResponse();
        }
        ioTask.setStatus(IoTask.Status.SUCC);
        this.complete(channel, (IoTask)ioTask);
    }

    public final String toString() {
        return String.format(super.toString(), "mock-net");
    }
}

