/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.perf;

import com.emc.mongoose.api.common.concurrent.ThreadUtil;
import com.emc.mongoose.storage.driver.net.base.pool.ConnLeaseException;
import com.emc.mongoose.storage.driver.net.base.pool.NonBlockingConnPool;
import com.emc.mongoose.tests.perf.util.mock.BasicMultiNodeConnPoolMock;
import com.emc.mongoose.tests.perf.util.mock.DummyChannelPoolHandlerMock;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BasicMultiNodeConnPoolTest {
    private static final int TEST_STEP_TIME_SECONDS = 100;
    private static final int BATCH_SIZE = 4096;
    private int concurrencyLevel;
    private int nodeCount;

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        return Arrays.asList({1, 1}, {10, 1}, {10, 10}, {100, 1}, {100, 10}, {1000, 1}, {1000, 10});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicMultiNodeConnPoolTest(int concurrencyLevel, int nodeCount) {
        this.concurrencyLevel = concurrencyLevel;
        this.nodeCount = nodeCount;
        String[] nodes = new String[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            nodes[i] = Integer.toString(i);
        }
        LongAdder opCount = new LongAdder();
        try (BasicMultiNodeConnPoolMock connPool = new BasicMultiNodeConnPoolMock(concurrencyLevel, new Semaphore(concurrencyLevel), nodes, new Bootstrap(), new DummyChannelPoolHandlerMock(), 9020, 0);){
            ExecutorService poolLoader = Executors.newFixedThreadPool(ThreadUtil.getHardwareThreadCount());
            for (int i = 0; i < ThreadUtil.getHardwareThreadCount(); ++i) {
                poolLoader.submit(() -> BasicMultiNodeConnPoolTest.lambda$new$0((NonBlockingConnPool)connPool, opCount));
            }
            poolLoader.shutdown();
            try {
                poolLoader.awaitTermination(100L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            poolLoader.shutdownNow();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        finally {
            System.out.println("concurrency = " + concurrencyLevel + ", nodes = " + nodeCount + " -> rate: " + opCount.sum() / 100L);
        }
    }

    @Test
    public void test() {
        Assert.assertTrue((boolean)true);
    }

    private static /* synthetic */ void lambda$new$0(NonBlockingConnPool connPool, LongAdder opCount) {
        Thread currThread = Thread.currentThread();
        ArrayList<Channel> connBuff = new ArrayList<Channel>(4096);
        try {
            while (!currThread.isInterrupted()) {
                Channel c;
                int j;
                for (j = 0; j < 4096 && (c = connPool.lease()) != null; ++j) {
                    connBuff.add(c);
                }
                for (int k = 0; k < j; ++k) {
                    connPool.release((Channel)connBuff.get(k));
                    opCount.increment();
                }
                connBuff.clear();
            }
        }
        catch (ConnLeaseException connLeaseException) {
            // empty catch block
        }
    }
}

