/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.tests.perf;

import com.emc.mongoose.api.model.item.CsvFileItemInput;
import com.emc.mongoose.api.model.item.CsvFileItemOutput;
import com.emc.mongoose.api.model.item.IdStringInput;
import com.emc.mongoose.api.model.item.ItemFactory;
import com.emc.mongoose.api.model.item.ItemNameSupplier;
import com.emc.mongoose.api.model.item.ItemNamingType;
import com.emc.mongoose.api.model.item.ItemType;
import com.emc.mongoose.api.model.item.NewDataItemInput;
import com.github.akurilov.commons.system.SizeInBytes;
import java.io.EOFException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CsvFileItemInputTest {
    private static final int BATCH_SIZE = 4096;
    private static final String FILE_NAME = "items.csv";

    @BeforeClass
    public static void setUpClass() throws Exception {
        try {
            Files.delete(Paths.get(FILE_NAME, new String[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public final void testInputRate() throws Exception {
        long count = 100000000L;
        ItemFactory itemFactory = ItemType.getItemFactory((ItemType)ItemType.DATA);
        ArrayList itemBuff = new ArrayList(4096);
        try (NewDataItemInput newItemsInput = new NewDataItemInput(ItemType.getItemFactory((ItemType)ItemType.DATA), (IdStringInput)new ItemNameSupplier(ItemNamingType.ASC, "", 13, 36, 0L), new SizeInBytes("0-1MB,2"));
             CsvFileItemOutput newItemsOutput = new CsvFileItemOutput(Paths.get(FILE_NAME, new String[0]), itemFactory);){
            int m;
            for (long n = 0L; n < 100000000L; n += (long)m) {
                m = newItemsInput.get(itemBuff, 4096);
                for (int i = 0; i < m; i += newItemsOutput.put(itemBuff, i, m)) {
                }
                itemBuff.clear();
            }
        }
        System.out.println("Items input file is ready, starting the input");
        LongAdder inputCounter = new LongAdder();
        long t = System.nanoTime();
        try (CsvFileItemInput fileItemInput = new CsvFileItemInput(Paths.get(FILE_NAME, new String[0]), itemFactory);){
            int n;
            while ((n = fileItemInput.get(itemBuff, 4096)) > 0) {
                inputCounter.add(n);
                itemBuff.clear();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        t = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - t);
        Assert.assertEquals((float)1.0E8f, (float)inputCounter.sum(), (float)4096.0f);
        System.out.println("CSV file input rate: " + 100000000L / t + " items per second");
    }
}

